/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFloat;
import org.jruby.RubyString;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.builtin.IRubyObject;

public final class MemoryUtil {
    private MemoryUtil() {
    }

    public static final IRubyObject getArrayOfSigned8(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        byte[] array = new byte[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newSigned8(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfSigned8(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        byte[] array = new byte[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int8Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfUnsigned8(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        byte[] array = new byte[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newUnsigned8(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfUnsigned8(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        byte[] array = new byte[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)Util.uint8Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfSigned16(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        short[] array = new short[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newSigned16(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfSigned16(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        short[] array = new short[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int16Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfUnsigned16(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        short[] array = new short[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newUnsigned16(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfUnsigned16(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        short[] array = new short[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (short)Util.uint16Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfSigned32(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        int[] array = new int[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newSigned32(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfSigned32(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        int[] array = new int[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int32Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfUnsigned32(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        int[] array = new int[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newUnsigned32(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfUnsigned32(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        int[] array = new int[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (int)Util.uint32Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfSigned64(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        long[] array = new long[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newSigned64(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfSigned64(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        long[] array = new long[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.int64Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfUnsigned64(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        long[] array = new long[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(Util.newUnsigned64(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfUnsigned64(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        long[] array = new long[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.uint64Value(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfFloat32(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        float[] array = new float[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFloat.newFloat(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfFloat32(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        float[] array = new float[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.floatValue(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final IRubyObject getArrayOfFloat64(Ruby runtime2, MemoryIO io2, long offset2, int count2) {
        double[] array = new double[count2];
        io2.get(offset2, array, 0, array.length);
        RubyArray arr = RubyArray.newArray(runtime2, array.length);
        for (int i = 0; i < array.length; ++i) {
            arr.add(RubyFloat.newFloat(runtime2, array[i]));
        }
        return arr;
    }

    public static final void putArrayOfFloat64(Ruby runtime2, MemoryIO io2, long offset2, RubyArray ary) {
        double[] array = new double[ary.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Util.doubleValue(ary.entry(i));
        }
        io2.put(offset2, array, 0, array.length);
    }

    public static final RubyString newTaintedString(Ruby runtime2, byte[] bytes2) {
        RubyString s = RubyString.newStringNoCopy(runtime2, bytes2);
        s.setTaint(true);
        return s;
    }

    public static final RubyString getTaintedByteString(Ruby runtime2, MemoryIO io2, long offset2, int length2) {
        byte[] bytes2 = new byte[length2];
        io2.get(offset2, bytes2, 0, bytes2.length);
        return MemoryUtil.newTaintedString(runtime2, bytes2);
    }

    public static final IRubyObject getTaintedString(Ruby runtime2, MemoryIO io2, long offset2) {
        return MemoryUtil.newTaintedString(runtime2, io2.getZeroTerminatedByteArray(offset2));
    }

    public static final IRubyObject getTaintedString(Ruby runtime2, MemoryIO io2, long offset2, int length2) {
        return MemoryUtil.newTaintedString(runtime2, io2.getZeroTerminatedByteArray(offset2, length2));
    }
}

