/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow.analyses;

import java.util.HashSet;
import java.util.Set;
import org.jruby.compiler.ir.IR_Closure;
import org.jruby.compiler.ir.dataflow.DataFlowConstants;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.dataflow.FlowGraphNode;
import org.jruby.compiler.ir.dataflow.analyses.FrameStorePlacementNode;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.BasicBlock;

public class FrameStorePlacementProblem
extends DataFlowProblem {
    private Set<Variable> _usedVars = new HashSet<Variable>();
    private Set<Variable> _defVars = new HashSet<Variable>();

    public FrameStorePlacementProblem() {
        super(DataFlowProblem.DF_Direction.FORWARD);
    }

    public String getName() {
        return "Frame Stores Placement Analysis";
    }

    public FlowGraphNode buildFlowGraphNode(BasicBlock bb) {
        return new FrameStorePlacementNode(this, bb);
    }

    public String getDataFlowVarsForOutput() {
        return "";
    }

    public void recordUsedVar(Variable v) {
        this._usedVars.add(v);
    }

    public void recordDefVar(Variable v) {
        this._defVars.add(v);
    }

    public boolean scopeDefinesVariable(Variable v) {
        if (this._defVars.contains(v)) {
            return true;
        }
        for (IR_Closure cl : this.getCFG().getScope().getClosures()) {
            FrameStorePlacementProblem nestedProblem = (FrameStorePlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.FSP_NAME);
            if (!nestedProblem.scopeDefinesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public boolean scopeUsesVariable(Variable v) {
        if (this._usedVars.contains(v)) {
            return true;
        }
        for (IR_Closure cl : this.getCFG().getScope().getClosures()) {
            FrameStorePlacementProblem nestedProblem = (FrameStorePlacementProblem)cl.getCFG().getDataFlowSolution(DataFlowConstants.FSP_NAME);
            if (!nestedProblem.scopeUsesVariable(v)) continue;
            return true;
        }
        return false;
    }

    public void addStoreAndFrameAllocInstructions() {
        for (FlowGraphNode n : this._fgNodes) {
            FrameStorePlacementNode fspn = (FrameStorePlacementNode)n;
            fspn.addStoreAndFrameAllocInstructions();
        }
    }
}

