/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import java.io.FileDescriptor;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.JavaLibCHelper;
import org.jruby.ext.posix.LibC;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.WindowsFileStat;

public class WindowsPOSIX
extends BaseNativePOSIX {
    JavaLibCHelper helper;

    public WindowsPOSIX(String libraryName, LibC libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
        this.helper = new JavaLibCHelper(handler);
    }

    public FileStat allocateStat() {
        return new WindowsFileStat(this);
    }

    public int kill(int pid, int signal) {
        this.handler.unimplementedError("kill");
        return -1;
    }

    public int chown(String filename, int user, int group) {
        this.handler.unimplementedError("chown");
        return -1;
    }

    public int getegid() {
        this.handler.unimplementedError("egid");
        return -1;
    }

    public int setegid(int egid) {
        this.handler.unimplementedError("setegid");
        return -1;
    }

    public int geteuid() {
        return 0;
    }

    public int seteuid(int euid) {
        this.handler.unimplementedError("seteuid");
        return -1;
    }

    public int getuid() {
        return 0;
    }

    public int setuid(int uid) {
        this.handler.unimplementedError("setuid");
        return -1;
    }

    public int getgid() {
        this.handler.unimplementedError("getgid");
        return -1;
    }

    public int setgid(int gid) {
        this.handler.unimplementedError("setgid");
        return -1;
    }

    public int getpgid(int pid) {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int getpgid() {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int setpgid(int pid, int pgid) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    public int getpriority(int which, int who) {
        this.handler.unimplementedError("getpriority");
        return -1;
    }

    public int setpriority(int which, int who, int prio) {
        this.handler.unimplementedError("setpriority");
        return -1;
    }

    public int getppid() {
        return 0;
    }

    public int lchmod(String filename, int mode) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public int lchown(String filename, int user, int group) {
        this.handler.unimplementedError("lchown");
        return -1;
    }

    public FileStat lstat(String path) {
        return this.stat(path);
    }

    public String readlink(String oldpath) {
        this.handler.unimplementedError("readlink");
        return null;
    }

    public int wait(int[] status) {
        this.handler.unimplementedError("wait");
        return -1;
    }

    public int waitpid(int pid, int[] status, int flags) {
        this.handler.unimplementedError("waitpid");
        return -1;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int endgrent() {
        return 0;
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public Group getgrent() {
        return null;
    }

    public Passwd getpwent() {
        return null;
    }

    public Group getgrgid(int which) {
        return null;
    }

    public Passwd getpwnam(String which) {
        return null;
    }

    public Group getgrnam(String which) {
        return null;
    }

    public int setgrent() {
        return 0;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public Passwd getpwuid(int which) {
        return null;
    }

    public boolean isatty(FileDescriptor fd) {
        return fd == FileDescriptor.in || fd == FileDescriptor.out || fd == FileDescriptor.err;
    }
}

