/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.model.EncodingInputStream;
import org.netbeans.modules.mobility.svgcore.model.SVGFileModel;
import org.netbeans.modules.mobility.svgcore.view.source.SVGSourceMultiViewElement;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.openide.util.NbBundle;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class ParsingTask
extends Thread
implements HyperlinkListener {
    private static final String HTML_BEGIN = "<html><body><font face=\"Monospaced\" size=\"4\" color=\"black\">";
    private static final String HTML_END = "</font></body><html>";
    private static final String PARSE_TOKEN = "parse";
    private static final Logger LOG = Logger.getLogger(ParsingTask.class.getName());
    private final SVGDataObject m_dObj;
    private final JPanel m_panel;
    private final JEditorPane m_textPane;
    private final SVGViewTopComponent m_svgView;

    public ParsingTask(SVGDataObject dObj, SVGViewTopComponent svgView) throws Exception {
        this.m_dObj = dObj;
        this.m_svgView = svgView;
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new BorderLayout());
        this.m_panel.setBackground(Color.WHITE);
        StringBuilder sb = new StringBuilder(HTML_BEGIN);
        sb.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"MSG_Parsing"));
        sb.append(HTML_END);
        this.m_textPane = new JEditorPane("text/html", sb.toString());
        this.m_textPane.setBackground(Color.WHITE);
        this.m_textPane.setEditable(false);
        this.m_textPane.addHyperlinkListener(this);
        this.m_panel.add((Component)new JScrollPane(this.m_textPane), "Center");
        this.setPriority(1);
        this.setDaemon(true);
        if (this.m_svgView.getBasePanel().getComponentCount() == 0) {
            this.initializeReportView();
            this.m_svgView.repaint();
        }
    }

    public JComponent getPanel() {
        return this.m_panel;
    }

    public void cancel() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                SVGFileModel fileModel = this.m_dObj.getModel();
                try {
                    this.m_dObj.getSceneManager().setBusyState(PARSE_TOKEN, true);
                    System.setErr(new PrintStream(new OutputStream(){

                        @Override
                        public void write(int b) throws IOException {
                        }
                    }));
                    if (!Thread.currentThread().isInterrupted()) {
                        final SVGImage svgImage = fileModel.parseSVGImage();
                        assert (svgImage != null);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ParsingTask.this.m_svgView.showImage(svgImage);
                            }
                        });
                        break block11;
                    }
                    throw new InterruptedException();
                }
                catch (InterruptedException ie) {
                    LOG.log(Level.INFO, null, ie);
                }
                catch (Exception e) {
                    DocumentModel docModel = fileModel.getModel();
                    Document doc = docModel != null ? docModel.getDocument() : null;
                    this.showParsingErrors(doc, e);
                }
                finally {
                    this.m_dObj.getSceneManager().setBusyState(PARSE_TOKEN, false);
                    System.setErr(System.err);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        int[] position;
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && e.getDescription() != null && (position = ParsingTask.string2position(e.getDescription())) != null) {
            SVGFileModel fileModel = this.m_dObj.getModel();
            int offset = fileModel.getOffsetByPosition(position[0], position[1]);
            SVGSourceMultiViewElement.selectPosition(this.m_dObj, offset, true);
        }
    }

    private String composeMessageText(List<ErrorDescription> errors) {
        StringBuilder sb = new StringBuilder(HTML_BEGIN);
        sb.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERR_NotSvgTiny"));
        sb.append("<font size=\"4\" color=\"blue\">");
        int[] errNum = new int[3];
        for (ErrorDescription error : errors) {
            int n = error.m_severity;
            errNum[n] = errNum[n] + 1;
            sb.append("<br>");
            if (error.m_line != -1) {
                sb.append("<a href=\"");
                sb.append(ParsingTask.position2string(error.m_line, error.m_column));
                sb.append("\">");
                sb.append(error.getSeverity());
                sb.append(": ");
                sb.append(error.m_line);
                sb.append(",");
                sb.append(error.m_column);
                sb.append(":");
                sb.append(error.m_text);
                sb.append("</a>");
                continue;
            }
            sb.append("<font color=\"black\">");
            sb.append(error.getSeverity());
            sb.append(": ");
            sb.append(error.m_text);
            sb.append("</font>");
        }
        sb.append("</font>");
        sb.append("<br>");
        sb.append(NbBundle.getMessage(SVGViewTopComponent.class, (String)"ERR_ErrorWarnings", (Object)Integer.toString(errNum[0]), (Object)Integer.toString(errNum[1]), (Object)Integer.toString(errNum[2])));
        sb.append(HTML_END);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showParsingErrors(Document doc, Exception perseusException) {
        final ArrayList<ErrorDescription> errors = new ArrayList<ErrorDescription>();
        errors.add(new ErrorDescription(perseusException));
        if (doc != null) {
            ErrorHandler errorHandler = new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    this.addError(new ErrorDescription(e, 2));
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    this.addError(new ErrorDescription(e, 0));
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    this.addError(new ErrorDescription(e, 1));
                }

                private void addError(ErrorDescription errDesc) {
                    for (ErrorDescription ed : errors) {
                        if (!ed.m_text.equals(errDesc.m_text)) continue;
                        if (ed.m_line == -1 && errDesc.m_line != -1) {
                            ed.m_line = errDesc.m_line;
                            ed.m_column = errDesc.m_column;
                        }
                        return;
                    }
                    errors.add(errDesc);
                }
            };
            EncodingInputStream in = new EncodingInputStream((BaseDocument)doc, this.m_dObj.getEncodingHelper().getEncoding());
            try {
                InputSource isource = new InputSource(in);
                XMLUtil.parse((InputSource)isource, (boolean)true, (boolean)true, (ErrorHandler)errorHandler, (EntityResolver)EntityCatalog.getDefault());
            }
            catch (SAXException e) {
            }
            catch (ConnectException e) {
            }
            catch (Exception e) {
                SceneManager.error("Error during document parse", e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    SceneManager.error("Could not close stream", ex);
                }
            }
        }
        for (ErrorDescription ed : errors) {
            ed.fillNumbers(this.m_dObj.getModel());
        }
        this.updateText(this.composeMessageText(errors));
    }

    private void initializeReportView() {
        JPanel basePanel = this.m_svgView.getBasePanel();
        if (basePanel.getComponentCount() > 0) {
            if (basePanel.getComponent(0) == this.m_panel) {
                return;
            }
            basePanel.removeAll();
        }
        basePanel.add((Component)this.m_panel, "Center");
        basePanel.invalidate();
    }

    private void updateText(final String errorMsg) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ParsingTask.this.initializeReportView();
                ParsingTask.this.m_textPane.setText(errorMsg);
                ParsingTask.this.m_textPane.invalidate();
                ParsingTask.this.m_svgView.validate();
                ParsingTask.this.m_svgView.repaint();
            }
        });
    }

    private static String position2string(int lineNum, int colNumber) {
        return lineNum + "_" + colNumber;
    }

    private static int[] string2position(String str) {
        int[] position = null;
        String[] parts = str.split("_");
        if (parts.length == 2) {
            try {
                position = new int[]{Integer.parseInt(parts[0]), Integer.parseInt(parts[1])};
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return position;
    }

    private static final class ErrorDescription {
        private static final int SEVERITY_FATAL = 0;
        private static final int SEVERITY_ERROR = 1;
        private static final int SEVERITY_WARNING = 2;
        private static final String[] SEVERITIES = new String[]{"Fatal Error", "Error", "Warning"};
        final String m_text;
        final int m_severity;
        int m_line;
        int m_column;

        public ErrorDescription(SAXParseException e, int severity) {
            assert (e != null);
            this.m_text = ErrorDescription.getMessage(e);
            this.m_severity = severity;
            this.m_line = e.getLineNumber();
            this.m_column = e.getColumnNumber();
        }

        public ErrorDescription(Exception e) {
            this.m_text = ErrorDescription.getMessage(e);
            this.m_severity = 0;
            this.m_column = -1;
            this.m_line = -1;
        }

        public String getSeverity() {
            return SEVERITIES[this.m_severity];
        }

        public void fillNumbers(SVGFileModel fileModel) {
            int[] pos;
            String invalidValue;
            int p2;
            int p1;
            if (this.m_line == -1 && (p1 = this.m_text.indexOf(34)) != -1 && this.m_text.indexOf("\" is missing on element") == -1 && (p2 = this.m_text.lastIndexOf(34)) > p1 && (p2 = fileModel.firstIndexOf(invalidValue = this.m_text.substring(p1, p2 + 1))) != -1 && (pos = fileModel.getPositionByOffset(p2)) != null) {
                this.m_line = pos[0];
                this.m_column = pos[1];
            }
        }

        private static String getMessage(Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg == null) {
                msg = e.getClass().getName();
            }
            return msg;
        }
    }
}

