/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.J2SEPlatformModule;
import org.netbeans.modules.java.j2seplatform.UpdateLogger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.util.Exceptions;

public final class UpdateTask
implements Runnable {
    private static final Logger LOG = Logger.getLogger(UpdateLogger.class.getName());
    private static final UpdateTask instance = new UpdateTask();
    private final AtomicBoolean done = new AtomicBoolean();

    private UpdateTask() {
    }

    public static UpdateTask getDefault() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOG.fine("Requesting update");
        if (!this.done.getAndSet(true)) {
            boolean success = false;
            try {
                UpdateTask.updateBuildProperties();
                success = true;
                LOG.fine("Update: " + (success ? "OK" : "Failed"));
            }
            catch (Throwable throwable) {
                LOG.fine("Update: " + (success ? "OK" : "Failed"));
                throw throwable;
            }
        }
    }

    private static boolean updateSourceLevel(EditableProperties ep) {
        JavaPlatform platform = JavaPlatformManager.getDefault().getDefaultPlatform();
        String ver = platform.getSpecification().getVersion().toString();
        if (!ver.equals(ep.getProperty("default.javac.source"))) {
            ep.setProperty("default.javac.source", ver);
            ep.setProperty("default.javac.target", ver);
            return true;
        }
        return false;
    }

    private static boolean updateBuildProperties(EditableProperties ep) {
        boolean changed = false;
        JavaPlatform[] installedPlatforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < installedPlatforms.length; ++i) {
            String systemName;
            String key;
            if (installedPlatforms[i].equals(JavaPlatformManager.getDefault().getDefaultPlatform()) || !(installedPlatforms[i] instanceof J2SEPlatformImpl) || ep.containsKey((Object)(key = PlatformConvertor.createName(systemName = ((J2SEPlatformImpl)installedPlatforms[i]).getAntName(), "home")))) continue;
            try {
                PlatformConvertor.generatePlatformProperties(installedPlatforms[i], systemName, ep);
                changed = true;
                continue;
            }
            catch (PlatformConvertor.BrokenPlatformException b) {
                Logger.getLogger(J2SEPlatformModule.class.getName()).info("Platform: " + installedPlatforms[i].getDisplayName() + " is missing: " + b.getMissingTool());
                continue;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return changed;
    }

    private static void updateBuildProperties() {
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    EditableProperties ep = PropertyUtils.getGlobalProperties();
                    boolean save = UpdateTask.updateSourceLevel(ep);
                    if (save |= UpdateTask.updateBuildProperties(ep)) {
                        PropertyUtils.putGlobalProperties((EditableProperties)ep);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        });
    }
}

