/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class RubyPreferences {
    private static final String FIRST_TIME_KEY = "platform-manager-called-first-time";
    private static final String FETCH_ALL_VERSIONS = "gem-manager-fetch-all-versions";
    private static final String FETCH_GEM_DESCRIPTIONS = "gem-manager-fetch-descriptions";
    private static final String GEM_VERBOSE_OUTPUT = "gem-manager-verbose-output";
    private static final String INDEX_VENDOR_GEMS_ONLY = "rails-index-vendor-gems-only";
    public static final String VENDOR_GEMS_PROPERTY = "vendor-gems";
    private static final RubyPreferences INSTANCE = new RubyPreferences();
    private static final PropertyChangeSupport changeSupport = new PropertyChangeSupport(INSTANCE);
    private static Preferences preferences;

    private RubyPreferences() {
    }

    public static RubyPreferences getInstance() {
        return INSTANCE;
    }

    public static synchronized Preferences getPreferences() {
        if (preferences == null) {
            preferences = NbPreferences.forModule(RubyPreferences.class);
        }
        return preferences;
    }

    public static void setFirstPlatformTouch(boolean b) {
        RubyPreferences.getPreferences().putBoolean(FIRST_TIME_KEY, b);
    }

    public static boolean isFirstPlatformTouch() {
        return RubyPreferences.getPreferences().getBoolean(FIRST_TIME_KEY, true);
    }

    public static boolean shallFetchAllVersions() {
        return RubyPreferences.getPreferences().getBoolean(FETCH_ALL_VERSIONS, false);
    }

    public static void setFetchAllVersions(boolean fetchAll) {
        RubyPreferences.getPreferences().putBoolean(FETCH_ALL_VERSIONS, fetchAll);
    }

    public static boolean shallFetchGemDescriptions() {
        return RubyPreferences.getPreferences().getBoolean(FETCH_GEM_DESCRIPTIONS, false);
    }

    public static void setFetchGemDescriptions(boolean fetchDescriptions) {
        RubyPreferences.getPreferences().putBoolean(FETCH_GEM_DESCRIPTIONS, fetchDescriptions);
    }

    public static boolean isGemVerboseOutput() {
        return RubyPreferences.getPreferences().getBoolean(GEM_VERBOSE_OUTPUT, true);
    }

    public static void setGemVerboseOutput(boolean verbose) {
        RubyPreferences.getPreferences().putBoolean(GEM_VERBOSE_OUTPUT, verbose);
    }

    public static boolean isIndexVendorGemsOnly() {
        return RubyPreferences.getPreferences().getBoolean(INDEX_VENDOR_GEMS_ONLY, false);
    }

    public static void setIndexVendorGemsOnly(boolean vendorGemsOnly) {
        boolean oldValue = RubyPreferences.isIndexVendorGemsOnly();
        RubyPreferences.getPreferences().putBoolean(INDEX_VENDOR_GEMS_ONLY, vendorGemsOnly);
        if (oldValue != vendorGemsOnly) {
            changeSupport.firePropertyChange(VENDOR_GEMS_PROPERTY, oldValue, vendorGemsOnly);
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        changeSupport.removePropertyChangeListener(listener);
    }
}

