/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.IssueAccessorImpl;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.openide.nodes.Node;

public abstract class Issue {
    private static final int SHORT_DISP_NAME_LENGTH = 15;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String EVENT_ISSUE_DATA_CHANGED = "issue.data_changed";
    private Repository repository;
    private Node[] selection;

    public Issue(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public abstract String getDisplayName();

    public String getShortenedDisplayName() {
        int limit;
        String displayName = this.getDisplayName();
        int length = displayName.length();
        if (length <= (limit = 15)) {
            return displayName;
        }
        String trimmed = displayName.substring(0, limit).trim();
        StringBuilder buf = new StringBuilder(limit + 4);
        buf.append(trimmed);
        if (length > limit + 1 && Character.isSpaceChar(displayName.charAt(limit))) {
            buf.append(' ');
        }
        buf.append("...");
        return buf.toString();
    }

    public abstract String getTooltip();

    public abstract String getID();

    public abstract String getSummary();

    public abstract boolean isNew();

    public abstract boolean refresh();

    public abstract void addComment(String var1, boolean var2);

    public abstract void attachPatch(File var1, String var2);

    public abstract BugtrackingController getController();

    public static void open(Repository repository, String issueId) {
        if (issueId == null) {
            IssueAction.createIssue(repository);
        } else {
            IssueAction.openIssue(repository, issueId);
        }
    }

    public final void open() {
        this.open(false);
    }

    public final void open(boolean refresh) {
        IssueAction.openIssue(this, refresh);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    protected void fireDataChanged() {
        this.support.firePropertyChange(EVENT_ISSUE_DATA_CHANGED, null, null);
    }

    void setSelection(Node[] nodes) {
        this.selection = nodes;
    }

    protected Node[] getSelection() {
        return this.selection;
    }

    static {
        IssueAccessorImpl.create();
    }
}

