/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.builder.AbstractComponentBuildListener;
import org.codehaus.plexus.component.builder.ComponentBuilder;
import org.codehaus.plexus.component.builder.XBeanComponentBuilder;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.PhaseExecutionException;

public abstract class AbstractComponentManager
implements ComponentManager,
Cloneable {
    protected MutablePlexusContainer container;
    protected ComponentDescriptor componentDescriptor;
    protected ComponentBuilder builder;
    private LifecycleHandler lifecycleHandler;
    protected Map componentContextRealms = Collections.synchronizedMap(new HashMap());
    private int connections;

    protected AbstractComponentManager() {
        this.builder = this.createComponentBuilder();
    }

    protected ComponentBuilder createComponentBuilder() {
        return new XBeanComponentBuilder(this);
    }

    public ComponentManager copy() {
        try {
            AbstractComponentManager componentManager = (AbstractComponentManager)this.clone();
            componentManager.builder = componentManager.createComponentBuilder();
            return componentManager;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public ComponentDescriptor getComponentDescriptor() {
        return this.componentDescriptor;
    }

    public LifecycleHandler getLifecycleHandler() {
        return this.lifecycleHandler;
    }

    protected void incrementConnectionCount() {
        ++this.connections;
    }

    protected void decrementConnectionCount() {
        --this.connections;
    }

    protected boolean connected() {
        return this.connections > 0;
    }

    public int getConnections() {
        return this.connections;
    }

    public void setup(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor componentDescriptor) {
        this.container = container;
        this.lifecycleHandler = lifecycleHandler;
        this.componentDescriptor = componentDescriptor;
    }

    public void initialize() {
    }

    protected Object createComponentInstance(ClassRealm realm) throws ComponentInstantiationException, ComponentLifecycleException {
        return this.builder.build(this.componentDescriptor, realm, new AbstractComponentBuildListener(){

            public void componentCreated(ComponentDescriptor componentDescriptor, Object component, ClassRealm realm) {
                AbstractComponentManager.this.componentContextRealms.put(component, realm);
            }
        });
    }

    protected void endComponentLifecycle(Object component) throws ComponentLifecycleException {
        ClassRealm contextRealm = (ClassRealm)this.componentContextRealms.remove(component);
        if (contextRealm == null) {
            contextRealm = this.container.getLookupRealm(component);
        }
        try {
            this.getLifecycleHandler().end(component, this, contextRealm);
        }
        catch (PhaseExecutionException e) {
            throw new ComponentLifecycleException("Error ending component lifecycle", e);
        }
    }

    public MutablePlexusContainer getContainer() {
        return this.container;
    }

    public Logger getLogger() {
        return this.container.getLogger();
    }

    public Object getComponent() throws ComponentInstantiationException, ComponentLifecycleException {
        return this.getComponent(this.container.getLookupRealm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dissociateComponentRealm(ClassRealm realm) throws ComponentLifecycleException {
        Set entries = this.componentContextRealms.entrySet();
        Map map = this.componentContextRealms;
        synchronized (map) {
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ClassRealm componentRealm = (ClassRealm)entry.getValue();
                if (!componentRealm.getId().equals(realm.getId())) continue;
                it.remove();
            }
        }
    }
}

