/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.util.StringPattern;

public class SimpleStringPattern
implements StringPattern {
    private static final char MATCH_EACH = '*';
    private static final char MATCH_ONE = '?';
    private final List subPatterns = new LinkedList();

    public SimpleStringPattern(String definition) {
        this.splitInSubPattern(definition);
    }

    public boolean doesMatch(String string) {
        int index = 0;
        SubPattern subPattern = null;
        Iterator it = this.subPatterns.iterator();
        while (it.hasNext()) {
            subPattern = (SubPattern)it.next();
            index = subPattern.doesMatch(string, index);
            if (index >= 0) continue;
            return false;
        }
        if (index == string.length()) {
            return true;
        }
        if (subPattern == null) {
            return false;
        }
        return subPattern.checkEnding(string, index);
    }

    private void splitInSubPattern(String definition) {
        int prevSubPattern = 32;
        int prevIndex = 0;
        int index = 0;
        while (index >= 0) {
            String match;
            prevIndex = index;
            if ((index = definition.indexOf(42, prevIndex)) >= 0) {
                match = definition.substring(prevIndex, index);
                this.addSubPattern(match, (char)prevSubPattern);
                prevSubPattern = 42;
                ++index;
                continue;
            }
            index = definition.indexOf(63, prevIndex);
            if (index < 0) continue;
            match = definition.substring(prevIndex, index);
            this.addSubPattern(match, (char)prevSubPattern);
            prevSubPattern = 63;
            ++index;
        }
        String match = definition.substring(prevIndex);
        this.addSubPattern(match, (char)prevSubPattern);
    }

    private void addSubPattern(String match, char subPatternMode) {
        SubPattern subPattern = null;
        switch (subPatternMode) {
            case '*': {
                subPattern = new MatchEachCharPattern(match);
                break;
            }
            case '?': {
                subPattern = new MatchOneCharPattern(match);
                break;
            }
            default: {
                subPattern = new MatchExactSubPattern(match);
            }
        }
        this.subPatterns.add(subPattern);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.subPatterns.iterator();
        while (it.hasNext()) {
            SubPattern subPattern = (SubPattern)it.next();
            buffer.append(subPattern.toString());
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimpleStringPattern)) {
            return false;
        }
        return ((Object)this.subPatterns).equals(((SimpleStringPattern)obj).subPatterns);
    }

    public int hashCode() {
        return -((Object)this.subPatterns).hashCode();
    }

    public static void main(String[] arguments) {
        SimpleStringPattern sp = new SimpleStringPattern("a*b");
        SimpleStringPattern.test(sp, "ab", true);
        SimpleStringPattern.test(sp, "aab", true);
        SimpleStringPattern.test(sp, "ba", false);
        SimpleStringPattern.test(sp, "abc", false);
        sp = new SimpleStringPattern("*.txt");
        SimpleStringPattern.test(sp, "datei.txt", true);
        SimpleStringPattern.test(sp, ".txt", true);
        SimpleStringPattern.test(sp, "datei.tx", false);
        SimpleStringPattern.test(sp, "datei.txt.txt", true);
        sp = new SimpleStringPattern("datei*1*");
        SimpleStringPattern.test(sp, "datei0.txt", false);
        SimpleStringPattern.test(sp, "datei1.txt", true);
        SimpleStringPattern.test(sp, "datei.tx", false);
        SimpleStringPattern.test(sp, "datei1.txt.txt", true);
        sp = new SimpleStringPattern("Makefile");
        SimpleStringPattern.test(sp, "Makefile", true);
        SimpleStringPattern.test(sp, "Makefile.mak", false);
        SimpleStringPattern.test(sp, "Makefile1", false);
        SimpleStringPattern.test(sp, ".Makefile", false);
        SimpleStringPattern.test(sp, ".Makefile.", false);
        sp = new SimpleStringPattern("*~");
        SimpleStringPattern.test(sp, "datei~", true);
        SimpleStringPattern.test(sp, "datei~1", false);
        SimpleStringPattern.test(sp, "datei~1~", true);
        SimpleStringPattern pattern1 = new SimpleStringPattern("*.class");
        SimpleStringPattern pattern2 = new SimpleStringPattern("*.class");
        System.err.println(pattern1 + ".equals(" + pattern2 + ") = " + pattern1.equals(pattern2));
        pattern1 = new SimpleStringPattern("?.class");
        pattern2 = new SimpleStringPattern("*.class");
        System.err.println(pattern1 + ".equals(" + pattern2 + ") = " + pattern1.equals(pattern2));
        pattern1 = new SimpleStringPattern("*.clazz");
        pattern2 = new SimpleStringPattern("*.class");
        System.err.println(pattern1 + ".equals(" + pattern2 + ") = " + pattern1.equals(pattern2));
    }

    private static void test(StringPattern sp, String testString, boolean shouldResult) {
        System.err.print('\"' + sp.toString() + '\"' + ": " + testString + " " + shouldResult);
        boolean doesMatch = sp.doesMatch(testString);
        if (doesMatch == shouldResult) {
            System.err.println(" proved");
        } else {
            System.err.println(" **denied**");
        }
    }

    private static class MatchOneCharPattern
    extends MatchExactSubPattern {
        public MatchOneCharPattern(String match) {
            super(match);
        }

        public int doesMatch(String string, int index) {
            if (string.length() < ++index) {
                return -1;
            }
            return super.doesMatch(string, index);
        }

        public String toString() {
            return '?' + this.match;
        }
    }

    private static class MatchEachCharPattern
    extends SubPattern {
        public MatchEachCharPattern(String match) {
            super(match);
        }

        public int doesMatch(String string, int index) {
            int matchIndex = string.indexOf(this.match, index);
            if (matchIndex < 0) {
                return -1;
            }
            return matchIndex + this.match.length();
        }

        public boolean checkEnding(String string, int index) {
            return string.endsWith(this.match);
        }

        public String toString() {
            return '*' + this.match;
        }
    }

    private static class MatchExactSubPattern
    extends SubPattern {
        public MatchExactSubPattern(String match) {
            super(match);
        }

        public int doesMatch(String string, int index) {
            if (!string.startsWith(this.match, index)) {
                return -1;
            }
            return index + this.match.length();
        }

        public String toString() {
            return this.match;
        }
    }

    private static abstract class SubPattern {
        protected final String match;

        protected SubPattern(String match) {
            this.match = match;
        }

        public abstract int doesMatch(String var1, int var2);

        public boolean checkEnding(String string, int index) {
            return false;
        }

        public boolean equals(Object obj) {
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            return this.match.equals(((SubPattern)obj).match);
        }

        public int hashCode() {
            return -this.match.hashCode();
        }
    }
}

