/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import org.netbeans.microedition.svg.SVGComponent;
import org.netbeans.microedition.svg.SVGForm;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLocatableElement;

public class SVGLabel
extends SVGComponent {
    private static final String TEXT_SUFFIX = "_text";
    private SVGLocatableElement myText;

    public SVGLabel(SVGForm form, String elemId) {
        super(form, elemId);
        this.myText = (SVGLocatableElement)this.getElementById((SVGElement)this.getElement(), this.getElement().getId() + TEXT_SUFFIX);
        if (this.myText == null) {
            this.myText = (SVGLocatableElement)this.getNestedElementByMeta((SVGElement)this.getElement(), "type", "text");
        }
        this.verify();
        this.setFocusable(false);
    }

    public SVGLabel(SVGForm form, SVGLocatableElement element) {
        super(form, element);
    }

    public void setLabelFor(SVGComponent component) {
        this.setProperty("labelFor", component);
    }

    public SVGComponent getLabelFor() {
        return (SVGComponent)this.getProperty("labelFor");
    }

    public void setText(String text) {
        if (this.myText == null) {
            throw new IllegalArgumentException("No nested text element found");
        }
        this.setTraitSafely((SVGElement)this.myText, "#text", text);
    }

    public String getText() {
        if (this.myText == null) {
            return null;
        }
        return this.myText.getTrait("#text");
    }

    private void verify() {
        if (this.myText == null) {
            throw new IllegalArgumentException("Element with id= " + this.getElement().getId() + " couldn't be Label element." + " Cannot find nested 'text' element. See javadoc" + " for SVG snippet.");
        }
    }
}

