/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Arrays;
import java.util.Collection;

public enum HtmlVersion {
    UNKNOWN(new String[0], "-//W3C//DTD HTML 4.01 Transitional//EN"),
    HTML32(new String[]{"-//W3C//DTD HTML 3.2 Final//EN"}, "-//W3C//DTD HTML 3.2 Final//EN"),
    HTML40(new String[]{"-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD HTML 4.0 Transitional//EN", "-//W3C//DTD HTML 4.0 Frameset//EN"}, "-//W3C//DTD HTML 4.0 Transitional//EN"),
    HTML41(new String[]{"-//W3C//DTD HTML 4.01//EN", "-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01 Frameset//EN"}, "-//W3C//DTD HTML 4.01 Transitional//EN"),
    XHTML10(new String[]{"-//W3C//DTD XHTML 1.0 Strict//EN", "-//W3C//DTD XHTML 1.0 Transitional//EN", "-//W3C//DTD XHTML 1.0 Frameset//EN"}, "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://www.w3.org/1999/xhtml", true),
    XHTML11(new String[]{"-//W3C//DTD XHTML 1.1//EN"}, "-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/1999/xhtml", true);

    private final String[] publicIDs;
    private final String defaultNamespace;
    private boolean isXhtml;
    private String fallbackPublicId;

    public static HtmlVersion findHtmlVersion(String publicId) {
        for (HtmlVersion version : HtmlVersion.values()) {
            if (!version.getPublicIDs().contains(publicId)) continue;
            return version;
        }
        return UNKNOWN;
    }

    private HtmlVersion(String[] publicIDs, String fallbackPublicId) {
        this(publicIDs, fallbackPublicId, null, false);
    }

    private HtmlVersion(String[] publicIDs, String fallbackPublicId, String defaultNamespace, boolean isXhtml) {
        this.publicIDs = publicIDs;
        this.defaultNamespace = defaultNamespace;
        this.isXhtml = isXhtml;
        this.fallbackPublicId = fallbackPublicId;
    }

    public Collection<String> getPublicIDs() {
        return Arrays.asList(this.publicIDs);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public boolean isXhtml() {
        return this.isXhtml;
    }

    public String getFallbackPublicId() {
        return this.fallbackPublicId;
    }
}

