/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.Utils;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.MainClassWarning;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class AppClientActionProvider
implements ActionProvider {
    private static final String COMMAND_COMPILE = "compile";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto", "compile", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "javadoc", "test", "test.single", "debug.test.single", "debug.fix", "debug.stepinto"};
    AppClientProject project;
    private final AntProjectHelper antProjectHelper;
    private final UpdateHelper updateHelper;
    Map<String, String[]> commands = new HashMap<String, String[]>();
    final Set<String> bkgScanSensitiveActions;
    private static final Pattern SRCDIRJAVA = Pattern.compile("\\.java$");
    private static final String SUBST = "Test.java";

    public AppClientActionProvider(AppClientProject appClientProject, AntProjectHelper antProjectHelper, UpdateHelper updateHelper) {
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("redeploy", new String[]{"run-deploy"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
        this.antProjectHelper = antProjectHelper;
        this.updateHelper = updateHelper;
        this.project = appClientProject;
    }

    private FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public void invokeAction(final String string, final Lookup lookup) throws IllegalArgumentException {
        if ("delete".equals(string)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(string)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(string)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(string)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Properties properties = new Properties();
                String[] stringArray = AppClientActionProvider.this.getTargetNames(string, lookup, properties);
                if (stringArray == null) {
                    return;
                }
                if (stringArray.length == 0) {
                    stringArray = null;
                }
                if (properties.keySet().size() == 0) {
                    properties = null;
                }
                try {
                    FileObject fileObject = AppClientActionProvider.this.findBuildXml();
                    if (fileObject == null || !fileObject.isValid()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    } else {
                        ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray, (Properties)properties);
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        };
        runnable.run();
    }

    String[] getTargetNames(String string, Lookup lookup, Properties properties) throws IllegalArgumentException {
        String[] stringArray;
        if (Arrays.asList(platformSensitiveActions).contains(string) && Utils.getActivePlatform((String)(stringArray = this.project.evaluator().getProperty("platform.active"))) == null) {
            this.showPlatformWarning();
            return null;
        }
        stringArray = new String[]{};
        if (string.equals("compile.single")) {
            boolean bl;
            FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
            FileObject[] fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray);
            boolean bl2 = bl = lookup.lookup(NonRecursiveFolder.class) == null;
            if (fileObjectArray2 != null) {
                properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray2, (FileObject)this.getRoot(fileObjectArray, fileObjectArray2[0]), (boolean)bl));
                stringArray = new String[]{"compile-single"};
            } else {
                FileObject[] fileObjectArray3 = this.project.getTestSourceRoots().getRoots();
                fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray3);
                properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray2, (FileObject)this.getRoot(fileObjectArray3, fileObjectArray2[0]), (boolean)bl));
                stringArray = new String[]{"compile-test-single"};
            }
        } else if (string.equals("test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            stringArray = this.setupTestSingle(properties, fileObjectArray);
        } else if (string.equals("debug.test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            stringArray = this.setupDebugTestSingle(properties, fileObjectArray);
        } else if (string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            String string2 = null;
            final String[] stringArray2 = new String[]{""};
            if (fileObjectArray != null) {
                string2 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), fileObjectArray[0]), (FileObject)fileObjectArray[0]);
                stringArray = new String[]{"debug-fix"};
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObjectArray[0]);
                if (javaSource != null) {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws Exception {
                                if (compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                                    ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                                    return;
                                }
                                List list = compilationController.getTopLevelElements();
                                if (list.size() > 0) {
                                    for (TypeElement typeElement : list) {
                                        if (stringArray2[0].length() > 0) {
                                            stringArray2[0] = stringArray2[0] + " ";
                                        }
                                        stringArray2[0] = stringArray2[0] + typeElement.getQualifiedName().toString().replace('.', '/') + "*.class";
                                    }
                                }
                            }
                        }, true);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else {
                fileObjectArray = this.findTestSources(lookup, false);
                string2 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getTestSourceRoots().getRoots(), fileObjectArray[0]), (FileObject)fileObjectArray[0]);
                stringArray = new String[]{"debug-fix-test"};
            }
            if (string2.endsWith(".java")) {
                string2 = string2.substring(0, string2.length() - 5);
            }
            properties.setProperty("fix.includes", string2);
            properties.setProperty("fix.classes", stringArray2[0]);
        } else if (string.equals("run") || string.equals("redeploy") || string.equals("debug")) {
            String string3;
            EditableProperties editableProperties = this.updateHelper.getProperties("nbproject/project.properties");
            if (!this.isSelectedServer()) {
                String string4 = NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_No_Server_Selected");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string4, 2));
                return null;
            }
            if (string.equals("debug")) {
                string3 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_Server_State_Question"), 3);
                string3.setOptionType(0);
                string3.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)string3) == NotifyDescriptor.YES_OPTION) {
                    string3 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_Server_State"), 1);
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)string3);
                    return null;
                }
            }
            string3 = editableProperties.get((Object)"main.class");
            MainClassStatus mainClassStatus = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string3);
            if (mainClassStatus != MainClassStatus.SET_AND_VALID) {
                do {
                    if (this.showMainClassWarning(string3, ProjectUtils.getInformation((Project)this.project).getDisplayName(), editableProperties, mainClassStatus)) {
                        return null;
                    }
                    string3 = editableProperties.get((Object)"main.class");
                } while ((mainClassStatus = this.isSetMainClass(this.project.getSourceRoots().getRoots(), string3)) != MainClassStatus.SET_AND_VALID);
                try {
                    if (!this.updateHelper.requestUpdate()) {
                        return null;
                    }
                    this.updateHelper.putProperties("nbproject/project.properties", editableProperties);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, "Error while saving project: " + iOException);
                }
            }
            if (string.equals("redeploy")) {
                properties.setProperty("forceRedeploy", "true");
            } else {
                properties.setProperty("forceRedeploy", "false");
            }
            stringArray = this.commands.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        } else if (string.equals("run.single")) {
            FileObject[] fileObjectArray = this.findTestSources(lookup, false);
            if (fileObjectArray != null) {
                stringArray = this.setupTestSingle(properties, fileObjectArray);
            } else {
                FileObject fileObject = this.findSources(lookup)[0];
                String string5 = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), fileObject), (FileObject)fileObject);
                properties.setProperty("javac.includes", string5);
                if (string5.endsWith(".java")) {
                    string5 = string5.substring(0, string5.length() - 5);
                }
                string5 = string5.replace('/', '.');
                if (!Utils.hasMainMethod(fileObject)) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"LBL_No_Main_Classs_Found", (Object)string5), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return null;
                }
                properties.setProperty("run.class", string5);
                stringArray = this.commands.get("run.single");
            }
        } else if (string.equals("debug.single")) {
            FileObject[] fileObjectArray = this.findTestSources(lookup, false);
            if (fileObjectArray != null) {
                stringArray = this.setupDebugTestSingle(properties, fileObjectArray);
            } else {
                Object object;
                FileObject fileObject;
                if (!this.isSelectedServer()) {
                    String string6 = NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_No_Server_Selected");
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string6, 2));
                    return null;
                }
                if (this.isDebugged()) {
                    fileObject = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_FinishSession"), 2);
                    object = DialogDisplayer.getDefault().notify((NotifyDescriptor)fileObject);
                    if (object.equals(NotifyDescriptor.OK_OPTION)) {
                        DebuggerManager.getDebuggerManager().getCurrentSession().kill();
                    } else {
                        return null;
                    }
                }
                fileObject = this.findSources(lookup)[0];
                object = FileUtil.getRelativePath((FileObject)this.getRoot(this.project.getSourceRoots().getRoots(), fileObject), (FileObject)fileObject);
                properties.setProperty("javac.includes", (String)object);
                if (((String)object).endsWith(".java")) {
                    object = ((String)object).substring(0, ((String)object).length() - 5);
                }
                object = ((String)object).replace('/', '.');
                if (!Utils.hasMainMethod(fileObject)) {
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"LBL_No_Main_Classs_Found", (Object)object), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    return null;
                }
                properties.setProperty("debug.class", (String)object);
                stringArray = this.commands.get("debug.single");
            }
        } else {
            stringArray = this.commands.get(string);
            if (stringArray == null) {
                throw new IllegalArgumentException(string);
            }
        }
        return stringArray;
    }

    private String[] setupTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        properties.setProperty("test.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        properties.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])fileObjectArray, (FileObject)fileObject));
        return new String[]{"test-single"};
    }

    private String[] setupDebugTestSingle(Properties properties, FileObject[] fileObjectArray) {
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray2, fileObjectArray[0]);
        String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObjectArray[0]);
        properties.setProperty("test.class", string.substring(0, string.length() - 5).replace('/', '.'));
        return new String[]{"debug-test"};
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        FileObject fileObject = this.findBuildXml();
        if (fileObject == null || !fileObject.isValid()) {
            return false;
        }
        if (string.equals(COMMAND_VERIFY)) {
            return this.project.getCarModule().hasVerifierSupport();
        }
        if (string.equals("run")) {
            return this.isSelectedServer() && !this.isTargetServerRemote();
        }
        if (string.equals("compile.single")) {
            return this.findSourcesAndPackages(lookup, this.project.getSourceRoots().getRoots()) != null || this.findSourcesAndPackages(lookup, this.project.getTestSourceRoots().getRoots()) != null;
        }
        if (string.equals("test.single")) {
            return this.findTestSourcesForSources(lookup) != null;
        }
        if (string.equals("debug.test.single")) {
            FileObject[] fileObjectArray = this.findTestSourcesForSources(lookup);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        if (string.equals("run.single") || string.equals("debug.single") || string.equals("debug.fix")) {
            FileObject[] fileObjectArray = this.findSources(lookup);
            if (fileObjectArray != null && fileObjectArray.length == 1) {
                return true;
            }
            fileObjectArray = this.findTestSources(lookup, false);
            return fileObjectArray != null && fileObjectArray.length == 1;
        }
        return true;
    }

    private FileObject[] findSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.project.getSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray[i], (String)".java", (boolean)true);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup lookup, FileObject fileObject) {
        if (fileObject != null) {
            FileObject[] fileObjectArray = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObject, null, (boolean)true);
            if (fileObjectArray != null) {
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (fileObjectArray[i].isFolder() || "java".equals(fileObjectArray[i].getExt())) continue;
                    return null;
                }
            }
            return fileObjectArray;
        }
        return null;
    }

    private FileObject[] findSourcesAndPackages(Lookup lookup, FileObject[] fileObjectArray) {
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject[] fileObjectArray2 = this.findSourcesAndPackages(lookup, fileObjectArray[i]);
            if (fileObjectArray2 == null) continue;
            return fileObjectArray2;
        }
        return null;
    }

    private FileObject[] findTestSources(Lookup lookup, boolean bl) {
        FileObject[] fileObjectArray;
        FileObject fileObject;
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        for (int i = 0; i < fileObjectArray2.length; ++i) {
            fileObject = ActionUtils.findSelectedFiles((Lookup)lookup, (FileObject)fileObjectArray2[i], (String)".java", (boolean)true);
            if (fileObject == null) continue;
            return fileObject;
        }
        if (bl && fileObjectArray2.length > 0 && (fileObjectArray = this.findSources(lookup)) != null) {
            fileObject = this.getRoot(this.project.getSourceRoots().getRoots(), fileObjectArray[0]);
            for (int i = 0; i < fileObjectArray2.length; ++i) {
                FileObject[] fileObjectArray3 = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)fileObjectArray2[i], (String)SUBST, (boolean)true);
                if (fileObjectArray3 == null) continue;
                return fileObjectArray3;
            }
        }
        return null;
    }

    private FileObject[] findTestSourcesForSources(Lookup lookup) {
        FileObject[] fileObjectArray = this.findSources(lookup);
        if (fileObjectArray == null) {
            return null;
        }
        FileObject[] fileObjectArray2 = this.project.getTestSourceRoots().getRoots();
        if (fileObjectArray2.length == 0) {
            return null;
        }
        FileObject[] fileObjectArray3 = this.project.getSourceRoots().getRoots();
        FileObject fileObject = this.getRoot(fileObjectArray3, fileObjectArray[0]);
        for (int i = 0; i < fileObjectArray2.length; ++i) {
            FileObject[] fileObjectArray4 = ActionUtils.regexpMapFiles((FileObject[])fileObjectArray, (FileObject)fileObject, (Pattern)SRCDIRJAVA, (FileObject)fileObjectArray2[i], (String)SUBST, (boolean)true);
            if (fileObjectArray4 == null) continue;
            return fileObjectArray4;
        }
        return null;
    }

    private FileObject getRoot(FileObject[] fileObjectArray, FileObject fileObject) {
        assert (fileObject != null) : "File can't be null";
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            assert (fileObjectArray[i] != null) : "Source Path Root can't be null";
            if (!FileUtil.isParentOf((FileObject)fileObjectArray[i], (FileObject)fileObject) && !fileObjectArray[i].equals(fileObject)) continue;
            fileObject2 = fileObjectArray[i];
            break;
        }
        return fileObject2;
    }

    private MainClassStatus isSetMainClass(FileObject[] fileObjectArray, String string) {
        ClassPath classPath;
        ClassPath classPath2;
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult != false ? MainClassStatus.SET_AND_VALID : MainClassStatus.SET_BUT_INVALID;
        }
        if (string == null || string.length() == 0) {
            return MainClassStatus.UNSET;
        }
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/boot");
        if (Utils.isMainClass(string, classPath3, classPath2 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/compile"), classPath = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/source"))) {
            return MainClassStatus.SET_AND_VALID;
        }
        return MainClassStatus.SET_BUT_INVALID;
    }

    public static boolean canBeRun(FileObject fileObject) {
        return !SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    private boolean showMainClassWarning(String string, String string2, EditableProperties editableProperties, MainClassStatus mainClassStatus) {
        boolean bl;
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassWarning.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (mainClassStatus) {
            case UNSET: {
                string3 = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassNotFound"), string2);
                break;
            }
            case SET_BUT_INVALID: {
                string3 = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWrong"), string, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning mainClassWarning = new MainClassWarning(string3, this.project.getSourceRoots().getRoots());
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        mainClassWarning.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    jButton.doClick();
                } else {
                    jButton.setEnabled(mainClassWarning.getSelectedMainClass() != null);
                }
            }
        });
        jButton.setEnabled(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassWarning, NbBundle.getMessage(MainClassWarning.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            string = mainClassWarning.getSelectedMainClass();
            bl = false;
            editableProperties.put("main.class", string == null ? "" : string);
        }
        dialog.dispose();
        return bl;
    }

    private void showPlatformWarning() {
        JButton jButton = new JButton(NbBundle.getMessage(AppClientActionProvider.class, (String)"CTL_BrokenPlatform_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AppClientActionProvider.class, (String)"AD_BrokenPlatform_Close"));
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        String string = projectInformation == null ? NbBundle.getMessage(AppClientActionProvider.class, (String)"TEXT_BrokenPlatform_UnknownProjectName") : projectInformation.getDisplayName();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)NbBundle.getMessage(AppClientActionProvider.class, (String)"TEXT_BrokenPlatform", (Object)string), NbBundle.getMessage(AppClientActionProvider.class, (String)"MSG_BrokenPlatform_Title"), true, new Object[]{jButton}, (Object)jButton, 0, null, null);
        dialogDescriptor.setMessageType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private boolean isSelectedServer() {
        String[] stringArray;
        String string;
        String string2 = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string2 != null && (string = Deployment.getDefault().getServerID(string2)) != null) {
            return true;
        }
        string = this.antProjectHelper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (string != null && (stringArray = Deployment.getDefault().getInstancesOfServer(string)).length > 0) {
            this.setServerInstance(stringArray[0]);
            return true;
        }
        return false;
    }

    private void setServerInstance(String string) {
        AppClientProjectProperties.setServerInstance(this.project, this.antProjectHelper, string);
    }

    private boolean isDebugged() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo serverDebugInfo = j2eeModuleProvider.getServerDebugInfo();
        if (serverDebugInfo == null) {
            return false;
        }
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            Object object;
            Session session = sessionArray[i];
            if (session == null || (object = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object;
            if (!(serverDebugInfo.getTransport().equals("dt_shmem") ? attachingDICookie.getSharedMemoryName().equalsIgnoreCase(serverDebugInfo.getShmemName()) : attachingDICookie.getHostName().equalsIgnoreCase(serverDebugInfo.getHost()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isTargetServerRemote() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
        String string = instanceProperties.getProperty("DOMAIN");
        String string2 = instanceProperties.getProperty("LOCATION");
        return "".equals(string) && "".equals(string2);
    }

    private static enum MainClassStatus {
        SET_AND_VALID,
        SET_BUT_INVALID,
        UNSET;

    }
}

