/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.plugin;

import java.util.Map;
import org.netbeans.modules.junit.JUnitPluginTrampoline;
import org.openide.filesystems.FileObject;

public abstract class JUnitPlugin {
    protected JUnitPlugin() {
    }

    protected abstract Location getTestLocation(Location var1);

    protected abstract Location getTestedLocation(Location var1);

    protected boolean canCreateTests(FileObject ... fileObjects) {
        return true;
    }

    protected abstract FileObject[] createTests(FileObject[] var1, FileObject var2, Map<CreateTestParam, Object> var3);

    protected boolean createTestActionCalled(FileObject[] selectedFiles) {
        return true;
    }

    static {
        JUnitPluginTrampoline.DEFAULT = new JUnitPluginTrampoline(){

            @Override
            public boolean createTestActionCalled(JUnitPlugin plugin, FileObject[] filesToTest) {
                return plugin.createTestActionCalled(filesToTest);
            }

            @Override
            public FileObject[] createTests(JUnitPlugin plugin, FileObject[] filesToTest, FileObject targetRoot, Map<CreateTestParam, Object> params) {
                return plugin.createTests(filesToTest, targetRoot, params);
            }

            @Override
            public Location getTestLocation(JUnitPlugin plugin, Location sourceLocation) {
                return plugin.getTestLocation(sourceLocation);
            }

            @Override
            public Location getTestedLocation(JUnitPlugin plugin, Location testLocation) {
                return plugin.getTestedLocation(testLocation);
            }

            @Override
            public boolean canCreateTests(JUnitPlugin plugin, FileObject ... fileObjects) {
                return plugin.canCreateTests(fileObjects);
            }
        };
    }

    public static final class Location {
        private final FileObject fileObject;

        public Location(FileObject fileObject) {
            if (fileObject == null) {
                throw new IllegalArgumentException("fileObject is null");
            }
            this.fileObject = fileObject;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }
    }

    public static enum CreateTestParam {
        CLASS_NAME(99310),
        INC_PUBLIC(99311),
        INC_PROTECTED(99312),
        INC_PKG_PRIVATE(99313),
        INC_SETUP(99314),
        INC_TEAR_DOWN(99315),
        INC_CLASS_SETUP(99323),
        INC_CLASS_TEAR_DOWN(99324),
        INC_METHOD_BODIES(99316),
        INC_JAVADOC(99317),
        INC_CODE_HINT(99318),
        INC_PKG_PRIVATE_CLASS(99319),
        INC_ABSTRACT_CLASS(99320),
        INC_EXCEPTION_CLASS(99321),
        INC_GENERATE_SUITE(99322);

        private final int idNumber;

        private CreateTestParam(int idNumber) {
            this.idNumber = idNumber;
        }

        public int getIdNumber() {
            return this.idNumber;
        }
    }
}

