/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilers.CCCCompiler;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

abstract class SunCCCCompiler
extends CCCCompiler {
    protected SunCCCCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
    }

    protected String getCompilerStderrCommand() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getIncludeFlags();
        }
        return null;
    }

    protected String getCompilerStderrCommand2() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null) {
            return " " + compiler.getMacroFlags();
        }
        return null;
    }

    @Override
    protected CCCCompiler.Pair getFreshSystemIncludesAndDefines() {
        CCCCompiler.Pair res = new CCCCompiler.Pair();
        try {
            this.getSystemIncludesAndDefines(this.getCompilerStderrCommand(), false, res);
            if (this.getCompilerStderrCommand2() != null) {
                this.getSystemIncludesAndDefines(this.getCompilerStderrCommand2(), false, res);
            }
            SunCCCCompiler.addUnique(res.systemIncludeDirectoriesList, this.applyPathPrefix("/usr/include"));
        }
        catch (IOException ioe) {
            System.err.println("IOException " + ioe);
            String errormsg = this.getExecutionEnvironment().isLocal() ? NbBundle.getMessage(this.getClass(), (String)"CANTFINDCOMPILER", (Object)this.getPath()) : NbBundle.getMessage(this.getClass(), (String)"CANT_FIND_REMOTE_COMPILER", (Object)this.getPath(), (Object)this.getExecutionEnvironment().getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
        }
        return res;
    }

    protected Collection<String> getSystemPaths(String line) {
        List<String> res = this.getIncludePaths(line, "-include");
        res.addAll(this.getIncludePaths(line, "-I"));
        return res;
    }

    private List<String> getIncludePaths(String line, String prefix) {
        ArrayList<String> res = new ArrayList<String>();
        int includeIndex = line.indexOf(prefix);
        while (includeIndex > 0) {
            int spaceIndex;
            String token;
            int rest = includeIndex + prefix.length();
            if (line.charAt(includeIndex + prefix.length()) == ' ') {
                ++rest;
            }
            if (!(token = (spaceIndex = line.indexOf(32, rest)) > 0 ? line.substring(rest, spaceIndex) : line.substring(rest)).equals("-xbuiltin")) {
                res.add(token);
            }
            if (spaceIndex < 0) break;
            includeIndex = line.indexOf(prefix, spaceIndex);
        }
        return res;
    }
}

