/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Previewable;

public class ImagePreviewComponent
extends JComponent {
    public static final boolean DEBUG = false;
    private boolean centeredH = true;
    private boolean centeredV = true;
    private Previewable previewable;

    public ImagePreviewComponent(boolean bl, boolean bl2, boolean bl3) {
        this(bl);
        this.centeredH = bl2;
        this.centeredV = bl3;
    }

    public ImagePreviewComponent(boolean bl) {
        this.setDoubleBuffered(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ImagePreviewComponent.this.repaint();
            }
        });
    }

    public void setPreviewable(Previewable previewable) {
        this.previewable = previewable;
        Dimension dimension = new Dimension(previewable.getWidth(), previewable.getHeight());
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        int n = 0;
        int n2 = 0;
        if (this.previewable != null) {
            if (this.centeredH) {
                n = (this.getWidth() - this.previewable.getWidth()) / 2;
            }
            if (this.centeredV) {
                n2 = (this.getHeight() - this.previewable.getHeight()) / 2;
            }
            this.previewable.paint((Graphics2D)graphics, n, n2);
        }
    }
}

