/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.tools.impl;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.tools.impl.DataRowConsumer;
import org.netbeans.modules.dlight.tools.impl.ProcDataProvider;
import org.netbeans.modules.dlight.tools.impl.SolarisProcfsSupport;
import org.netbeans.modules.dlight.util.DLightMath;

public class ProcDataProviderSolaris
implements ProcDataProvider.Engine {
    private static final List<String> COLNAMES = Collections.unmodifiableList(Arrays.asList(ProcDataProviderConfiguration.USR_TIME.getColumnName(), ProcDataProviderConfiguration.SYS_TIME.getColumnName(), ProcDataProviderConfiguration.THREADS.getColumnName()));
    private static final BigDecimal PERCENT = BigDecimal.valueOf(100L);
    private final DataRowConsumer consumer;
    private final int cpuCount;
    private SolarisProcfsSupport.Prusage prevPrusage;
    private SolarisProcfsSupport.Prusage currPrusage;

    public ProcDataProviderSolaris(DataRowConsumer consumer, ServiceInfoDataStorage serviceInfoStorage, int cpuCount) {
        this.consumer = consumer;
        this.cpuCount = cpuCount;
    }

    @Override
    public String getCommand(int pid) {
        return "while od -v -t x4 -N 64 /proc/" + pid + "/usage && ls /proc/" + pid + "/lwp | wc -l; do sleep 1; done";
    }

    public void processLine(String line) {
        block6: {
            try {
                String firstToken = ProcDataProviderSolaris.getFirstToken(line);
                if (firstToken.length() == 7) {
                    this.currPrusage = SolarisProcfsSupport.parsePrusage(line, this.currPrusage);
                    break block6;
                }
                if (this.prevPrusage != null) {
                    try {
                        int threads = Integer.parseInt(firstToken);
                        BigDecimal cpuTime = this.currPrusage.tstamp().toBigDecimal().subtract(this.prevPrusage.tstamp().toBigDecimal()).multiply(BigDecimal.valueOf(this.cpuCount));
                        BigDecimal usrTime = this.currPrusage.utime().toBigDecimal().subtract(this.prevPrusage.utime().toBigDecimal());
                        BigDecimal sysTime = this.currPrusage.stime().toBigDecimal().subtract(this.prevPrusage.stime().toBigDecimal());
                        float[] times = DLightMath.ensureSumLessOrEqual((float)100.0f, (float[])new float[]{ProcDataProviderSolaris.percent(usrTime, cpuTime), ProcDataProviderSolaris.percent(sysTime, cpuTime)});
                        DataRow row = new DataRow(COLNAMES, Arrays.asList(Float.valueOf(times[0]), Float.valueOf(times[1]), threads));
                        this.consumer.consume(row);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.prevPrusage = this.currPrusage;
                this.currPrusage = null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void reset() {
        this.currPrusage = null;
        this.prevPrusage = null;
    }

    public void close() {
    }

    private static String getFirstToken(String line) {
        int endIdx = (line = line.trim()).indexOf(32);
        if (endIdx < 0) {
            endIdx = line.length();
        }
        return line.substring(0, endIdx);
    }

    private static float percent(BigDecimal value, BigDecimal total) {
        if (BigDecimal.ZERO.compareTo(total) < 0) {
            if (value.compareTo(BigDecimal.ZERO) <= 0) {
                return 0.0f;
            }
            return value.multiply(PERCENT).divideToIntegralValue(total).floatValue();
        }
        return 0.0f;
    }
}

