/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import javax.xml.namespace.QName;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.rm.AtLeastOnce;
import org.netbeans.modules.websvc.wsitmodelext.rm.ExactlyOnce;
import org.netbeans.modules.websvc.wsitmodelext.rm.RMQName;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.util.NbBundle;

public enum RMDeliveryAssurance {
    AT_LEAST_ONCE{

        @Override
        public boolean isSet(ConfigVersion cfgVersion, Binding binding) {
            return RMModelHelper.getInstance(cfgVersion).isDeliveryAssurance(binding, this);
        }

        @Override
        public void set(ConfigVersion cfgVersion, Binding binding) {
            if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
                RMModelHelper.getInstance(cfgVersion).enableAllowDuplicates(binding, true);
            } else {
                RMModelHelper.getInstance(cfgVersion).setDeliveryAssurance(binding, this);
            }
        }

        @Override
        public QName getQName() {
            return RMQName.ATLEASTONCE.getQName(ConfigVersion.CONFIG_1_3);
        }

        @Override
        public Class getAssertionClass() {
            return AtLeastOnce.class;
        }
    }
    ,
    EXACTLY_ONCE{

        @Override
        public boolean isSet(ConfigVersion cfgVersion, Binding binding) {
            return RMModelHelper.getInstance(cfgVersion).isDeliveryAssurance(binding, this);
        }

        @Override
        public void set(ConfigVersion cfgVersion, Binding binding) {
            if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
                RMModelHelper.getInstance(cfgVersion).enableAllowDuplicates(binding, false);
            } else {
                RMModelHelper.getInstance(cfgVersion).setDeliveryAssurance(binding, this);
            }
        }

        @Override
        public QName getQName() {
            return RMQName.EXACTLYONCE.getQName(ConfigVersion.CONFIG_1_3);
        }

        @Override
        public Class getAssertionClass() {
            return ExactlyOnce.class;
        }
    };


    public static final RMDeliveryAssurance getDefault() {
        return EXACTLY_ONCE;
    }

    public static final RMDeliveryAssurance getValue(ConfigVersion cfgVersion, Binding b) {
        if (ConfigVersion.CONFIG_1_0.equals((Object)cfgVersion)) {
            if (RMModelHelper.isAllowDuplicates(b)) {
                return AT_LEAST_ONCE;
            }
            return EXACTLY_ONCE;
        }
        for (RMDeliveryAssurance delivery : RMDeliveryAssurance.values()) {
            if (!delivery.isSet(cfgVersion, b)) continue;
            return delivery;
        }
        return null;
    }

    public String toString() {
        return NbBundle.getMessage(RMDeliveryAssurance.class, (String)this.name());
    }

    public abstract boolean isSet(ConfigVersion var1, Binding var2);

    public abstract void set(ConfigVersion var1, Binding var2);

    public abstract QName getQName();

    public abstract Class getAssertionClass();
}

