/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct.nodes;

import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitor;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitorAdaptor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;

public class ServletRequestCPUCCTNode
extends TimedCPUCCTNode {
    int hashCode = 0;
    private final String servletPath;
    private final int requestType;

    public ServletRequestCPUCCTNode(CPUCCTNodeFactory factory, int requestType, String path, boolean collectingTwoTimestamps) {
        super(factory, collectingTwoTimestamps);
        this.servletPath = path;
        this.requestType = requestType;
        this.setFilteredStatus(2);
        this.setNCalls(0);
    }

    public int getRequestType() {
        return this.requestType;
    }

    @Override
    public boolean isRoot() {
        return false;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    @Override
    public void accept(RuntimeCPUCCTNodeVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object otherNode) {
        if (otherNode == null) {
            return false;
        }
        if (!(otherNode instanceof ServletRequestCPUCCTNode)) {
            return false;
        }
        return this.servletPath.equals(((ServletRequestCPUCCTNode)otherNode).servletPath) && this.requestType == ((ServletRequestCPUCCTNode)otherNode).requestType;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.servletPath.hashCode() + this.requestType * 18321;
        }
        return this.hashCode;
    }

    @Override
    protected TimedCPUCCTNode createSelfInstance() {
        CPUCCTNodeFactory factory = this.getFactory();
        return factory != null ? factory.createServletRequestNode(this.requestType, this.servletPath) : null;
    }

    public static class Locator
    extends RuntimeCPUCCTNodeVisitorAdaptor {
        private ServletRequestCPUCCTNode cctNodeCandidate = null;
        private String servletPath;
        private int requestType;

        private Locator() {
        }

        public static ServletRequestCPUCCTNode locate(int requestType, String servletPath, RuntimeCPUCCTNode.Children nodes) {
            Locator instance = new Locator();
            return instance.doLocate(requestType, servletPath, nodes);
        }

        @Override
        public void visit(ServletRequestCPUCCTNode node) {
            if (node.getServletPath().equals(this.servletPath) && node.getRequestType() == this.requestType) {
                this.cctNodeCandidate = node;
            }
        }

        private ServletRequestCPUCCTNode doLocate(int requestType, String servletPath, RuntimeCPUCCTNode.Children nodes) {
            this.cctNodeCandidate = null;
            this.requestType = requestType;
            this.servletPath = servletPath;
            nodes.accept(this);
            return this.cctNodeCandidate;
        }
    }
}

