/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Frame;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.GrabTableHelper;
import org.netbeans.modules.db.explorer.action.RecreateTableAction;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class GrabTableAction
extends BaseAction {
    public String getName() {
        return NbBundle.getMessage(GrabTableAction.class, (String)"GrabStructure");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(GrabTableAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        if (activatedNodes.length == 1) {
            enabled = activatedNodes[0].getLookup().lookup(TableNode.class) != null;
        }
        return enabled;
    }

    public void performAction(Node[] activatedNodes) {
        final TableNode node = (TableNode)activatedNodes[0].getLookup().lookup(TableNode.class);
        try {
            final Specification spec = ((DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class)).getConnector().getDatabaseSpecification();
            String tablename = node.getName();
            FileChooserBuilder chooserBuilder = new FileChooserBuilder(RecreateTableAction.class);
            chooserBuilder.setTitle(NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileSaveDialogTitle"));
            chooserBuilder.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".grab");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileTypeDescription");
                }
            });
            JFileChooser chooser = chooserBuilder.createFileChooser();
            chooser.setSelectedFile(new File(tablename + ".grab"));
            Frame par = WindowManager.getDefault().getMainWindow();
            boolean noResult = true;
            File file = null;
            while (noResult) {
                if (chooser.showSaveDialog(par) == 0) {
                    file = chooser.getSelectedFile();
                    if (file == null) continue;
                    if (file.exists()) {
                        JButton yesOption = new JButton(NbBundle.getMessage(GrabTableAction.class, (String)"Yes"));
                        JButton noOption = new JButton(NbBundle.getMessage(GrabTableAction.class, (String)"No"));
                        Object result = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(GrabTableAction.class, (String)"MSG_ReplaceFileOrNot", (Object)file.getName()), NbBundle.getMessage(GrabTableAction.class, (String)"GrabTableFileSaveDialogTitle"), 0, 3, new Object[]{yesOption, noOption}, (Object)yesOption));
                        if (!result.equals(yesOption)) continue;
                        noResult = false;
                        continue;
                    }
                    noResult = false;
                    continue;
                }
                return;
            }
            final File theFile = file;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        new GrabTableHelper().execute(((DatabaseConnection)node.getLookup().lookup(DatabaseConnection.class)).getConnector(), spec, node.getTableHandle(), theFile);
                    }
                    catch (Exception exc) {
                        Logger.getLogger(GrabTableAction.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
                        DbUtilities.reportError(NbBundle.getMessage(GrabTableAction.class, (String)"ERR_UnableToGrabTable"), exc.getMessage());
                    }
                }
            });
        }
        catch (Exception exc) {
            Logger.getLogger(GrabTableAction.class.getName()).log(Level.INFO, exc.getLocalizedMessage(), exc);
            DbUtilities.reportError(NbBundle.getMessage(GrabTableAction.class, (String)"ERR_UnableToGrabTable"), exc.getMessage());
        }
    }
}

