/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallDescriptor;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class CallNode
extends AbstractNode {
    private CallNode() {
        super(Children.LEAF);
    }

    private CallNode(Children children, CallDescriptor callDescriptor) {
        super(children, Lookups.singleton((Object)callDescriptor));
        this.setDisplayName(callDescriptor.getDisplayName());
    }

    public static CallNode createDefault() {
        CallNode callNode = new CallNode();
        callNode.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Default.displayName"));
        return callNode;
    }

    public static CallNode createPleaseWait() {
        CallNode callNode = new CallNode();
        callNode.setIconBaseWithExtension("org/netbeans/modules/java/navigation/resources/wait.gif");
        callNode.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.PleaseWait.displayName"));
        return callNode;
    }

    private static CallNode createCanceled() {
        CallNode callNode = new CallNode();
        callNode.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Canceled.displayName"));
        return callNode;
    }

    private static CallNode createBroken() {
        CallNode callNode = new CallNode();
        callNode.setDisplayName(NbBundle.getMessage(CallNode.class, (String)"CallNode.Broken.displayName"));
        return callNode;
    }

    public static CallNode createCall(CallDescriptor callDescriptor) {
        CallNode callNode = new CallNode((Children)(callDescriptor.isLeaf() ? Children.LEAF : new CallChildren()), callDescriptor);
        return callNode;
    }

    public static Node createRoot(CallHierarchyModel callHierarchyModel) {
        Call call = null;
        if (callHierarchyModel != null) {
            call = callHierarchyModel.getRoot();
        }
        return call != null ? CallNode.createCall(call) : CallNode.createDefault();
    }

    public Image getIcon(int n) {
        CallDescriptor callDescriptor = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        Icon icon = callDescriptor != null ? callDescriptor.getIcon() : null;
        return icon != null ? ImageUtilities.icon2Image((Icon)icon) : super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getHtmlDisplayName() {
        CallDescriptor callDescriptor = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        String string = callDescriptor != null ? callDescriptor.getHtmlDisplayName() : null;
        return string != null ? string : super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean bl) {
        CallDescriptor callDescriptor = (CallDescriptor)this.getLookup().lookup(CallDescriptor.class);
        if (!(callDescriptor == null || callDescriptor instanceof Call && ((Call)callDescriptor).getOccurrences().isEmpty())) {
            return new Action[]{new GoToSourceAction(callDescriptor)};
        }
        return new Action[0];
    }

    public Action getPreferredAction() {
        Action[] actionArray;
        for (Action action : actionArray = this.getActions(true)) {
            if (!(action instanceof GoToSourceAction)) continue;
            return action;
        }
        return null;
    }

    private static final class GoToSourceAction
    extends AbstractAction {
        private CallDescriptor desc;

        public GoToSourceAction(CallDescriptor callDescriptor) {
            super(NbBundle.getMessage(GoToSourceAction.class, (String)"GoToSourceAction.displayName"));
            this.desc = callDescriptor;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.desc.open();
        }
    }

    static final class CallChildren
    extends Children.Keys<Object>
    implements Runnable {
        private final boolean isOccurrenceView;
        private final AtomicInteger state = new AtomicInteger(0);

        public CallChildren() {
            this(false);
        }

        public CallChildren(boolean bl) {
            this.isOccurrenceView = bl;
        }

        protected void addNotify() {
            Call call;
            super.addNotify();
            Node node = this.getNode();
            Call call2 = call = node != null ? (Call)node.getLookup().lookup(Call.class) : null;
            if (call == null) {
                return;
            }
            if (this.isOccurrenceView) {
                this.setKeys(call.getOccurrences());
            } else {
                this.setKeys(new Node[]{CallNode.createPleaseWait()});
                this.state.set(0);
                call.getModel().computeCalls(call, this);
            }
        }

        protected Node[] createNodes(Object object) {
            Object object2 = null;
            if (object instanceof Node) {
                object2 = (Node)object;
            } else if (object instanceof CallDescriptor) {
                object2 = CallNode.createCall((CallDescriptor)object);
            } else {
                return null;
            }
            return new Node[]{object2};
        }

        @Override
        public void run() {
            List<Object> list;
            if (this.state.incrementAndGet() == 1) {
                Children.MUTEX.writeAccess((Runnable)this);
                return;
            }
            Node node = this.getNode();
            Call call = (Call)node.getLookup().lookup(Call.class);
            if (call == null) {
                list = Collections.emptyList();
            } else {
                list = call.getReferences();
                if (!this.isOccurrenceView && (call.isCanceled() || call.isBroken())) {
                    ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + 1);
                    arrayList.addAll(list);
                    arrayList.add((Object)(call.isBroken() ? CallNode.createBroken() : CallNode.createCanceled()));
                    list = arrayList;
                }
            }
            this.setKeys(list);
        }
    }
}

