/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.java.source.JavaSource;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class HintAction
extends TextAction
implements PropertyChangeListener {
    protected HintAction() {
        super(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        if (!SwingUtilities.isEventDispatchThread()) {
            this.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintAction.this.updateEnabled();
                }
            });
        } else {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        this.setEnabled(this.getCurrentFile(null) != null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.doPerform();
        if (string != null) {
            String string2 = NbBundle.getMessage(HintAction.class, (String)string);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
        }
    }

    private String doPerform() {
        int[] nArray = new int[2];
        FileObject fileObject = this.getCurrentFile(nArray);
        if (fileObject == null) {
            if (nArray[0] != nArray[1]) {
                return "ERR_Not_Selected";
            }
            return "ERR_No_Selection";
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return "ERR_Not_Supported";
        }
        this.perform(javaSource, nArray);
        return null;
    }

    protected abstract void perform(JavaSource var1, int[] var2);

    private FileObject getCurrentFile(int[] nArray) {
        Document document;
        Object object;
        JEditorPane jEditorPane;
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        Lookup lookup = topComponent != null ? topComponent.getLookup() : null;
        EditorCookie editorCookie = lookup != null ? (EditorCookie)lookup.lookup(EditorCookie.class) : null;
        JEditorPane jEditorPane2 = jEditorPane = editorCookie != null ? NbDocument.findRecentEditorPane((EditorCookie)editorCookie) : null;
        if (jEditorPane == null) {
            return null;
        }
        if (nArray != null) {
            nArray[0] = jEditorPane.getSelectionStart();
            nArray[1] = jEditorPane.getSelectionEnd();
            if (nArray[0] == nArray[1] && this.requiresSelection()) {
                return null;
            }
        }
        Object object2 = object = (document = jEditorPane.getDocument()) != null ? document.getProperty("stream") : null;
        if (!(object instanceof DataObject)) {
            return null;
        }
        DataObject dataObject = (DataObject)object;
        FileObject fileObject = dataObject.getPrimaryFile();
        if ("text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return fileObject;
        }
        return null;
    }

    protected boolean requiresSelection() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateEnabled();
    }
}

