/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.Braces;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class EmptyStatements
extends AbstractHint {
    private static final String SUPPRESS_WARNINGS_KEY = "empty-statement";
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);
    private String EMPTY_STATEMENTS_ID = "EmptyStatements_";
    private Tree.Kind treeKind;
    private Set<Tree.Kind> treeKinds = EnumSet.of(Tree.Kind.EMPTY_STATEMENT);
    private Set<Tree.Kind> NO_KINDS = EnumSet.noneOf(Tree.Kind.class);
    private static EmptyStatements delegate;
    private static EmptyStatements esFor;
    private static EmptyStatements esWhile;
    private static EmptyStatements esDoWhile;
    private static EmptyStatements esIf;
    private static EmptyStatements esBlock;

    private EmptyStatements(Tree.Kind kind) {
        super(kind != Tree.Kind.IF, true, AbstractHint.HintSeverity.WARNING, SUPPRESS_WARNINGS_KEY);
        this.treeKind = kind;
    }

    public static EmptyStatements createDelegate() {
        return EmptyStatements.getDelegate();
    }

    public static EmptyStatements createFor() {
        EmptyStatements emptyStatements = EmptyStatements.getDelegate();
        esFor = new EmptyStatements(Tree.Kind.FOR_LOOP);
        return esFor;
    }

    public static EmptyStatements createWhile() {
        EmptyStatements emptyStatements = EmptyStatements.getDelegate();
        esWhile = new EmptyStatements(Tree.Kind.WHILE_LOOP);
        return esWhile;
    }

    public static EmptyStatements createDoWhile() {
        EmptyStatements emptyStatements = EmptyStatements.getDelegate();
        esDoWhile = new EmptyStatements(Tree.Kind.DO_WHILE_LOOP);
        return esDoWhile;
    }

    public static EmptyStatements createIf() {
        EmptyStatements emptyStatements = EmptyStatements.getDelegate();
        esIf = new EmptyStatements(Tree.Kind.IF);
        return esIf;
    }

    public static EmptyStatements createBlock() {
        EmptyStatements emptyStatements = EmptyStatements.getDelegate();
        esBlock = new EmptyStatements(Tree.Kind.BLOCK);
        return esBlock;
    }

    public static synchronized EmptyStatements getDelegate() {
        if (delegate == null) {
            delegate = new EmptyStatements(null);
        }
        return delegate;
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKind == null ? this.treeKinds : this.NO_KINDS;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        if (tree.getKind() != Tree.Kind.EMPTY_STATEMENT) {
            return null;
        }
        Tree tree2 = treePath.getParentPath().getLeaf();
        if (!this.isEnabled(tree2.getKind())) {
            return null;
        }
        ErrorDescription errorDescription = null;
        switch (tree2.getKind()) {
            case FOR_LOOP: 
            case ENHANCED_FOR_LOOP: 
            case WHILE_LOOP: 
            case DO_WHILE_LOOP: {
                errorDescription = this.createErrorDescription(treePath.getParentPath(), tree2.getKind(), compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case BLOCK: {
                errorDescription = this.createErrorDescription(treePath, tree2.getKind(), compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case IF: {
                ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>(2);
                IfTree ifTree = (IfTree)tree2;
                if (ifTree.getThenStatement() != null && ifTree.getThenStatement().getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    arrayList.add(this.createErrorDescription(treePath.getParentPath(), tree2.getKind(), compilationInfo));
                }
                if (ifTree.getElseStatement() != null && ifTree.getElseStatement().getKind() == Tree.Kind.EMPTY_STATEMENT) {
                    arrayList.add(this.createErrorDescription(treePath, tree2.getKind(), compilationInfo));
                }
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.EMPTY_STATEMENTS_ID + (Object)((Object)this.treeKind);
    }

    @Override
    public String getDisplayName() {
        if (this.treeKind == null) {
            return "Empty Statements Delegate";
        }
        return NbBundle.getMessage(EmptyStatements.class, (String)("LBL_Empty_" + this.treeKind.toString()));
    }

    @Override
    public String getDescription() {
        if (this.treeKind == null) {
            return "Empty Statements Delegate";
        }
        return NbBundle.getMessage(EmptyStatements.class, (String)("DSC_Empty_" + this.treeKind.toString()));
    }

    private ErrorDescription createErrorDescription(TreePath treePath, Tree.Kind kind, CompilationInfo compilationInfo) {
        return ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(EmptyStatements.class, (String)("LBL_Empty_" + kind.toString())), FixFactory.createSuppressWarnings(compilationInfo, treePath, SUPPRESS_WARNINGS_KEY), (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf())), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), treePath.getLeaf())));
    }

    private boolean isEnabled(Tree.Kind kind) {
        switch (kind) {
            case FOR_LOOP: 
            case ENHANCED_FOR_LOOP: {
                return esFor.isEnabled();
            }
            case WHILE_LOOP: {
                return esWhile.isEnabled();
            }
            case DO_WHILE_LOOP: {
                return esDoWhile.isEnabled();
            }
            case BLOCK: {
                return esBlock.isEnabled();
            }
            case IF: {
                return esIf.isEnabled();
            }
        }
        return false;
    }

    private static class EmptyStatementFix
    implements Fix,
    Task<WorkingCopy> {
        FileObject file;
        TreePathHandle tph;
        Tree.Kind kind;
        boolean fixThen;
        boolean fixElse;

        public EmptyStatementFix(FileObject fileObject, TreePathHandle treePathHandle, Tree.Kind kind) {
            this.file = fileObject;
            this.tph = treePathHandle;
            this.kind = kind;
        }

        public String getText() {
            return NbBundle.getMessage(Braces.class, (String)("LBL_Empty_Fix" + this.kind.toString()));
        }

        public ChangeInfo implement() {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            try {
                javaSource.runModificationTask((Task)this).commit();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
        }
    }
}

