/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Braces
extends AbstractHint {
    static final EnumSet<JavaTokenId> nonRelevant = EnumSet.of(JavaTokenId.LINE_COMMENT, JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.WHITESPACE);
    private static final List<Fix> NO_FIXES = Collections.emptyList();
    private String BRACES_ID = "Braces_";
    private Tree.Kind treeKind;
    private Set<Tree.Kind> treeKinds;

    private Braces(Tree.Kind kind) {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
        this.treeKind = kind;
        this.treeKinds = kind == Tree.Kind.FOR_LOOP ? EnumSet.of(kind, Tree.Kind.ENHANCED_FOR_LOOP) : Collections.singleton(kind);
    }

    public static Braces createFor() {
        return new Braces(Tree.Kind.FOR_LOOP);
    }

    public static Braces createWhile() {
        return new Braces(Tree.Kind.WHILE_LOOP);
    }

    public static Braces createDoWhile() {
        return new Braces(Tree.Kind.DO_WHILE_LOOP);
    }

    public static Braces createIf() {
        return new Braces(Tree.Kind.IF);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return this.treeKinds;
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        Tree tree = treePath.getLeaf();
        ErrorDescription errorDescription = null;
        switch (tree.getKind()) {
            case FOR_LOOP: {
                ForLoopTree forLoopTree = (ForLoopTree)tree;
                errorDescription = this.checkStatement(forLoopTree.getStatement(), treePath, compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case ENHANCED_FOR_LOOP: {
                EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                errorDescription = this.checkStatement(enhancedForLoopTree.getStatement(), treePath, compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case WHILE_LOOP: {
                WhileLoopTree whileLoopTree = (WhileLoopTree)tree;
                errorDescription = this.checkStatement(whileLoopTree.getStatement(), treePath, compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case DO_WHILE_LOOP: {
                DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)tree;
                errorDescription = this.checkStatement(doWhileLoopTree.getStatement(), treePath, compilationInfo);
                if (errorDescription == null) break;
                return Collections.singletonList(errorDescription);
            }
            case IF: {
                IfTree ifTree = (IfTree)tree;
                List<ErrorDescription> list = this.checkifStatements(ifTree.getThenStatement(), ifTree.getElseStatement(), treePath, compilationInfo);
                return list;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getId() {
        return this.BRACES_ID + (Object)((Object)this.treeKind);
    }

    @Override
    public String getDisplayName() {
        switch (this.treeKind) {
            case FOR_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_For");
            }
            case WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_While");
            }
            case DO_WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_DoWhile");
            }
            case IF: {
                return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_If");
            }
        }
        return "No Name";
    }

    @Override
    public String getDescription() {
        switch (this.treeKind) {
            case FOR_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_For");
            }
            case WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_While");
            }
            case DO_WHILE_LOOP: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_DoWhile");
            }
            case IF: {
                return NbBundle.getMessage(Braces.class, (String)"DSC_Braces_If");
            }
        }
        return "No Description";
    }

    private ErrorDescription checkStatement(StatementTree statementTree, TreePath treePath, CompilationInfo compilationInfo) {
        if (statementTree != null && statementTree.getKind() != Tree.Kind.EMPTY_STATEMENT && statementTree.getKind() != Tree.Kind.BLOCK && statementTree.getKind() != Tree.Kind.ERRONEOUS && !this.isErroneousExpression(statementTree)) {
            return ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(new BracesFix(compilationInfo.getFileObject(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo))), (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), statementTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), statementTree)));
        }
        return null;
    }

    private List<ErrorDescription> checkifStatements(StatementTree statementTree, StatementTree statementTree2, TreePath treePath, CompilationInfo compilationInfo) {
        BracesFix bracesFix;
        boolean bl = false;
        boolean bl2 = false;
        if (statementTree != null && statementTree.getKind() != Tree.Kind.EMPTY_STATEMENT && statementTree.getKind() != Tree.Kind.BLOCK && statementTree.getKind() != Tree.Kind.ERRONEOUS && !this.isErroneousExpression(statementTree)) {
            bl = true;
        }
        if (statementTree2 != null && statementTree2.getKind() != Tree.Kind.EMPTY_STATEMENT && statementTree2.getKind() != Tree.Kind.BLOCK && statementTree2.getKind() != Tree.Kind.ERRONEOUS && statementTree2.getKind() != Tree.Kind.IF && !this.isErroneousExpression(statementTree2)) {
            bl2 = true;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (bl) {
            bracesFix = new BracesFix(compilationInfo.getFileObject(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo));
            bracesFix.fixThen = bl;
            bracesFix.fixElse = bl2;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(bracesFix), (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), statementTree)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), statementTree))));
        }
        if (bl2) {
            bracesFix = new BracesFix(compilationInfo.getFileObject(), TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo));
            bracesFix.fixThen = bl;
            bracesFix.fixElse = bl2;
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)this.getDisplayName(), Collections.singletonList(bracesFix), (FileObject)compilationInfo.getFileObject(), (int)((int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), statementTree2)), (int)((int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), statementTree2))));
        }
        return arrayList;
    }

    private boolean isErroneousExpression(StatementTree statementTree) {
        return statementTree instanceof ExpressionStatementTree && ((ExpressionStatementTree)statementTree).getExpression().getKind() == Tree.Kind.ERRONEOUS;
    }

    private static class BracesFix
    implements Fix,
    Task<WorkingCopy> {
        FileObject file;
        TreePathHandle tph;
        int kind;
        boolean fixThen;
        boolean fixElse;

        public BracesFix(FileObject fileObject, TreePathHandle treePathHandle) {
            this.file = fileObject;
            this.tph = treePathHandle;
        }

        public String getText() {
            return NbBundle.getMessage(Braces.class, (String)"LBL_Braces_Fix");
        }

        public ChangeInfo implement() throws IOException {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
            javaSource.runModificationTask((Task)this).commit();
            return null;
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.PARSED);
            TreePath treePath = this.tph.resolve((CompilationInfo)workingCopy);
            if (treePath != null) {
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                Tree tree = treePath.getLeaf();
                switch (tree.getKind()) {
                    case FOR_LOOP: {
                        ForLoopTree forLoopTree = (ForLoopTree)tree;
                        StatementTree statementTree = forLoopTree.getStatement();
                        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                        workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                        break;
                    }
                    case ENHANCED_FOR_LOOP: {
                        EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                        StatementTree statementTree = enhancedForLoopTree.getStatement();
                        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                        workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                        break;
                    }
                    case WHILE_LOOP: {
                        WhileLoopTree whileLoopTree = (WhileLoopTree)tree;
                        StatementTree statementTree = whileLoopTree.getStatement();
                        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                        workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                        break;
                    }
                    case DO_WHILE_LOOP: {
                        DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)tree;
                        StatementTree statementTree = doWhileLoopTree.getStatement();
                        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                        workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                        break;
                    }
                    case IF: {
                        BlockTree blockTree;
                        StatementTree statementTree;
                        IfTree ifTree = (IfTree)tree;
                        if (this.fixThen) {
                            statementTree = ifTree.getThenStatement();
                            blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                            workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                        }
                        if (!this.fixElse) break;
                        statementTree = ifTree.getElseStatement();
                        blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
                        workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
                    }
                }
            }
        }
    }
}

