/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.exceptions;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.netbeans.lib.uihandler.NBBugzillaAccessor;
import org.netbeans.modules.exceptions.ExceptionsSettings;
import org.netbeans.modules.uihandler.Installer;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ReporterResultTopComponent
extends TopComponent
implements HyperlinkListener {
    private static ReporterResultTopComponent instance;
    private static final RequestProcessor RP;
    private static final Logger LOG;
    private static boolean showUpload;
    private static final String ICON_PATH = "org/netbeans/modules/exceptions/reporter.png";
    private static final String PREFERRED_ID = "ReporterResultTopComponent";
    private JEditorPane dataDisplayer;
    private JButton jButton1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;

    private ReporterResultTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"CTL_ReporterResultTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"HINT_ReporterResultTopComponent"));
        this.dataDisplayer.addHyperlinkListener(this);
        this.dataDisplayer.setContentType("text/html");
        Image img = ImageUtilities.loadImage((String)ICON_PATH, (boolean)true);
        this.setIcon(img);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.dataDisplayer = new JEditorPane();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.dataDisplayer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.dataDisplayer.setEditable(false);
        this.jScrollPane1.setViewportView(this.dataDisplayer);
        this.add(this.jScrollPane1, "Center");
        this.jPanel1.setPreferredSize(new Dimension(320, 35));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ReporterResultTopComponent.class, (String)"ReporterResultTopComponent.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReporterResultTopComponent.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addContainerGap(173, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.add(this.jPanel1, "First");
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        RP.post((Runnable)new URLDisplayer(true));
    }

    public static synchronized ReporterResultTopComponent getDefault() {
        if (instance == null) {
            instance = new ReporterResultTopComponent();
        }
        return instance;
    }

    public static synchronized ReporterResultTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("Cannot find ReporterResultTopComponent component. It will not be located properly in the window system.");
            return ReporterResultTopComponent.getDefault();
        }
        if (win instanceof ReporterResultTopComponent) {
            return (ReporterResultTopComponent)win;
        }
        Logger.getLogger(ReporterResultTopComponent.class.getName()).warning("There seem to be multiple components with the 'ReporterResultTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ReporterResultTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (showUpload) {
            return;
        }
        RP.post((Runnable)new URLDisplayer(false));
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public static void showUploadDone(final URL url) {
        if (EventQueue.isDispatchThread()) {
            try {
                ReporterResultTopComponent.findInstance().showUploadDoneImpl(url);
            }
            catch (IOException ex) {
                ReporterResultTopComponent.handleIOException(url, ex);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReporterResultTopComponent.findInstance().showUploadDoneImpl(url);
                    }
                    catch (IOException ex) {
                        ReporterResultTopComponent.handleIOException(url, ex);
                    }
                }
            });
        }
    }

    private void showUploadDoneImpl(URL url) throws IOException {
        assert (EventQueue.isDispatchThread());
        showUpload = true;
        this.open();
        showUpload = false;
        this.loadPage(url, true);
    }

    private void loadPage(URL url, boolean show) {
        assert (EventQueue.isDispatchThread());
        this.dataDisplayer.setText(ReporterResultTopComponent.getLoadingPage(url));
        RP.post((Runnable)new PageUploader(url, show));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL uploadURL(URL url) throws IOException {
        assert (!EventQueue.isDispatchThread());
        File tmpFile = File.createTempFile("loading", ".html");
        tmpFile.deleteOnExit();
        FileOutputStream fw = new FileOutputStream(tmpFile);
        try {
            URLConnection conn = url.openConnection();
            conn.setReadTimeout(200000);
            conn.setDoOutput(false);
            conn.setDoInput(true);
            conn.setRequestProperty("User-Agent", "NetBeans");
            InputStream is = conn.getInputStream();
            try {
                int ch;
                while ((ch = is.read()) != -1) {
                    fw.write(ch);
                }
            }
            finally {
                is.close();
            }
        }
        finally {
            fw.close();
        }
        return tmpFile.toURI().toURL();
    }

    private static void handleIOException(URL url, IOException ex) {
        ReporterResultTopComponent.handleIOException(url.toString(), ex);
    }

    private static void handleIOException(final String url, IOException ex) {
        LOG.log(Level.INFO, "URL Loading failed", ex);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                instance.dataDisplayer.setText(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"no_data_found", (Object)url));
            }
        });
    }

    private static String getLoadingPage(URL url) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title></title></head><body>");
        sb.append(NbBundle.getMessage(ReporterResultTopComponent.class, (String)"LoadingMessage"));
        sb.append("<a href=\"").append(url.toString()).append("\">").append(url).append("</a>");
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public void hyperlinkUpdate(final HyperlinkEvent e) {
        if (!HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
            return;
        }
        NBBugzillaAccessor accessor = (NBBugzillaAccessor)Lookup.getDefault().lookup(NBBugzillaAccessor.class);
        if (accessor != null) {
            SimpleAttributeSet attributeSet;
            Object bugId;
            AttributeSet ats = e.getSourceElement().getAttributes();
            Object attribute = ats.getAttribute(HTML.getTag("a"));
            if (attribute instanceof SimpleAttributeSet && (bugId = (attributeSet = (SimpleAttributeSet)attribute).getAttribute(HTML.getAttributeKey("id"))) != null) {
                try {
                    Integer.parseInt(bugId.toString());
                    LOG.log(Level.FINE, "Open issue {0}", bugId);
                    accessor.openIssue(bugId.toString());
                    return;
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.INFO, "Invalid id attribute", nfe);
                }
            }
        } else {
            LOG.log(Level.INFO, "Bugzilla Accessor not found");
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
            }
        });
    }

    static {
        RP = new RequestProcessor("ReporterResultTopComponentLoader", 3);
        LOG = Logger.getLogger(ReporterResultTopComponent.class.getName());
        showUpload = false;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ReporterResultTopComponent.getDefault();
        }
    }

    private class PageUploader
    implements Runnable {
        private URL localData = null;
        private final URL url;
        private final boolean show;

        private PageUploader(URL url, boolean show) {
            this.url = url;
            this.show = show;
        }

        @Override
        public void run() {
            try {
                if (EventQueue.isDispatchThread()) {
                    if (this.show) {
                        ReporterResultTopComponent topComponent = ReporterResultTopComponent.this;
                        topComponent.requestVisible();
                        topComponent.requestActive();
                    }
                    ReporterResultTopComponent.this.dataDisplayer.setPage(this.localData);
                } else {
                    LOG.log(Level.FINE, "Loading: {0}", this.url);
                    this.localData = ReporterResultTopComponent.uploadURL(this.url);
                    EventQueue.invokeLater(this);
                }
            }
            catch (IOException ex) {
                ReporterResultTopComponent.handleIOException(this.url, ex);
            }
        }
    }

    private class URLDisplayer
    implements Runnable {
        private String urlStr = null;
        private final boolean show;

        public URLDisplayer(boolean show) {
            this.show = show;
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                try {
                    ReporterResultTopComponent.this.loadPage(new URL(this.urlStr), this.show);
                }
                catch (MalformedURLException ex) {
                    ReporterResultTopComponent.handleIOException(this.urlStr, ex);
                }
            } else {
                String userName = new ExceptionsSettings().getUserName();
                if (userName != null && !"".equals(userName)) {
                    this.urlStr = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userNameURL") + userName;
                } else {
                    String userId = Installer.findIdentity();
                    if (userId != null) {
                        this.urlStr = NbBundle.getMessage(ReporterResultTopComponent.class, (String)"userIdURL") + userId;
                    }
                }
                if (this.urlStr == null) {
                    return;
                }
                EventQueue.invokeLater(this);
            }
        }
    }
}

