/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.netbeans.modules.spellchecker.TrieDictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.DictionaryProvider;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryProviderImpl
implements DictionaryProvider {
    private Map<String, Dictionary> dictionaries = new HashMap<String, Dictionary>();

    public synchronized void clearDictionaries() {
        this.dictionaries.clear();
    }

    public synchronized Dictionary getDictionary(Locale locale) {
        Iterator<String> suffixes = DictionaryProviderImpl.getLocalizingSuffixes(locale);
        while (suffixes.hasNext()) {
            Dictionary current = this.dictionaries.get(suffixes.next());
            if (current == null) continue;
            return current;
        }
        return this.createDictionary(locale);
    }

    public static synchronized Locale[] getInstalledDictionariesLocales() {
        File[] dirs = new File[]{new File(System.getProperty("netbeans.home"), "modules" + File.separatorChar + "dict"), new File(System.getProperty("netbeans.user"), "modules" + File.separatorChar + "dict"), InstalledFileLocator.getDefault().locate("modules/dict", null, false)};
        HashSet<Locale> locales = new HashSet<Locale>();
        for (int dirCntr = 0; dirCntr < dirs.length; ++dirCntr) {
            File[] children;
            if (dirs[dirCntr] == null || (children = dirs[dirCntr].listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().startsWith("dictionary_");
                }
            })) == null) continue;
            for (int cntr = 0; cntr < children.length; ++cntr) {
                String name = children[cntr].getName();
                int dot = (name = name.substring("dictionary_".length())).indexOf(46);
                if (dot != -1) {
                    name = name.substring(0, dot);
                }
                StringTokenizer tok = new StringTokenizer(name, "_");
                String language = "";
                String country = "";
                String variant = "";
                if (tok.hasMoreTokens()) {
                    language = tok.nextToken();
                    if (tok.hasMoreTokens()) {
                        country = tok.nextToken();
                        if (tok.hasMoreTokens()) {
                            variant = tok.nextToken();
                        }
                    }
                }
                locales.add(new Locale(language, country, variant));
            }
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    private synchronized Dictionary createDictionary(Locale locale) {
        try {
            ArrayList<URL> sources = new ArrayList<URL>();
            String suffix = DictionaryProviderImpl.getDictionaryStream(locale, sources);
            if (suffix == null) {
                return null;
            }
            Dictionary dict = TrieDictionary.getDictionary(suffix, sources);
            this.dictionaries.put(suffix, dict);
            return dict;
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDictionaryStream(Locale locale, List<URL> streams) throws IOException {
        Iterator<String> suffixes = DictionaryProviderImpl.getLocalizingSuffixes(locale);
        while (suffixes.hasNext()) {
            String currentSuffix = suffixes.next();
            File file = InstalledFileLocator.getDefault().locate("modules/dict/dictionary" + currentSuffix + ".txt", null, false);
            if (file != null) {
                streams.add(file.toURI().toURL());
                return currentSuffix;
            }
            file = InstalledFileLocator.getDefault().locate("modules/dict/dictionary" + currentSuffix + ".description", null, false);
            if (file == null) continue;
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    streams.add(new URL(line));
                }
                String string = currentSuffix;
                return string;
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }
        return null;
    }

    static Iterator<String> getLocalizingSuffixes(Locale locale) {
        return new LocaleIterator(locale);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleIterator
    implements Iterator<String> {
        private boolean empty = false;
        private Locale locale;
        private Locale initLocale;
        private String current;
        private String branding;

        public LocaleIterator(Locale locale) {
            this.locale = this.initLocale = locale;
            this.current = '_' + locale.toString();
            this.branding = NbBundle.getBranding() == null ? null : "_" + NbBundle.getBranding();
        }

        @Override
        public String next() throws NoSuchElementException {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            String ret = this.branding == null ? this.current : this.branding + this.current;
            int lastUnderbar = this.current.lastIndexOf(95);
            if (lastUnderbar == 0) {
                if (this.empty) {
                    this.reset();
                } else {
                    this.current = "";
                    this.empty = true;
                }
            } else if (lastUnderbar == -1) {
                this.reset();
            } else {
                this.current = this.current.substring(0, lastUnderbar);
            }
            return ret;
        }

        private void reset() {
            if (this.branding != null) {
                this.current = '_' + this.initLocale.toString();
                int idx = this.branding.lastIndexOf(95);
                this.branding = idx == 0 ? null : this.branding.substring(0, idx);
                this.empty = false;
            } else {
                this.current = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

