/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackPanel;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.CallStackTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ThreadStateResources;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadDumpFilter;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStackVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateColumnImpl;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadStateIcon;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ThreadStackVisualizer
extends JPanel
implements Visualizer<ThreadStackVisualizerConfiguration>,
SessionStateListener,
DataFilterListener {
    private static final RequestProcessor RP = new RequestProcessor(ThreadStackVisualizer.class.getName(), 1);
    private final ThreadStackVisualizerConfiguration configuration;
    private ThreadDump descriptor;
    private ThreadStackVisualizerConfiguration.StackNameProvider stackNameProvider;
    private long dumpTime;
    private final MultipleCallStackPanel stackPanel;
    private JPanel emptyPanel;
    private final CardLayout cardLayout = new CardLayout();
    private DLightSession session;
    private List<DataFilter> filters;
    private int prefferedSelection = -1;
    private final Object lock = new Lock();
    private final Object uiLock = new UiLock();
    private boolean needUpdate = false;

    ThreadStackVisualizer(ThreadStackVisualizerConfiguration configuraiton, StackDataProvider sourceFileInfo) {
        this.descriptor = configuraiton.getThreadDump();
        this.dumpTime = configuraiton.getDumpTime();
        this.stackNameProvider = configuraiton.getStackNameProvider();
        this.configuration = configuraiton;
        this.stackPanel = MultipleCallStackPanel.createInstance((SourceFileInfoDataProvider)sourceFileInfo);
        this.setLayout(this.cardLayout);
        this.emptyPanel = new JPanel();
        this.add((Component)this.emptyPanel, "empty");
        this.add((Component)this.stackPanel, "stack");
        if (this.descriptor == null || this.descriptor.getThreadStates().isEmpty()) {
            this.setEmptyContent();
        } else {
            this.setNonEmptyContent();
        }
    }

    private void setEmptyContent() {
        assert (SwingUtilities.isEventDispatchThread());
        this.cardLayout.show(this, "empty");
        this.emptyPanel.removeAll();
        this.emptyPanel.setLayout(new BoxLayout(this.emptyPanel, 1));
        long time = 0L;
        if (this.descriptor != null) {
            time = ThreadStateColumnImpl.timeStampToMilliSeconds(this.descriptor.getTimestamp()) - this.dumpTime;
        }
        String timeString = TimeLineUtils.getMillisValue(time);
        String message = NbBundle.getMessage(ThreadStackVisualizer.class, (String)"ThreadStackVisualizerNoStackAt", (Object)timeString);
        JLabel label = new JLabel(message);
        label.setAlignmentX(0.5f);
        this.emptyPanel.add(label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNonEmptyContent() {
        Object object = this.lock;
        synchronized (object) {
            long time = ThreadStateColumnImpl.timeStampToMilliSeconds(this.descriptor.getTimestamp()) - this.dumpTime;
            String timeString = TimeLineUtils.getMillisValue(time);
            final String rootName = NbBundle.getMessage(ThreadStackVisualizer.class, (String)"ThreadStackVisualizerStackAt", (Object)timeString);
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    final ThreadSnapshot[] snapshots = ThreadStackVisualizer.this.descriptor.getThreadStates().toArray(new ThreadSnapshot[0]);
                    final Vector<List> stacks = new Vector<List>();
                    stacks.setSize(snapshots.length);
                    int size = snapshots.length;
                    for (int i = 0; i < size; ++i) {
                        ThreadSnapshot snapshot = snapshots[i];
                        ThreadState.MSAState msa = snapshot.getState();
                        ThreadStateResources res = ThreadStateResources.forState(msa);
                        if (res == null) continue;
                        stacks.set(i, snapshot.getStack());
                    }
                    UIThread.invoke((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = ThreadStackVisualizer.this.uiLock;
                            synchronized (object) {
                                assert (SwingUtilities.isEventDispatchThread());
                                ThreadStackVisualizer.this.stackPanel.clean();
                                ThreadStackVisualizer.this.stackPanel.setRootVisible(rootName);
                                int size = snapshots.length;
                                for (int i = 0; i < size; ++i) {
                                    List functionCalls;
                                    ThreadSnapshot snapshot = snapshots[i];
                                    ThreadState.MSAState msa = snapshot.getState();
                                    ThreadStateResources res = ThreadStateResources.forState(msa);
                                    if (res == null || (functionCalls = (List)stacks.get(i)) == null) continue;
                                    ThreadStackVisualizer.this.stackPanel.add(ThreadStackVisualizer.this.stackNameProvider.getStackName(snapshot), (Icon)new ThreadStateIcon(msa, 10, 10), functionCalls, ThreadStackVisualizer.this.configuration.getStackNodeActionsProvider().getStackNodeActions(snapshot.getThreadInfo().getThreadId()));
                                    if (ThreadStackVisualizer.this.configuration.getPreferredSelection() != (long)snapshot.getThreadInfo().getThreadId()) continue;
                                    ThreadStackVisualizer.this.prefferedSelection = i;
                                }
                                ThreadStackVisualizer.this.cardLayout.show(ThreadStackVisualizer.this, "stack");
                                ThreadStackVisualizer.this.selectRootNode();
                            }
                        }
                    });
                }
            }, (String)"Fill in panel for a stack");
        }
    }

    void selectRootNode() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (ThreadStackVisualizer.this.configuration.getPrefferedExpansion() == ThreadStackVisualizerConfiguration.ExpansionMode.ExpandAll) {
                    ThreadStackVisualizer.this.stackPanel.expandAll();
                }
                int i = 0;
                for (Node node : ThreadStackVisualizer.this.stackPanel.getExplorerManager().getRootContext().getChildren().getNodes()) {
                    if (i == ThreadStackVisualizer.this.prefferedSelection) {
                        try {
                            if (ThreadStackVisualizer.this.configuration.getPrefferedExpansion() == ThreadStackVisualizerConfiguration.ExpansionMode.ExpandCurrent) {
                                ThreadStackVisualizer.this.stackPanel.expandNode(node);
                            }
                            ThreadStackVisualizer.this.stackPanel.getExplorerManager().setSelectedNodes(new Node[]{node});
                        }
                        catch (PropertyVetoException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        break;
                    }
                    ++i;
                }
            }
        }, 500);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"CallStackDetails");
    }

    public ThreadStackVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return CallStackTopComponent.findInstance();
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.stackPanel != null) {
            return this.stackPanel.requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.needUpdate) {
                return;
            }
            Collection<ThreadDumpFilter> dumpFilters = this.getDataFilter(ThreadDumpFilter.class);
            if (dumpFilters != null && !dumpFilters.isEmpty()) {
                ThreadDumpFilter dumpFilter = dumpFilters.iterator().next();
                this.dumpTime = dumpFilter.getDumpTime();
                this.descriptor = dumpFilter.getThreadDump();
            }
            this.needUpdate = false;
            if (!EventQueue.isDispatchThread()) {
                UIThread.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ThreadStackVisualizer.this.descriptor == null || ThreadStackVisualizer.this.descriptor.getThreadStates().isEmpty()) {
                            ThreadStackVisualizer.this.setEmptyContent();
                        } else {
                            ThreadStackVisualizer.this.setNonEmptyContent();
                        }
                    }
                });
            } else if (this.descriptor == null || this.descriptor.getThreadStates().isEmpty()) {
                this.setEmptyContent();
            } else {
                this.setNonEmptyContent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<T> result = new ArrayList<T>();
            for (DataFilter f : this.filters) {
                if (f.getClass() == clazz) {
                    result.add(clazz.cast(f));
                    continue;
                }
                try {
                    Class<T> r = f.getClass().asSubclass(clazz);
                    result.add(clazz.cast(f));
                }
                catch (ClassCastException e) {}
            }
            return result;
        }
    }

    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        if (this.session == null | this.session != session) {
            if (this.session != session && this.session != null) {
                this.session.removeSessionStateListener((SessionStateListener)this);
                this.session.removeDataFilterListener((DataFilterListener)this);
            }
            this.session = session;
            this.session.addDataFilterListener((DataFilterListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        if (isAdjusting) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.filters = new ArrayList<DataFilter>(newSet);
            this.needUpdate = !this.getDataFilter(ThreadDumpFilter.class).isEmpty();
        }
    }

    public void updateVisualizerConfiguration(ThreadStackVisualizerConfiguration aConfiguration) {
        this.configuration.update(aConfiguration);
    }

    private static final class UiLock {
        private UiLock() {
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

