/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.EnumDescriptor;
import org.netbeans.modules.vmd.api.model.EnumDescriptorFactoryRegistry;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptor;
import org.netbeans.modules.vmd.api.model.PrimitiveDescriptorFactoryRegistry;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;

public final class PropertyValue {
    private static final char USER_CODE_ID = 'U';
    private static final char NULL_ID = 'N';
    private static final char REFERENCE_ID = 'R';
    private static final char VALUE_ID = 'V';
    private static final char ENUM_ID = 'E';
    private static final char ARRAY_ID = 'A';
    private static final char ARRAY_SIZE_SEPARATOR = ':';
    private static final char ENCODED_LENGTH_SEPARATOR = '_';
    private static final PropertyValue NULL = new PropertyValue(Kind.NULL);
    private static final List<PropertyValue> EMPTY_ARRAY = new ArrayList<PropertyValue>(0);
    private final Kind kind;
    private TypeID type;
    private String userCode;
    private DesignComponent component;
    private PrimitiveDescriptor descriptor;
    private Object value;
    private List<PropertyValue> array;

    public static PropertyValue createUserCode(String userCode) {
        assert (userCode != null);
        PropertyValue value = new PropertyValue(Kind.USERCODE);
        value.userCode = userCode;
        return value;
    }

    public static PropertyValue createComponentReference(DesignComponent component) {
        assert (component != null);
        return component.getReferenceValue();
    }

    static PropertyValue createComponentReferenceCore(DesignComponent component) {
        assert (Debug.isFriend(DesignComponent.class, "<init>"));
        assert (component != null);
        TypeID type = component.getType();
        assert (type.getKind() == TypeID.Kind.COMPONENT);
        PropertyValue val = new PropertyValue(Kind.REFERENCE);
        val.type = type;
        val.component = component;
        return val;
    }

    public static PropertyValue createNull() {
        return NULL;
    }

    public static PropertyValue createValue(PrimitiveDescriptor descriptor, TypeID type, Object value) {
        assert (descriptor != null);
        assert (type != null);
        assert (type.getKind() == TypeID.Kind.PRIMITIVE);
        assert (type.getDimension() == 0);
        assert (value != null);
        assert (descriptor.isValidInstance(value));
        PropertyValue val = new PropertyValue(Kind.VALUE);
        val.descriptor = descriptor;
        val.type = type;
        val.value = value;
        return val;
    }

    public static PropertyValue createValue(String projectType, TypeID type, Object value) {
        if (type.getKind() == TypeID.Kind.ENUM) {
            return PropertyValue.createEnumValue(EnumDescriptorFactoryRegistry.getDescriptor(projectType, type), type, value);
        }
        return PropertyValue.createValue(PrimitiveDescriptorFactoryRegistry.getDescriptor(projectType, type), type, value);
    }

    public static PropertyValue createEnumValue(EnumDescriptor descriptor, TypeID type, Object value) {
        assert (descriptor != null);
        assert (type != null);
        assert (type.getKind() == TypeID.Kind.ENUM);
        assert (type.getDimension() == 0);
        assert (value != null);
        assert (descriptor.isValidInstance(value));
        PropertyValue val = new PropertyValue(Kind.ENUM);
        assert (descriptor.values().contains(value));
        val.descriptor = descriptor;
        val.type = type;
        val.value = value;
        return val;
    }

    public static PropertyValue createArray(TypeID componentType, List<PropertyValue> array) {
        assert (componentType != null);
        assert (array != null);
        assert (PropertyValue.createArrayAssert(array, componentType));
        PropertyValue val = new PropertyValue(Kind.ARRAY);
        val.type = componentType.getArrayType();
        val.array = Collections.unmodifiableList(new ArrayList<PropertyValue>(array));
        return val;
    }

    private static boolean createArrayAssert(List<PropertyValue> array, TypeID componentType) {
        for (PropertyValue propertyValue : array) {
            assert (propertyValue != null);
            assert (propertyValue.isCompatible(componentType));
        }
        return true;
    }

    public static PropertyValue createEmptyArray(TypeID componentType) {
        return PropertyValue.createArray(componentType, EMPTY_ARRAY);
    }

    private PropertyValue(Kind valueType) {
        this.kind = valueType;
    }

    public Kind getKind() {
        return this.kind;
    }

    public TypeID getType() {
        return this.type;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public DesignComponent getComponent() {
        return this.component;
    }

    public Object getPrimitiveValue() {
        return this.value;
    }

    public List<PropertyValue> getArray() {
        return this.array;
    }

    void collectAllComponentReferences(Collection<DesignComponent> references) {
        assert (Debug.isFriend(DesignComponent.class, "writeProperty") || Debug.isFriend(DesignComponent.class, "setComponentDescriptor") || Debug.isFriend(PropertyValue.class, "collectAllComponentReferences") || Debug.isFriend(Debug.class, "collectAllComponentReferences"));
        switch (this.kind) {
            case USERCODE: 
            case NULL: 
            case VALUE: 
            case ENUM: {
                return;
            }
            case REFERENCE: {
                references.add(this.component);
                return;
            }
            case ARRAY: {
                if (this.type.getKind() == TypeID.Kind.COMPONENT) {
                    for (PropertyValue propertyValue : this.array) {
                        propertyValue.collectAllComponentReferences(references);
                    }
                }
                return;
            }
        }
        Debug.error("Invalid state", this);
    }

    public boolean isCompatible(TypeID requiredType) {
        if (this.type == null) {
            return true;
        }
        if (this.kind == Kind.REFERENCE) {
            return this.component.getDocument().getDescriptorRegistry().isInHierarchy(requiredType, this.component.getType());
        }
        return this.type.equals(requiredType);
    }

    public boolean isCompatible(PropertyDescriptor propertyDescriptor) {
        PropertyValue defaultValue;
        if (propertyDescriptor == null) {
            return false;
        }
        if (this.kind == Kind.NULL ? !propertyDescriptor.isAllowNull() && ((defaultValue = propertyDescriptor.getDefaultValue()) == null || defaultValue.getKind() != Kind.NULL) : this.kind == Kind.USERCODE && !propertyDescriptor.isAllowUserCode()) {
            return false;
        }
        return this.isCompatible(propertyDescriptor.getType());
    }

    public String serialize() {
        switch (this.kind) {
            case USERCODE: {
                return 'U' + this.userCode;
            }
            case NULL: {
                return Character.toString('N');
            }
            case REFERENCE: {
                return "" + 'R' + this.component.getComponentID();
            }
            case VALUE: {
                return 'V' + this.descriptor.serialize(this.value);
            }
            case ENUM: {
                return 'E' + this.descriptor.serialize(this.value);
            }
            case ARRAY: {
                StringBuilder sb = new StringBuilder();
                sb.append('A').append(this.array.size()).append(':');
                for (PropertyValue propertyValue : this.array) {
                    String serialized = propertyValue.serialize();
                    sb.append(serialized.length()).append('_').append(serialized);
                }
                return sb.toString();
            }
        }
        throw Debug.error("Cannot serialize property value", this.type);
    }

    public static PropertyValue deserialize(String serialized, DesignDocument document, TypeID type) throws Exception {
        assert (serialized != null && serialized.length() >= 1);
        assert (document != null && type != null);
        switch (serialized.charAt(0)) {
            case 'U': {
                if (serialized.substring(1) == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createUserCode(serialized.substring(1));
            }
            case 'N': {
                return PropertyValue.createNull();
            }
            case 'R': {
                int componentID = Integer.parseInt(serialized.substring(1));
                if (document.getComponentByUID(componentID) == null) {
                    throw new IllegalArgumentException("No component for given serilezed value");
                }
                return PropertyValue.createComponentReference(document.getComponentByUID(componentID));
            }
            case 'V': {
                PrimitiveDescriptor descriptor = PrimitiveDescriptorFactoryRegistry.getDescriptor(document.getDocumentInterface().getProjectType(), type);
                if (descriptor == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createValue(descriptor, type, descriptor.deserialize(serialized.substring(1)));
            }
            case 'E': {
                EnumDescriptor descriptor = EnumDescriptorFactoryRegistry.getDescriptor(document.getDocumentInterface().getProjectType(), type);
                if (descriptor == null) {
                    throw new IllegalArgumentException();
                }
                return PropertyValue.createEnumValue(descriptor, type, descriptor.deserialize(serialized.substring(1)));
            }
            case 'A': {
                int pos = 1;
                int arrayLengthIndex = serialized.indexOf(58, pos);
                assert (arrayLengthIndex > pos);
                int arrayLength = Integer.parseInt(serialized.substring(pos, arrayLengthIndex));
                assert (arrayLength >= 0);
                pos = arrayLengthIndex + 1;
                TypeID componentType = type.getComponentType();
                ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
                for (int a = 0; a < arrayLength; ++a) {
                    int index = serialized.indexOf(95, pos);
                    assert (index > pos);
                    int elementLength = Integer.parseInt(serialized.substring(pos, index));
                    assert (elementLength >= 0);
                    pos = index + 1;
                    propertyValues.add(PropertyValue.deserialize(serialized.substring(pos, pos + elementLength), document, componentType));
                    pos += elementLength;
                }
                return PropertyValue.createArray(componentType, propertyValues);
            }
        }
        Debug.warning("Cannot deserialize property value", type, serialized);
        throw new IllegalArgumentException("Cannot deserialize property value " + type + " " + serialized);
    }

    public String toString() {
        return this.serialize();
    }

    public static enum Kind {
        USERCODE,
        NULL,
        REFERENCE,
        VALUE,
        ENUM,
        ARRAY;

    }
}

