/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.ListenerManager;
import org.netbeans.modules.vmd.api.model.PropertyValue;

public final class DesignEventFilter {
    private DesignEventFilter[] childFilters;
    private boolean global;
    private boolean creation;
    private boolean selection;
    private final ArrayList<ComponentItem> components = new ArrayList();
    private final ArrayList<HierarchyItem> hierarchy = new ArrayList();
    private final ArrayList<DescentItem> descents = new ArrayList();
    private final ArrayList<ParentItem> parents = new ArrayList();
    private final ArrayList<Long> descriptors = new ArrayList();

    public DesignEventFilter(DesignEventFilter ... childFilters) {
        assert (this.constructorAssert(childFilters));
        this.childFilters = childFilters;
    }

    private boolean constructorAssert(DesignEventFilter ... childFilters) {
        for (DesignEventFilter filter : childFilters) {
            assert (filter != null);
        }
        return true;
    }

    public DesignEventFilter setGlobal(boolean global) {
        this.global = global;
        return this;
    }

    public DesignEventFilter setCreation(boolean creation) {
        this.creation = creation;
        return this;
    }

    public DesignEventFilter setSelection(boolean selection) {
        this.selection = selection;
        return this;
    }

    public DesignEventFilter addComponentFilter(DesignComponent component, boolean includingChildren) {
        ComponentItem item = new ComponentItem();
        item.componentID = component.getComponentID();
        item.includingChildren = includingChildren;
        this.components.add(item);
        return this;
    }

    public DesignEventFilter removeComponentFilter(DesignComponent component, boolean includingChildren) {
        long componentID = component.getComponentID();
        Iterator<ComponentItem> it = this.components.iterator();
        while (it.hasNext()) {
            ComponentItem componentItem = it.next();
            if (componentItem.componentID != componentID || componentItem.includingChildren != includingChildren) continue;
            it.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addHierarchyFilter(DesignComponent component, boolean includingChildren) {
        HierarchyItem item = new HierarchyItem();
        item.componentID = component.getComponentID();
        item.includingChildren = includingChildren;
        this.hierarchy.add(item);
        return this;
    }

    public DesignEventFilter removeHierarchyFilter(DesignComponent component, boolean includingChildren) {
        long componentID = component.getComponentID();
        Iterator<HierarchyItem> it = this.hierarchy.iterator();
        while (it.hasNext()) {
            HierarchyItem hierarchyItem = it.next();
            if (hierarchyItem.componentID != componentID || hierarchyItem.includingChildren != includingChildren) continue;
            it.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addParentFilter(DesignComponent component, int levels, boolean hierarchyOnly) {
        ParentItem item = new ParentItem();
        item.componentID = component.getComponentID();
        item.levels = levels;
        item.hierarchyOnly = hierarchyOnly;
        this.parents.add(item);
        return this;
    }

    public DesignEventFilter removeParentFilter(DesignComponent component, int levels, boolean hierarchyOnly) {
        long componentID = component.getComponentID();
        Iterator<ParentItem> it = this.parents.iterator();
        while (it.hasNext()) {
            ParentItem parentItem = it.next();
            if (parentItem.componentID != componentID || parentItem.levels != levels || parentItem.hierarchyOnly != hierarchyOnly) continue;
            it.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addDescentFilter(DesignComponent component, String propertyName) {
        DescentItem item = new DescentItem();
        item.componentID = component.getComponentID();
        item.propertyName = propertyName;
        this.descents.add(item);
        return this;
    }

    public DesignEventFilter removeDescentFilter(DesignComponent component, String propertyName) {
        long componentID = component.getComponentID();
        Iterator<DescentItem> it = this.descents.iterator();
        while (it.hasNext()) {
            DescentItem descentItem = it.next();
            if (descentItem.componentID != componentID || !descentItem.propertyName.equals(propertyName)) continue;
            it.remove();
            break;
        }
        return this;
    }

    public DesignEventFilter addDescriptorFilter(DesignComponent component) {
        this.descriptors.add(component.getComponentID());
        return this;
    }

    public DesignEventFilter removeDescriptorFilter(DesignComponent component) {
        this.descriptors.remove(component.getComponentID());
        return this;
    }

    boolean isGlobal() {
        return this.global;
    }

    boolean isAffected(DesignDocument document, DesignEvent event) {
        DesignComponent component;
        assert (Debug.isFriend(ListenerManager.class, "fireEventCore") || Debug.isFriend(DesignEventFilter.class, "isAffected"));
        boolean changed = false;
        for (DescentItem item : this.descents) {
            DesignComponent component2 = document.getComponentByUID(item.componentID);
            if (component2 == null || !event.isComponentPropertyChanged(component2, item.propertyName)) continue;
            item.components = null;
            changed = true;
        }
        if (!this.parents.isEmpty()) {
            Set<DesignComponent> fullyAffectedHierarchies = event.getFullyAffectedHierarchies();
            block1: for (ParentItem item : this.parents) {
                DesignComponent component3 = document.getComponentByUID(item.componentID);
                if (component3 == null || item.components == null) continue;
                for (DesignComponent parentComponent : item.components) {
                    if (!fullyAffectedHierarchies.contains(parentComponent)) continue;
                    item.components = null;
                    changed = true;
                    continue block1;
                }
            }
        }
        for (DesignEventFilter filter : this.childFilters) {
            if (!filter.isAffected(document, event)) continue;
            return true;
        }
        if (changed) {
            return true;
        }
        if (this.global) {
            return true;
        }
        if (this.creation && !event.getCreatedComponents().isEmpty()) {
            return true;
        }
        if (this.selection && event.isSelectionChanged()) {
            return true;
        }
        Set<DesignComponent> fullyComponents = event.getFullyAffectedComponents();
        Set<DesignComponent> partlyComponents = event.getPartlyAffectedComponents();
        Set<DesignComponent> fullyHierarchies = event.getFullyAffectedHierarchies();
        Set<DesignComponent> partlyHierarchies = event.getPartlyAffectedHierarchies();
        Set<DesignComponent> fullyDescriptors = event.getDescriptorChangedComponents();
        for (ComponentItem componentItem : this.components) {
            component = document.getComponentByUID(componentItem.componentID);
            if (component == null) continue;
            if (fullyComponents.contains(component)) {
                return true;
            }
            if (!componentItem.includingChildren || !partlyComponents.contains(component)) continue;
            return true;
        }
        for (HierarchyItem hierarchyItem : this.hierarchy) {
            component = document.getComponentByUID(hierarchyItem.componentID);
            if (component == null) continue;
            if (fullyHierarchies.contains(component)) {
                return true;
            }
            if (!hierarchyItem.includingChildren || !partlyHierarchies.contains(component)) continue;
            return true;
        }
        for (Long l : this.descriptors) {
            component = document.getComponentByUID(l);
            if (component == null || !fullyDescriptors.contains(component)) continue;
            return true;
        }
        for (DescentItem descentItem : this.descents) {
            component = document.getComponentByUID(descentItem.componentID);
            if (component == null) continue;
            if (descentItem.components == null) {
                PropertyValue value = component.readProperty(descentItem.propertyName);
                Debug.collectAllComponentReferences(value, descentItem.components = new HashSet());
            }
            for (DesignComponent child : descentItem.components) {
                if (!fullyComponents.contains(child)) continue;
                return true;
            }
        }
        for (ParentItem parentItem : this.parents) {
            component = document.getComponentByUID(parentItem.componentID);
            if (component == null) continue;
            if (parentItem.components == null) {
                DesignComponent parentComponent = component;
                parentItem.components = new ArrayList();
                for (int a = 0; a <= parentItem.levels; ++a) {
                    parentItem.components.add(parentComponent);
                    if (parentComponent == null) break;
                    parentComponent = parentComponent.getParentComponent();
                }
            }
            for (DesignComponent parent : parentItem.components) {
                if (fullyHierarchies.contains(parent)) {
                    return true;
                }
                if (parentItem.hierarchyOnly || !fullyComponents.contains(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private static final class ParentItem {
        private long componentID;
        private int levels;
        private ArrayList<DesignComponent> components;
        public boolean hierarchyOnly;

        private ParentItem() {
        }
    }

    private static final class DescentItem {
        private long componentID;
        private String propertyName;
        private HashSet<DesignComponent> components;

        private DescentItem() {
        }
    }

    private static final class HierarchyItem {
        private long componentID;
        private boolean includingChildren;

        private HierarchyItem() {
        }
    }

    private static final class ComponentItem {
        private long componentID;
        private boolean includingChildren;

        private ComponentItem() {
        }
    }
}

