/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.java;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.spring.java.JavaUtils;
import org.netbeans.modules.spring.java.MatchType;
import org.netbeans.modules.spring.java.Property;

public class PropertyFinder {
    private final ElementUtilities eu;
    private final TypeMirror type;
    private final String matchText;
    private final Map<String, Property> name2Prop = new HashMap<String, Property>();
    private final MatchType matchType;

    public PropertyFinder(TypeMirror typeMirror, String string, ElementUtilities elementUtilities, MatchType matchType) {
        this.type = typeMirror;
        this.matchText = string;
        this.eu = elementUtilities;
        this.matchType = matchType;
    }

    public Property[] findProperties() {
        this.name2Prop.clear();
        this.eu.getMembers(this.type, new ElementUtilities.ElementAcceptor(){

            public boolean accept(Element element, TypeMirror typeMirror) {
                if (element.getKind() != ElementKind.METHOD) {
                    return false;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                String string = executableElement.getSimpleName().toString();
                if (JavaUtils.isGetter(executableElement)) {
                    String string2 = JavaUtils.getPropertyName(string);
                    if (!PropertyFinder.this.match(string2)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertyGetter(string2, executableElement);
                    return true;
                }
                if (JavaUtils.isSetter(executableElement)) {
                    String string3 = JavaUtils.getPropertyName(string);
                    if (!PropertyFinder.this.match(string3)) {
                        return false;
                    }
                    PropertyFinder.this.addPropertySetter(string3, executableElement);
                    return true;
                }
                return false;
            }
        });
        return this.name2Prop.values().toArray(new Property[0]);
    }

    private void addPropertySetter(String string, ExecutableElement executableElement) {
        Property property = this.getProperty(string);
        property.setSetter(executableElement);
    }

    private void addPropertyGetter(String string, ExecutableElement executableElement) {
        Property property = this.getProperty(string);
        property.setGetter(executableElement);
    }

    private Property getProperty(String string) {
        Property property = this.name2Prop.get(string);
        if (property == null) {
            property = new Property(string);
            this.name2Prop.put(string, property);
        }
        return property;
    }

    private boolean match(String string) {
        int n = this.matchType == MatchType.PREFIX ? this.matchText.length() : Math.max(string.length(), this.matchText.length());
        return string.regionMatches(0, this.matchText, 0, n);
    }
}

