/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.openide.util.Exceptions;

public class DependencyTreeFactory {
    public static DependencyNode createDependencyTree(MavenProject project, MavenEmbedder embedder, String scope) {
        try {
            PlexusContainer container = embedder.getPlexusContainer();
            DependencyTreeBuilder builder = (DependencyTreeBuilder)container.lookup(DependencyTreeBuilder.ROLE);
            ArtifactFactory factory = (ArtifactFactory)container.lookup(ArtifactFactory.ROLE);
            ArtifactMetadataSource source = (ArtifactMetadataSource)container.lookup(ArtifactMetadataSource.ROLE);
            ArtifactCollector collector = (ArtifactCollector)container.lookup(ArtifactCollector.ROLE);
            return DependencyTreeFactory.createDependencyTree(project, builder, embedder.getLocalRepository(), factory, source, collector, scope);
        }
        catch (ComponentLookupException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private static DependencyNode createDependencyTree(MavenProject project, DependencyTreeBuilder dependencyTreeBuilder, ArtifactRepository localRepository, ArtifactFactory artifactFactory, ArtifactMetadataSource artifactMetadataSource, ArtifactCollector artifactCollector, String scope) {
        ArtifactFilter artifactFilter = DependencyTreeFactory.createResolvingArtifactFilter(scope);
        try {
            return dependencyTreeBuilder.buildDependencyTree(project, localRepository, artifactFactory, artifactMetadataSource, artifactFilter, artifactCollector);
        }
        catch (DependencyTreeBuilderException exception) {
            return null;
        }
    }

    private static ArtifactFilter createResolvingArtifactFilter(String scope) {
        ScopeArtifactFilter filter = scope != null ? new ScopeArtifactFilter(scope) : null;
        return filter;
    }
}

