/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.api;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.impl.ProgressSupport;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.refactoring.spi.impl.UndoManager;
import org.openide.LifecycleManager;
import org.openide.util.Parameters;

public final class RefactoringSession {
    private final LinkedList<RefactoringElementImplementation> internalList;
    private final RefactoringElementsBag bag;
    private final Collection<RefactoringElement> refactoringElements;
    private final String description;
    private ProgressSupport progressSupport;
    private UndoManager undoManager = UndoManager.getDefault();
    boolean realcommit = true;

    private RefactoringSession(String description) {
        this.internalList = new LinkedList();
        this.bag = SPIAccessor.DEFAULT.createBag(this, this.internalList);
        this.description = description;
        this.refactoringElements = new ElementsCollection();
    }

    @NonNull
    public static RefactoringSession create(@NonNull String description) {
        Parameters.notNull((CharSequence)"description", (Object)description);
        return new RefactoringSession(description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Problem doRefactoring(boolean saveAfterDone) {
        long time = System.currentTimeMillis();
        Iterator it = this.internalList.iterator();
        this.fireProgressListenerStart(0, this.internalList.size() + 1);
        if (this.realcommit) {
            this.undoManager.transactionStarted();
            this.undoManager.setUndoDescription(this.description);
        }
        try {
            try {
                while (it.hasNext()) {
                    this.fireProgressListenerStep();
                    RefactoringElementImplementation element = (RefactoringElementImplementation)it.next();
                    if (!element.isEnabled() || element.getStatus() == 2 || element.getStatus() == 3) continue;
                    element.performChange();
                }
            }
            finally {
                for (Transaction commit : SPIAccessor.DEFAULT.getCommits(this.bag)) {
                    commit.commit();
                }
            }
            if (saveAfterDone) {
                LifecycleManager.getDefault().saveAll();
            }
            for (RefactoringElementImplementation fileChange : SPIAccessor.DEFAULT.getFileChanges(this.bag)) {
                if (!fileChange.isEnabled()) continue;
                fileChange.performChange();
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
            if (this.realcommit) {
                this.undoManager.addItem(this);
                this.undoManager.transactionEnded(false);
                this.realcommit = false;
            }
        }
        Logger timer = Logger.getLogger("TIMER.RefactoringSession");
        if (timer.isLoggable(Level.FINE)) {
            time = System.currentTimeMillis() - time;
            timer.log(Level.FINE, "refactoringSession.doRefactoring", new Object[]{this.description, this, time});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Problem undoRefactoring(boolean saveAfterDone) {
        try {
            ListIterator<RefactoringElementImplementation> it = this.internalList.listIterator(this.internalList.size());
            this.fireProgressListenerStart(0, this.internalList.size() + 1);
            ArrayList<RefactoringElementImplementation> fileChanges = SPIAccessor.DEFAULT.getFileChanges(this.bag);
            ArrayList<Transaction> commits = SPIAccessor.DEFAULT.getCommits(this.bag);
            ListIterator<RefactoringElementImplementation> fileChangeIterator = fileChanges.listIterator(fileChanges.size());
            while (fileChangeIterator.hasPrevious()) {
                RefactoringElementImplementation f = fileChangeIterator.previous();
                if (!f.isEnabled()) continue;
                f.undoChange();
            }
            ListIterator<Transaction> commitIterator = commits.listIterator(commits.size());
            while (commitIterator.hasPrevious()) {
                commitIterator.previous().rollback();
            }
            while (it.hasPrevious()) {
                this.fireProgressListenerStep();
                RefactoringElementImplementation element = it.previous();
                if (!element.isEnabled() || element.getStatus() == 2 || element.getStatus() == 3) continue;
                element.undoChange();
            }
            if (saveAfterDone) {
                LifecycleManager.getDefault().saveAll();
            }
            this.fireProgressListenerStep();
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    @NonNull
    public Collection<RefactoringElement> getRefactoringElements() {
        return this.refactoringElements;
    }

    public synchronized void addProgressListener(@NonNull ProgressListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        if (this.progressSupport == null) {
            this.progressSupport = new ProgressSupport();
        }
        this.progressSupport.addProgressListener(listener);
    }

    public synchronized void removeProgressListener(@NonNull ProgressListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        if (this.progressSupport != null) {
            this.progressSupport.removeProgressListener(listener);
        }
    }

    RefactoringElementsBag getElementsBag() {
        return this.bag;
    }

    private void fireProgressListenerStart(int type, int count) {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStart(this, type, count);
        }
    }

    private void fireProgressListenerStep() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStep(this);
        }
    }

    private void fireProgressListenerStop() {
        if (this.progressSupport != null) {
            this.progressSupport.fireProgressListenerStop(this);
        }
    }

    private class ElementsCollection
    extends AbstractCollection<RefactoringElement> {
        private ElementsCollection() {
        }

        @Override
        public Iterator<RefactoringElement> iterator() {
            return new Iterator(){
                private final Iterator<RefactoringElementImplementation> inner;
                private final Iterator<RefactoringElementImplementation> inner2;
                {
                    this.inner = RefactoringSession.this.internalList.iterator();
                    this.inner2 = SPIAccessor.DEFAULT.getFileChanges(RefactoringSession.this.bag).iterator();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public RefactoringElement next() {
                    if (this.inner.hasNext()) {
                        return new RefactoringElement(this.inner.next());
                    }
                    return new RefactoringElement(this.inner2.next());
                }

                @Override
                public boolean hasNext() {
                    return this.inner.hasNext() || this.inner2.hasNext();
                }
            };
        }

        @Override
        public int size() {
            return RefactoringSession.this.internalList.size() + SPIAccessor.DEFAULT.getFileChanges(RefactoringSession.this.bag).size();
        }
    }
}

