/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.database;

import java.io.IOException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.database.JdbcInfo;
import org.netbeans.modules.ruby.railsprojects.database.RailsAdapters;
import org.netbeans.modules.ruby.railsprojects.database.RailsDatabaseConfiguration;
import org.openide.LifecycleManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

class PostgreSQLAdapter
extends RailsDatabaseConfiguration {
    PostgreSQLAdapter() {
    }

    @Override
    public String railsGenerationParam() {
        return "postgresql";
    }

    @Override
    public void editConfig(RailsProject project) {
        RubyPlatform platform = RubyPlatform.platformFor((Project)project);
        if (platform.isJRuby()) {
            PostgreSQLAdapter.uncommentTcpIpConfig(project.getProjectDirectory());
        }
    }

    @Override
    public String getDisplayName() {
        return this.railsGenerationParam();
    }

    private static void uncommentTcpIpConfig(FileObject dir) {
        FileObject fo = dir.getFileObject("config/database.yml");
        if (fo != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)fo);
                EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
                if (ec != null) {
                    StyledDocument doc = ec.openDocument();
                    String text = doc.getText(0, doc.getLength());
                    int hostOffset = text.indexOf("#host:");
                    if (hostOffset == -1) {
                        return;
                    }
                    doc.remove(hostOffset, 1);
                    text = doc.getText(0, doc.getLength());
                    int portOffset = text.indexOf("#port:");
                    if (portOffset != -1) {
                        doc.remove(portOffset, 1);
                        text = doc.getText(0, doc.getLength());
                    }
                    int indent = 0;
                    for (int i = hostOffset - 1; i >= 0 && text.charAt(i) != '\n'; --i) {
                        ++indent;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("# (Automatically uncommented by the IDE - JRuby doesn't support socket)\n");
                    for (int i = 0; i < indent; ++i) {
                        sb.append(" ");
                    }
                    doc.insertString(hostOffset, sb.toString(), null);
                    SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                    if (sc != null) {
                        sc.save();
                    } else {
                        LifecycleManager.getDefault().saveAll();
                    }
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            catch (DataObjectNotFoundException dnfe) {
                Exceptions.printStackTrace((Throwable)dnfe);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    @Override
    public JdbcInfo getJdbcInfo() {
        return new JdbcInfo(){

            @Override
            public String getDriverClass() {
                return "org.postgresql.Driver";
            }

            @Override
            public String getURL(String host, String database) {
                return "jdbc:postgresql://" + host + "/" + database;
            }
        };
    }

    @Override
    public String getDatabaseName(String projectName) {
        return projectName + "_development";
    }

    @Override
    public String getTestDatabaseName(String developmentDbName) {
        return RailsAdapters.getTestDatabaseName(developmentDbName);
    }

    @Override
    public String getProductionDatabaseName(String developmentDbName) {
        return RailsAdapters.getProductionDatabaseName(developmentDbName);
    }
}

