/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformProvider;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.gems.GemFilesParser;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.platform.gems.Gems;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.classpath.GemFilter;
import org.netbeans.modules.ruby.rubyproject.RequiredGems;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

final class BootClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
    private static final boolean INCLUDE_NONLIBPLUGINS = Boolean.getBoolean("ruby.include_nonlib_plugins");
    private final File projectDirectory;
    private final RailsProject project;
    private final PropertyEvaluator evaluator;
    private List<PathResourceImplementation> resourcesCache;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final RequiredGems requiredGems;
    private final boolean forTests;
    private final GemFilter gemFilter;
    private final RubyPlatformProvider platformProvider;
    private RubyPlatform platform;

    public BootClassPathImplementation(RailsProject project, File projectDirectory, PropertyEvaluator evaluator, boolean forTests) {
        this.project = project;
        this.projectDirectory = projectDirectory;
        assert (evaluator != null);
        this.evaluator = evaluator;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
        RubyPreferences.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)RubyPreferences.getInstance()));
        this.forTests = forTests;
        RequiredGems[] reqs = RequiredGems.lookup((Project)project);
        this.requiredGems = forTests ? reqs[1] : reqs[0];
        this.gemFilter = new GemFilter(evaluator);
        this.platformProvider = new RubyPlatformProvider(evaluator);
    }

    private synchronized RubyPlatform getPlatform() {
        if (this.platform == null) {
            this.platform = this.platformProvider.getPlatform();
        }
        return this.platform;
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resourcesCache == null) {
            ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
            try {
                result.add(ClassPathSupport.createResource((URL)RubyPlatform.getRubyStubs().getURL()));
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.getPlatform() == null) {
                LOGGER.severe("Cannot resolve platform for project: " + this.projectDirectory);
                return Collections.emptyList();
            }
            if (!this.getPlatform().hasRubyGemsInstalled()) {
                LOGGER.fine("Not RubyGems installed, returning empty result");
                return Collections.emptyList();
            }
            GemManager gemManager = this.getPlatform().getGemManager();
            assert (gemManager != null) : "not null when RubyGems are installed";
            boolean useVendorGemsOnly = this.useVendorGemsOnly();
            Map<String, URL> gemUrls = !useVendorGemsOnly ? gemManager.getGemUrls() : new HashMap();
            Map gemVersions = !useVendorGemsOnly ? gemManager.getGemVersions() : new HashMap();
            for (URL url : gemManager.getNonGemLoadPath()) {
                result.add(ClassPathSupport.createResource((URL)url));
            }
            gemUrls = this.adjustGemsForExplicitVersion(gemUrls);
            File vendor = new File(this.projectDirectory, "vendor");
            if (vendor.exists()) {
                List<URL> vendorPlugins = this.getVendorPlugins(vendor);
                for (URL url : vendorPlugins) {
                    result.add(ClassPathSupport.createResource((URL)url));
                }
                List<URL> combinedGems = this.mergeVendorGems(vendor, new HashMap<String, String>(gemVersions), new HashMap<String, URL>(gemUrls));
                this.filterAndAddGems(combinedGems, result);
            } else {
                this.filterAndAddGems(gemUrls.values(), result);
            }
            this.resourcesCache = Collections.unmodifiableList(result);
        }
        return this.resourcesCache;
    }

    private void filterAndAddGems(Collection<URL> gemsToAdd, List<PathResourceImplementation> result) {
        Collection filtered = this.requiredGems.filterNotRequiredGems(gemsToAdd);
        for (URL url : filtered) {
            String gem = Gems.getGemName((URL)url);
            if (this.gemFilter.include(gem)) {
                result.add(ClassPathSupport.createResource((URL)url));
                continue;
            }
            if (this.gemFilter.exclude(gem)) continue;
            result.add(ClassPathSupport.createResource((URL)url));
        }
        this.requiredGems.setIndexedGems(filtered);
    }

    private boolean useVendorGemsOnly() {
        return new File(this.projectDirectory, "vendor" + File.separator + "gems").exists() && RubyPreferences.isIndexVendorGemsOnly();
    }

    private Map<String, URL> adjustGemsForExplicitVersion(Map<String, URL> gemUrls) {
        File environment = new File(this.projectDirectory, "config" + File.separator + "environment.rb");
        if (!environment.isFile()) {
            return gemUrls;
        }
        FileObject environmentFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)environment));
        if (environmentFO == null) {
            return gemUrls;
        }
        String railsVersion = RailsProjectUtil.getSpecifiedRailsVersion(environmentFO);
        if (railsVersion == null) {
            return gemUrls;
        }
        URL activerecord = gemUrls.get("activerecord");
        if (activerecord == null) {
            return gemUrls;
        }
        String activerecordUrl = activerecord.toExternalForm();
        if (activerecordUrl.indexOf("activerecord-" + railsVersion) != -1) {
            return gemUrls;
        }
        Pattern VERSION_PATTERN = Pattern.compile(".*activerecord-(\\d+(?:\\.\\d+)*(\\.beta)?).*");
        Matcher m = VERSION_PATTERN.matcher(activerecordUrl);
        if (!m.matches()) {
            return gemUrls;
        }
        String defaultVersion = m.group(1);
        boolean first = true;
        for (String gemName : Gems.getRailsGems()) {
            String replace;
            String urlString;
            int index;
            URL url = gemUrls.get(gemName);
            if (url == null || (index = (urlString = url.toExternalForm()).indexOf(replace = gemName + "-" + defaultVersion)) == -1) continue;
            try {
                URL newUrl = new URL(urlString.replace(replace, gemName + "-" + railsVersion));
                if (first) {
                    first = false;
                    FileObject fo = URLMapper.findFileObject((URL)newUrl);
                    if (fo == null) {
                        return gemUrls;
                    }
                    gemUrls = new HashMap<String, URL>(gemUrls);
                }
                gemUrls.put(gemName, newUrl);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return gemUrls;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == RubyInstallation.getInstance() && evt.getPropertyName().equals("roots") || evt.getSource() == RubyPreferences.getInstance() && evt.getPropertyName().equals("vendor-gems")) {
            this.resetCache();
        }
        if (evt.getPropertyName().equals("platform.active")) {
            this.platform = RubyPlatformProvider.getPlatform((String)((String)evt.getNewValue()));
            this.resetCache();
        }
        if (evt.getPropertyName().equals("required.gems.tests") && this.forTests) {
            this.requiredGems.setRequiredGems((String)evt.getNewValue());
            this.resetCache();
        }
        if (evt.getPropertyName().equals("required.gems") && !this.forTests) {
            this.requiredGems.setRequiredGems((String)evt.getNewValue());
            this.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache() {
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            this.resourcesCache = null;
            RubyIndex.resetCache();
        }
        this.support.firePropertyChange("resources", null, null);
    }

    private List<URL> mergeVendorGems(File vendorFile, Map<String, String> gemVersions, Map<String, URL> gemUrls) {
        BootClassPathImplementation.chooseGems(vendorFile.listFiles(), gemVersions, gemUrls);
        return new ArrayList<URL>(gemUrls.values());
    }

    private static void chooseGems(File[] gems, Map<String, String> gemVersions, Map<String, URL> gemUrls) {
        for (File f : gems) {
            File lib;
            String[] info;
            String n;
            if (!f.isDirectory() || "plugins".equals(n = f.getName())) continue;
            if ("rails".equals(n)) {
                BootClassPathImplementation.chooseRails(f.listFiles(), gemVersions, gemUrls);
                continue;
            }
            if ("gems".equals(n) || "gems-jruby".equals(n)) {
                BootClassPathImplementation.chooseGems(f.listFiles(), gemVersions, gemUrls);
            }
            if (n.indexOf(45) == -1 || (info = GemFilesParser.parseNameAndVersion((String)n)) == null || !(lib = new File(f, "lib")).exists()) continue;
            try {
                URL url = lib.toURI().toURL();
                BootClassPathImplementation.addGem(gemVersions, gemUrls, info[0], info[1], url);
            }
            catch (MalformedURLException mufe) {
                Exceptions.printStackTrace((Throwable)mufe);
            }
        }
    }

    private static void addGem(Map<String, String> gemVersions, Map<String, URL> gemUrls, String name, String version, URL url) {
        if (!gemVersions.containsKey(name) || Util.compareVersions((String)version, (String)gemVersions.get(name)) > 0) {
            gemVersions.put(name, version);
            gemUrls.put(name, url);
        }
    }

    private static void chooseRails(File[] gems, Map<String, String> gemVersions, Map<String, URL> gemUrls) {
        for (File f : gems) {
            String version;
            File versionFile;
            File lib;
            String name;
            if (!f.isDirectory()) continue;
            String middleName = name = f.getName();
            if (name.indexOf(95) == -1 && (name.startsWith("action") || name.startsWith("active"))) {
                middleName = name.substring(0, 6) + "_" + name.substring(6);
            }
            if (!(lib = new File(f, "lib")).exists() || !(versionFile = new File(lib, middleName + File.separator + "version.rb")).exists() || (version = RailsProjectUtil.getVersionString(versionFile)) == null) continue;
            try {
                URL url = lib.toURI().toURL();
                BootClassPathImplementation.addGem(gemVersions, gemUrls, name, version, url);
            }
            catch (MalformedURLException mufe) {
                Exceptions.printStackTrace((Throwable)mufe);
            }
        }
    }

    private List<URL> getVendorPlugins(File vendor) {
        assert (vendor != null);
        File plugins = new File(vendor, "plugins");
        if (!plugins.exists()) {
            return Collections.emptyList();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File f : plugins.listFiles()) {
            File lib = new File(f, "lib");
            if (INCLUDE_NONLIBPLUGINS) {
                lib = f;
            }
            if (!lib.exists()) continue;
            try {
                URL url = lib.toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return urls;
    }
}

