/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.Util;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.TopComponent;

public class PropertiesEditorSupport
extends CloneableEditorSupport
implements EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie,
Serializable,
SaveAsCapable {
    static final Logger LOG = Logger.getLogger("org.netbeans.modules.properties.PropertiesEditorSupport");
    private FileStatusListener fsStatusListener;
    transient PropertiesFileEntry myEntry;
    static final long serialVersionUID = 1787354011149868490L;
    private static Map<DataObject, Charset> charsets = Collections.synchronizedMap(new HashMap());

    public PropertiesEditorSupport(PropertiesFileEntry entry) {
        super((CloneableEditorSupport.Env)new Environment(entry), Lookups.singleton((Object)entry.getDataObject()));
        this.myEntry = entry;
    }

    final CloneableEditorSupport.Env desEnv() {
        return (CloneableEditorSupport.Env)this.env;
    }

    protected boolean canClose() {
        if (this.hasOpenedTableComponent()) {
            return true;
        }
        MultiDataObject propDO = this.myEntry.getDataObject();
        if (propDO == null || !propDO.isModified()) {
            return true;
        }
        return super.canClose();
    }

    protected CloneableEditor createCloneableEditor() {
        return new PropertiesEditor(this);
    }

    public final DataObject getDataObject() {
        return this.myEntry.getDataObject();
    }

    private boolean isEnvReadOnly() {
        CloneableEditorSupport.Env myEnv = this.desEnv();
        return myEnv instanceof Environment && !((Environment)myEnv).getFileImpl().canWrite();
    }

    private void attachStatusListener() {
        FileSystem fs;
        if (this.fsStatusListener != null) {
            return;
        }
        try {
            fs = this.myEntry.getFile().getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            ErrorManager.getDefault().notify(65536, (Throwable)ex);
            return;
        }
        this.fsStatusListener = new FsStatusListener();
        fs.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fs));
    }

    private void updateEditorDisplayNames() {
        assert (EventQueue.isDispatchThread());
        String title = this.messageName();
        String htmlTitle = this.messageHtmlName();
        String toolTip = this.messageToolTip();
        Enumeration en = this.allEditors.getComponents();
        while (en.hasMoreElements()) {
            TopComponent tc = (TopComponent)en.nextElement();
            tc.setDisplayName(title);
            tc.setHtmlDisplayName(htmlTitle);
            tc.setToolTipText(toolTip);
        }
    }

    protected void initializeCloneableEditor(CloneableEditor editor) {
        ((PropertiesEditor)editor).initialize(this.myEntry);
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument document = super.createStyledDocument(kit);
        document.putProperty("title", this.myEntry.getFile().toString());
        document.putProperty("stream", this.myEntry.getDataObject());
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument document, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharset charset = new PropertiesEncoding.PropCharset(this.myEntry.getFile());
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
        try {
            editorKit.read(reader, (Document)document, 0);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument document, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        PropertiesEncoding.PropCharsetEncoder encoder = new PropertiesEncoding.PropCharsetEncoder();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoder));
        try {
            editorKit.write(writer, (Document)document, 0, document.getLength());
        }
        finally {
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
    }

    protected boolean notifyModified() {
        this.myEntry.getHandler().autoParse();
        if (!super.notifyModified()) {
            return false;
        }
        if (this.hasOpenedEditorComponent() || this.hasOpenedTableComponent()) {
            ((Environment)this.env).addSaveCookie();
            return true;
        }
        try {
            ((Environment)this.env).save();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        super.notifyModified();
        return true;
    }

    protected Task reloadDocument() {
        Task tsk = super.reloadDocument();
        tsk.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                PropertiesEditorSupport.this.myEntry.getHandler().autoParse();
            }
        });
        return tsk;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        ((Environment)this.env).removeSaveCookie();
    }

    public void open() {
        super.open();
        this.attachStatusListener();
    }

    protected void notifyClosed() {
        if (!this.hasOpenedTableComponent()) {
            boolean wasModified = this.isModified();
            super.notifyClosed();
            if (wasModified && this.myEntry.getFile().isValid() && !this.myEntry.getFile().isVirtual()) {
                this.myEntry.getHandler().reparseNowBlocking();
            }
        }
    }

    protected String messageOpening() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpen", (Object)this.getFileLabel());
    }

    protected String messageOpened() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"LBL_ObjectOpened", (Object)this.getFileLabel());
    }

    private String getFileLabel() {
        PropertiesDataObject propDO = (PropertiesDataObject)this.myEntry.getDataObject();
        return propDO.isMultiLocale() ? propDO.getPrimaryFile().getName() + "(" + Util.getLocaleLabel((MultiDataObject.Entry)this.myEntry) + ")" : propDO.getPrimaryFile().getNameExt();
    }

    protected String messageName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return "";
        }
        return DataEditorSupport.annotateName((String)this.getFileLabel(), (boolean)false, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected String messageHtmlName() {
        if (!this.myEntry.getDataObject().isValid()) {
            return null;
        }
        String rawName = this.getFileLabel();
        String annotatedName = null;
        FileObject entry = this.myEntry.getFile();
        try {
            FileSystem.Status status = entry.getFileSystem().getStatus();
            if (status != null) {
                Set<FileObject> files = Collections.singleton(entry);
                if (status instanceof FileSystem.HtmlStatus) {
                    FileSystem.HtmlStatus hStatus = (FileSystem.HtmlStatus)status;
                    annotatedName = hStatus.annotateNameHtml(rawName, files);
                    if (rawName.equals(annotatedName)) {
                        annotatedName = null;
                    }
                    if (annotatedName != null && !annotatedName.startsWith("<html>")) {
                        annotatedName = "<html>" + annotatedName;
                    }
                }
                if (annotatedName == null) {
                    annotatedName = status.annotateName(rawName, files);
                }
            }
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
        String name = annotatedName != null ? annotatedName : rawName;
        return DataEditorSupport.annotateName((String)name, (boolean)true, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected String messageSave() {
        return NbBundle.getMessage(PropertiesEditorSupport.class, (String)"MSG_SaveFile", (Object)this.getFileLabel());
    }

    protected String messageToolTip() {
        FileObject fo = this.myEntry.getFile();
        return DataEditorSupport.toolTip((FileObject)fo, (boolean)this.isModified(), (!this.myEntry.getFile().canWrite() ? 1 : 0) != 0);
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoStampFlagManager();
    }

    UndoRedo.Manager getUndoRedoManager() {
        return super.getUndoRedo();
    }

    void forceNotifyClosed() {
        super.notifyClosed();
    }

    private void saveThisEntry() throws IOException {
        SaveImpl aa = new SaveImpl(this);
        FileUtil.runAtomicAction((FileSystem.AtomicAction)aa);
        if (!this.env.isModified()) {
            this.myEntry.setModified(false);
        }
    }

    final void superSaveDoc() throws IOException {
        super.saveDocument();
    }

    public void saveAs(FileObject folder, String fileName) throws IOException {
        OpenCookie c;
        String newExtension = FileUtil.getExtension((String)fileName);
        DataObject newDob = null;
        MultiDataObject currentDob = this.myEntry.getDataObject();
        if (!currentDob.isModified() || null == this.getDocument()) {
            DataFolder df = DataFolder.findFolder((FileObject)folder);
            FileObject newFile = folder.getFileObject(fileName);
            if (null != newFile) {
                newFile.delete();
            }
            if (null != (newFile = this.myEntry.copyRename(df.getPrimaryFile(), this.getFileNameNoExtension(fileName), newExtension))) {
                newDob = DataObject.find((FileObject)newFile);
            }
        } else {
            FileObject newFile = FileUtil.createData((FileObject)folder, (String)fileName);
            this.saveDocumentAs(newFile.getOutputStream());
            currentDob.setModified(false);
            newDob = DataObject.find((FileObject)newFile);
        }
        if (null != newDob && null != (c = (OpenCookie)newDob.getCookie(OpenCookie.class))) {
            this.close(false);
            c.open();
        }
    }

    private String getFileNameNoExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    private void saveDocumentAs(final OutputStream output) throws IOException {
        final StyledDocument myDoc = this.getDocument();
        class SaveAsWriter
        implements Runnable {
            private IOException ex;

            SaveAsWriter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream os = null;
                    try {
                        os = new BufferedOutputStream(output);
                        EditorKit kit = PropertiesEditorSupport.this.createEditorKit();
                        PropertiesEditorSupport.this.saveFromKitToStream(myDoc, kit, os);
                        ((OutputStream)os).close();
                        os = null;
                    }
                    catch (BadLocationException ex2) {
                        LOG.log(Level.INFO, null, ex2);
                    }
                    finally {
                        if (os != null) {
                            ((OutputStream)os).close();
                        }
                    }
                }
                catch (IOException e) {
                    this.ex = e;
                }
            }

            public void after() throws IOException {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsWriter saveAsWriter = new SaveAsWriter();
        myDoc.render(saveAsWriter);
        saveAsWriter.after();
    }

    public synchronized boolean hasOpenedTableComponent() {
        PropertiesDataObject dataObject = (PropertiesDataObject)this.myEntry.getDataObject();
        if (dataObject.getBundleStructureOrNull() == null || dataObject.getBundleStructure().getEntryCount() == 0) {
            return false;
        }
        return dataObject.getOpenSupport().hasOpenedTableComponent();
    }

    public synchronized boolean hasOpenedEditorComponent() {
        Enumeration en = this.allEditors.getComponents();
        return en.hasMoreElements();
    }

    private static class SaveImpl
    implements FileSystem.AtomicAction {
        private static final SaveImpl DEFAULT = new SaveImpl(null);
        private final PropertiesEditorSupport des;

        public SaveImpl(PropertiesEditorSupport des) {
            this.des = des;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            if (this.des.desEnv().isModified() && this.des.isEnvReadOnly()) {
                IOException e = new IOException("File is read-only: " + ((Environment)this.des.env).getFileImpl());
                throw e;
            }
            DataObject tmpObj = this.des.getDataObject();
            Charset c = FileEncodingQuery.getEncoding((FileObject)tmpObj.getPrimaryFile());
            try {
                charsets.put(tmpObj, c);
                this.des.superSaveDoc();
            }
            finally {
                charsets.remove(tmpObj);
            }
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass();
        }
    }

    static class StampFlag {
        private long timeStamp;
        private Object atomicFlag;

        public StampFlag(long timeStamp, Object atomicFlag) {
            this.timeStamp = timeStamp;
            this.atomicFlag = atomicFlag;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public Object getAtomicFlag() {
            return this.atomicFlag;
        }
    }

    class UndoRedoStampFlagManager
    extends UndoRedo.Manager {
        WeakHashMap<UndoableEdit, StampFlag> stampFlags = new WeakHashMap(5);

        UndoRedoStampFlagManager() {
        }

        public synchronized boolean addEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), PropertiesEditorSupport.this.myEntry.atomicUndoRedoFlag));
            return super.addEdit(anEdit);
        }

        public boolean replaceEdit(UndoableEdit anEdit) {
            this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), PropertiesEditorSupport.this.myEntry.atomicUndoRedoFlag));
            return super.replaceEdit(anEdit);
        }

        public synchronized void undo() throws CannotUndoException {
            UndoableEdit anEdit = this.editToBeUndone();
            if (anEdit != null) {
                Object atomicFlag = this.stampFlags.get(anEdit).getAtomicFlag();
                super.undo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public synchronized void redo() throws CannotRedoException {
            UndoableEdit anEdit = this.editToBeRedone();
            if (anEdit != null) {
                Object atomicFlag = this.stampFlags.get(anEdit).getAtomicFlag();
                super.redo();
                this.stampFlags.put(anEdit, new StampFlag(System.currentTimeMillis(), atomicFlag));
            }
        }

        public long getTimeStampOfEditToBeUndone() {
            UndoableEdit nextUndo = this.editToBeUndone();
            if (nextUndo == null) {
                return 0L;
            }
            return this.stampFlags.get(nextUndo).getTimeStamp();
        }

        public long getTimeStampOfEditToBeRedone() {
            UndoableEdit nextRedo = this.editToBeRedone();
            if (nextRedo == null) {
                return 0L;
            }
            return this.stampFlags.get(nextRedo).getTimeStamp();
        }

        public Object getAtomicFlagOfEditToBeUndone() {
            UndoableEdit nextUndo = this.editToBeUndone();
            if (nextUndo == null) {
                return null;
            }
            return this.stampFlags.get(nextUndo).getAtomicFlag();
        }

        public Object getAtomicFlagOfEditToBeRedone() {
            UndoableEdit nextRedo = this.editToBeRedone();
            if (nextRedo == null) {
                return null;
            }
            return this.stampFlags.get(nextRedo).getAtomicFlag();
        }
    }

    public static class PropertiesEditor
    extends CloneableEditor {
        protected transient PropertiesFileEntry entry;
        private transient PropertyChangeListener saveCookieLNode;
        static final long serialVersionUID = -2702087884943509637L;

        public PropertiesEditor() {
        }

        public PropertiesEditor(PropertiesEditorSupport support) {
            super((CloneableEditorSupport)support);
        }

        private void initialize(PropertiesFileEntry entry) {
            this.entry = entry;
            Node n = entry.getNodeDelegate();
            this.setActivatedNodes(new Node[]{n});
            this.updateName();
            this.saveCookieLNode = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("cookie".equals(evt.getPropertyName()) || "name".equals(evt.getPropertyName())) {
                        PropertiesEditor.super.updateName();
                    }
                }
            };
            this.entry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.saveCookieLNode, (Object)((Object)this.entry)));
        }

        protected boolean closeLast() {
            return super.closeLast();
        }

        public Image getIcon() {
            PropertiesDataObject propDO = (PropertiesDataObject)this.entry.getDataObject();
            return ImageUtilities.loadImage((String)(propDO.isMultiLocale() ? "org/netbeans/modules/properties/propertiesLocale.gif" : "org/netbeans/modules/properties/propertiesObject.png"));
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.editlocale");
        }

        private JEditorPane getPane() {
            return this.pane;
        }
    }

    public class PropertiesEditAt
    implements EditCookie {
        private String key;

        PropertiesEditAt(String key) {
            this.key = key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void edit() {
            PropertiesEditor editor = (PropertiesEditor)PropertiesEditorSupport.super.openCloneableTopComponent();
            editor.requestActive();
            Element.ItemElem item = PropertiesEditorSupport.this.myEntry.getHandler().getStructure().getItem(this.key);
            if (item != null) {
                int offset = item.getKeyElem().getBounds().getBegin().getOffset();
                if (editor.getPane() != null && editor.getPane().getCaret() != null) {
                    editor.getPane().getCaret().setDot(offset);
                }
            }
        }
    }

    private static final class EnvironmentListener
    extends FileChangeAdapter {
        private Reference<Environment> reference;

        public EnvironmentListener(Environment environment) {
            LOG.finer("new EnvironmentListener(<Environment>)");
            this.reference = new WeakReference<Environment>(environment);
        }

        public void fileDeleted(FileEvent fe) {
            Environment myEnv = this.reference.get();
            if (myEnv != null) {
                myEnv.updateDocumentProperty();
                myEnv.fileRemoved();
            }
        }

        public void fileChanged(FileEvent evt) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("EnviromentListener.fileChanged(...)");
                LOG.finer(" - original file: " + FileUtil.getFileDisplayName((FileObject)evt.getFile()));
                LOG.finer(" - current file: " + FileUtil.getFileDisplayName((FileObject)((FileObject)evt.getSource())));
            }
            if (evt.firedFrom((FileSystem.AtomicAction)SaveImpl.DEFAULT)) {
                return;
            }
            Environment environment = this.reference.get();
            if (environment != null) {
                if (!environment.getFileImpl().equals(evt.getFile())) {
                    evt.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.getFileImpl().addFileChangeListener((FileChangeListener)new EnvironmentListener(environment));
                    return;
                }
                if (evt.getFile().isVirtual()) {
                    environment.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                    environment.fileRemoved();
                    environment.entry.getFile().addFileChangeListener((FileChangeListener)this);
                } else {
                    environment.fileChanged(evt.isExpected(), evt.getTime());
                }
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            Environment myEnv = this.reference.get();
            if (myEnv != null) {
                myEnv.updateDocumentProperty();
                myEnv.fileRenamed();
            }
        }
    }

    private static class Environment
    implements CloneableEditorSupport.Env,
    PropertyChangeListener,
    SaveCookie {
        static final long serialVersionUID = 354528097109874355L;
        private PropertiesFileEntry entry;
        private transient FileLock fileLock;
        private transient FileObject fileObject;
        private transient PropertyChangeSupport propSupp;
        private transient VetoableChangeSupport vetoSupp;
        private transient EnvironmentListener envListener;

        public Environment(PropertiesFileEntry entry) {
            LOG.finer("PropertiesEditorSupport(<PropertiesFileEntry>)");
            LOG.finer(" - new Environment(<PropertiesFileEntry>)");
            this.entry = entry;
            this.envListener = new EnvironmentListener(this);
            entry.getFile().addFileChangeListener((FileChangeListener)this.envListener);
            entry.addPropertyChangeListener(this);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected final DataObject getDataObject() {
            return this.entry.getDataObject();
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            LOG.finer("Environment.addPropertyChangeListener(...)");
            this.prop().addPropertyChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Environment.propertyChange(" + evt.getPropertyName() + ", " + evt.getOldValue() + ", " + evt.getNewValue() + ')');
            }
            if ("valid".equals(evt.getPropertyName())) {
                if (Boolean.FALSE.equals(evt.getOldValue())) {
                    return;
                }
                PropertiesEditorSupport support = (PropertiesEditorSupport)this.findCloneableOpenSupport();
                if (support != null) {
                    this.unmarkModified();
                    support.close(false);
                }
            } else {
                this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            LOG.finer("Environment.removePropertyChangeListener(...)");
            this.prop().removePropertyChangeListener(l);
        }

        public void addVetoableChangeListener(VetoableChangeListener l) {
            LOG.finer("Environment.addVetoableChangeListener(...)");
            this.veto().addVetoableChangeListener(l);
        }

        public void removeVetoableChangeListener(VetoableChangeListener l) {
            LOG.finer("Environment.removeVetoableChangeListener(...)");
            this.veto().removeVetoableChangeListener(l);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (PropertiesEditorSupport)this.entry.getCookieSet().getCookie(EditCookie.class);
        }

        public boolean isValid() {
            return this.entry.getDataObject().isValid();
        }

        public boolean isModified() {
            return this.entry.isModified();
        }

        public void markModified() throws IOException {
            LOG.finer("Environment.markModified()");
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            this.entry.setModified(true);
        }

        public void unmarkModified() {
            LOG.finer("Environment.unmarkModified()");
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
            }
            this.entry.setModified(false);
        }

        final void updateDocumentProperty() {
            StyledDocument doc;
            EditorCookie ec = (EditorCookie)this.getDataObject().getCookie(EditorCookie.class);
            if (ec != null && (doc = ec.getDocument()) != null) {
                doc.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.getDataObject().getPrimaryFile()));
            }
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public Date getTime() {
            this.getFileImpl().refresh();
            return this.getFileImpl().lastModified();
        }

        protected final void changeFile() {
            boolean lockAgain;
            FileObject newFile = this.entry.getFile();
            if (newFile.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    LOG.fine("changeFile releaseLock: " + this.fileLock + " for " + this.fileObject);
                    this.fileLock.releaseLock();
                    lockAgain = true;
                } else {
                    this.fileLock = null;
                    lockAgain = false;
                }
            } else {
                lockAgain = false;
            }
            boolean wasNull = this.fileObject == null;
            this.fileObject = newFile;
            LOG.fine("changeFile: " + newFile + " for " + this.fileObject);
            if (this.envListener != null) {
                this.fileObject.removeFileChangeListener((FileChangeListener)this.envListener);
            }
            this.envListener = new EnvironmentListener(this);
            this.fileObject.addFileChangeListener((FileChangeListener)this.envListener);
            if (lockAgain) {
                try {
                    this.fileLock = this.entry.takeLock();
                    LOG.fine("changeFile takeLock: " + this.fileLock + " for " + this.fileObject);
                }
                catch (IOException e) {
                    Logger.getLogger(PropertiesEditorSupport.class.getName()).log(Level.WARNING, null, e);
                }
            }
            if (!wasNull) {
                this.firePropertyChange("expectedTime", null, this.getTime());
            }
        }

        public InputStream inputStream() throws IOException {
            LOG.finer("Environment.inputStream()");
            return this.getFileImpl().getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            LOG.finer("Environment.outputStream()");
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.entry.takeLock();
            }
            LOG.fine("outputStream after takeLock: " + this.fileLock + " for " + this.fileObject);
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException fse) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.entry.takeLock();
                }
                LOG.fine("ugly workaround for #40552: " + this.fileLock + " for " + this.fileObject);
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public void save() throws IOException {
            LOG.finer("Environment.save()");
            ((PropertiesEditorSupport)this.findCloneableOpenSupport()).saveThisEntry();
        }

        private void firePropertyChange(String name, Object oldValue, Object newValue) {
            this.prop().firePropertyChange(name, oldValue, newValue);
        }

        private void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
            this.veto().fireVetoableChange(name, oldValue, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyChangeSupport prop() {
            Environment environment = this;
            synchronized (environment) {
                if (this.propSupp == null) {
                    this.propSupp = new PropertyChangeSupport(this);
                }
            }
            return this.propSupp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VetoableChangeSupport veto() {
            Environment environment = this;
            synchronized (environment) {
                if (this.vetoSupp == null) {
                    this.vetoSupp = new VetoableChangeSupport(this);
                }
            }
            return this.vetoSupp;
        }

        private void addSaveCookie() {
            LOG.finer("Environment.addSaveCookie(...)");
            if (this.entry.getCookie(SaveCookie.class) == null) {
                this.entry.getCookieSet().add((Node.Cookie)this);
            }
            PropertiesDataObject dataObject = (PropertiesDataObject)this.getDataObject();
            dataObject.updateModificationStatus();
            if (dataObject.getCookie(SaveCookie.class) == null) {
                dataObject.getCookieSet0().add((Node.Cookie)this);
            }
        }

        private void removeSaveCookie() {
            LOG.finer("Environment.removeSaveCookie(...)");
            SaveCookie sc = this.entry.getCookie(SaveCookie.class);
            if (sc != null && sc.equals(this)) {
                this.entry.getCookieSet().remove((Node.Cookie)this);
            }
            final Environment cookie = this;
            PropertiesRequestProcessor.getInstance().post(new Runnable(){

                @Override
                public void run() {
                    PropertiesDataObject dataObject = (PropertiesDataObject)Environment.this.getDataObject();
                    dataObject.updateModificationStatus();
                    dataObject.getCookieSet0().remove((Node.Cookie)cookie);
                }
            });
        }

        private void fileChanged(boolean expected, long time) {
            LOG.finer("Environment.fileChanged(...)");
            if (expected) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(time));
            }
        }

        final void fileRenamed() {
            this.firePropertyChange("expectedTime", null, this.getTime());
        }

        private void fileRemoved() {
            LOG.finer("Environment.fileRemoved() ... ");
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }

    private static final class Env
    extends Environment {
        static final long serialVersionUID = -9218186467757330339L;
        private PropertiesFileEntry entry;

        public Env(PropertiesFileEntry entry) {
            super(entry);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            if (this.entry != null) {
                ((Environment)this).entry = this.entry;
            }
        }
    }

    final class FsStatusListener
    implements FileStatusListener,
    Runnable {
        FsStatusListener() {
        }

        public void annotationChanged(FileStatusEvent ev) {
            if (ev.isNameChange() && ev.hasChanged(PropertiesEditorSupport.this.myEntry.getFile())) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        @Override
        public void run() {
            PropertiesEditorSupport.this.updateEditorDisplayNames();
        }
    }
}

