/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.doxygensupport;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;

public class Man2HTML {
    public static final int MAX_WIDTH = 65;
    private static final Pattern ESC_PATTERN = Pattern.compile("\u001b\\[[0-9;]*m");
    private BufferedReader br;
    private MODE mode = MODE.NORMAL;
    private String previousLine = "";

    public Man2HTML(BufferedReader br) {
        this.br = br;
    }

    private void startNormal(StringBuffer buf) {
        if (this.mode != MODE.NORMAL) {
            if (this.mode == MODE.BOLD) {
                buf.append("</B>");
            } else if (this.mode == MODE.ITALIC) {
                buf.append("</I>");
            }
            this.mode = MODE.NORMAL;
        }
    }

    private void startBold(StringBuffer buf) {
        buf.append("<B>");
        this.mode = MODE.BOLD;
    }

    private void startItalic(StringBuffer buf) {
        buf.append("<I>");
        this.mode = MODE.ITALIC;
    }

    private int countIndent(String line) {
        int indent;
        for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
        }
        return indent;
    }

    private int breakAtColumn(String line) {
        char ch;
        int breakAt;
        int column = 0;
        for (breakAt = 0; breakAt < line.length() && column <= 66; ++breakAt) {
            ch = line.charAt(breakAt);
            if (ch == '\b') {
                --column;
                continue;
            }
            if (ch == ' ') {
                ++column;
                continue;
            }
            ++column;
        }
        if (column >= 66) {
            while (--breakAt > 0 && (ch = line.charAt(breakAt)) != ' ') {
            }
            if (breakAt > 0) {
                return breakAt;
            }
        }
        return -1;
    }

    private String getLine() {
        String line = null;
        try {
            line = this.br.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (line != null) {
            line = this.stripTerminalEscapes(line);
        }
        return line;
    }

    private String stripTerminalEscapes(String line) {
        return ESC_PATTERN.matcher(line).replaceAll("");
    }

    private String getNextLine() {
        String line = null;
        while (line == null && (line = this.getLine()) != null) {
            int i;
            if (line != null && (line.indexOf("BSD ") >= 0 || line.startsWith("Standard C") || line.startsWith("SunOS") || line.startsWith("User Commands"))) {
                line = null;
            }
            if (this.previousLine != null && this.previousLine.length() == 0 && line != null && line.length() == 0) {
                line = null;
            }
            if (line != null && (line.startsWith("    |") || line.startsWith("     __"))) {
                line = line.substring(4);
            }
            if (line == null || (i = this.breakAtColumn(line)) <= 0) continue;
            line = line.substring(0, i) + "\n" + line.substring(0, this.countIndent(line)) + line.substring(i + 1);
            boolean bl = false;
        }
        this.previousLine = line;
        return line;
    }

    public String getHTML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<HTML>\n");
        buf.append("<BODY>\n");
        buf.append("<PRE>\n");
        buf.append("<FONT SIZE=\"3\">\n");
        char prevCh = '\u0000';
        char curCh = '\u0000';
        char nextCh = '\u0000';
        int curColumn = 0;
        String line = null;
        while ((line = this.getNextLine()) != null) {
            for (int i = 0; i < line.length(); ++i) {
                prevCh = curCh;
                curCh = nextCh;
                nextCh = line.charAt(i);
                if (nextCh == '\b') {
                    if (this.mode != MODE.NORMAL) continue;
                    if (curCh == '_') {
                        this.startItalic(buf);
                        continue;
                    }
                    this.startBold(buf);
                    continue;
                }
                if (curCh == '\u0000' || curCh == 8) continue;
                if (prevCh != '\u0000' && prevCh != '\b') {
                    this.startNormal(buf);
                }
                if (curCh == '<') {
                    buf.append("&lt;");
                } else if (curCh == '>') {
                    buf.append("&gt;");
                } else if (curCh == '\"') {
                    buf.append("&rdquo;");
                } else if (curCh == '\'') {
                    buf.append("&rsquo;");
                } else if (curCh == '`') {
                    buf.append("&lsquo;");
                } else if (curCh == '&') {
                    buf.append("&amp;");
                } else {
                    buf.append(curCh);
                }
                ++curColumn;
            }
            if (nextCh != '\u0000') {
                buf.append(nextCh);
            }
            this.startNormal(buf);
            prevCh = '\u0000';
            curCh = '\u0000';
            nextCh = '\u0000';
            curColumn = 0;
            buf.append("\n");
        }
        buf.append("</FONT>\n");
        buf.append("</PRE>\n");
        buf.append("</BODY>\n");
        buf.append("</HTML>\n");
        return buf.toString();
    }

    private static enum MODE {
        NORMAL,
        BOLD,
        ITALIC;

    }
}

