/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ComponentDecorator;
import org.netbeans.validation.api.ui.FixedHeightLabel;
import org.netbeans.validation.api.ui.ValidationGroupImpl;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValidationGroup {
    private final ValidationGroupImpl delegate;

    ValidationGroup(ValidationGroupImpl delegate) {
        this.delegate = delegate;
    }

    public void setComponentDecorator(ComponentDecorator decorator) {
        this.delegate.setComponentDecorator(decorator);
    }

    public Problem validateAll() {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return this.delegate.validateAll();
    }

    public final void modifyComponents(Runnable run) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.modifyComponents(run);
    }

    public static ValidationGroup create(ValidationUI ... ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        return new ValidationGroup(ValidationGroupImpl.create(ui));
    }

    public void add(ButtonModel[] buttons, Validator<ButtonModel[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(buttons, validator);
    }

    public final void add(AbstractButton[] buttons, Validator<ButtonModel[]> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(buttons, validator);
    }

    public final JLabel createProblemLabel() {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        final FixedHeightLabel result = new FixedHeightLabel();
        this.addUI(new ValidationUI(){

            public void clearProblem() {
                result.setText("   ");
                result.setIcon(null);
            }

            public void setProblem(Problem problem) {
                result.setText(problem.getMessage());
                result.setIcon(problem.severity().icon());
                result.setForeground(problem.severity().color());
            }
        });
        return result;
    }

    public void add(JComboBox box, ValidationStrategy strategy, Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(box, strategy, validator);
    }

    public void add(JTextComponent comp, ValidationStrategy strategy, Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(comp, strategy, validator);
    }

    public final void add(JComboBox box, ValidationStrategy strategy, Validator<String> ... builtIns) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(box, strategy, builtIns);
    }

    public final void add(JTextComponent comp, ValidationStrategy strategy, Validator<String> ... builtIns) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(comp, strategy, builtIns);
    }

    public final void add(JComboBox box, Validator<String> ... builtIns) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(box, builtIns);
    }

    public final void add(JComboBox box, Validator<ComboBoxModel> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(box, validator);
    }

    public final void add(JTextComponent comp, Validator<String> ... builtIns) {
        this.delegate.add(comp, builtIns);
    }

    public final void add(JTextComponent comp, Validator<Document> validator) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(comp, validator);
    }

    public void add(ValidationListener listener) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.add(listener);
    }

    public final void addValidationGroup(ValidationGroup group, boolean useUI) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        if (group == this || group.delegate == this.delegate) {
            throw new IllegalArgumentException("Adding group to itself");
        }
        this.delegate.addValidationGroup(group.delegate, useUI);
    }

    public final void removeValidationGroup(ValidationGroup group) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.removeValidationGroup(group.delegate);
    }

    public final void addUI(ValidationUI ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.addUI(ui);
    }

    public final void removeUI(ValidationUI ui) {
        assert (EventQueue.isDispatchThread()) : "Must be called on event thread";
        this.delegate.removeUI(ui);
        ui.clearProblem();
    }
}

