/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.refactoring.hints.infrastructure.HintAction;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceHint;
import org.netbeans.modules.cnd.refactoring.introduce.IntroduceKind;
import org.netbeans.modules.cnd.refactoring.support.CsmContext;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IntroduceAction
extends HintAction {
    private IntroduceKind type;
    private static String INTRODUCE_CONSTANT = "introduce-constant";
    private static String INTRODUCE_VARIABLE = "introduce-variable";
    private static String INTRODUCE_METHOD = "introduce-method";
    private static String INTRODUCE_FIELD = "introduce-field";

    private IntroduceAction(IntroduceKind type) {
        this.type = type;
        this.putValue("Name", IntroduceAction.getActionName(type));
        String displayText = IntroduceAction.getMenuItemText(type);
        this.putValue("ShortDescription", displayText);
        this.putValue("PopupMenuText", displayText);
        this.putValue("menuText", displayText);
    }

    @Override
    protected void perform(CsmContext context) {
        String error = this.doPerformAction(context);
        if (error != null) {
            String errorText = NbBundle.getMessage(IntroduceAction.class, (String)error);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)errorText, 0);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    private String doPerformAction(CsmContext context) {
        EnumMap<IntroduceKind, Fix> fixes = new EnumMap<IntroduceKind, Fix>(IntroduceKind.class);
        EnumMap<IntroduceKind, String> errorMessages = new EnumMap<IntroduceKind, String>(IntroduceKind.class);
        try {
            IntroduceHint.computeError(context, fixes, errorMessages, new AtomicBoolean());
            Fix fix = (Fix)fixes.get((Object)this.type);
            if (fix != null) {
                fix.implement();
                return null;
            }
            String errorMessage = (String)errorMessages.get((Object)this.type);
            if (errorMessage != null) {
                return errorMessage;
            }
            return "ERR_Invalid_Selection";
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static IntroduceAction createVariable() {
        return new IntroduceAction(IntroduceKind.CREATE_VARIABLE);
    }

    public static IntroduceAction createConstant() {
        return new IntroduceAction(IntroduceKind.CREATE_CONSTANT);
    }

    public static IntroduceAction createField() {
        return new IntroduceAction(IntroduceKind.CREATE_FIELD);
    }

    public static IntroduceAction createMethod() {
        return new IntroduceAction(IntroduceKind.CREATE_METHOD);
    }

    private static String getActionName(IntroduceKind type) {
        switch (type) {
            case CREATE_CONSTANT: {
                return INTRODUCE_CONSTANT;
            }
            case CREATE_VARIABLE: {
                return INTRODUCE_VARIABLE;
            }
            case CREATE_FIELD: {
                return INTRODUCE_FIELD;
            }
            case CREATE_METHOD: {
                return INTRODUCE_METHOD;
            }
        }
        return null;
    }

    private static String getMenuItemText(IntroduceKind type) {
        switch (type) {
            case CREATE_CONSTANT: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceConstantAction");
            }
            case CREATE_VARIABLE: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceVariableAction");
            }
            case CREATE_FIELD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceFieldAction");
            }
            case CREATE_METHOD: {
                return NbBundle.getMessage(IntroduceAction.class, (String)"CTL_IntroduceMethodAction");
            }
        }
        return null;
    }
}

