/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.openide.util.lookup.Lookups;

public final class EncapsulateFieldRefactoring
extends AbstractRefactoring {
    private String getterName;
    private CsmMethod defaultGetter;
    private String setterName;
    private CsmMethod defaultSetter;
    private Set<CsmVisibility> methodModifiers;
    private Set<CsmVisibility> fieldModifiers;
    private boolean alwaysUseAccessors;
    private boolean methodInline;
    private final CsmFile declFile;
    private final CsmFile defFile;
    private final CsmClass enclosingClass;

    public EncapsulateFieldRefactoring(CsmField field, CsmFile declFile, CsmFile defFile) {
        super(Lookups.fixed((Object[])new Object[]{field}));
        this.enclosingClass = field.getContainingClass();
        this.declFile = declFile;
        this.defFile = defFile;
    }

    public CsmField getSourceField() {
        return (CsmField)this.getRefactoringSource().lookup(CsmField.class);
    }

    public CsmClass getEnclosingClass() {
        return this.enclosingClass;
    }

    public CsmFile getClassDeclarationFile() {
        return this.declFile;
    }

    public CsmFile getClassDefinitionFile() {
        return this.defFile;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public Set<CsmVisibility> getMethodModifiers() {
        return this.methodModifiers;
    }

    public Set<CsmVisibility> getFieldModifiers() {
        return this.fieldModifiers;
    }

    public boolean isAlwaysUseAccessors() {
        return this.alwaysUseAccessors;
    }

    public boolean isMethodInline() {
        return this.methodInline;
    }

    public CsmMethod getDefaultGetter() {
        return this.defaultGetter;
    }

    public CsmMethod getDefaultSetter() {
        return this.defaultSetter;
    }

    public void setDefaultGetter(CsmMethod defaultGetter) {
        this.defaultGetter = defaultGetter;
    }

    public void setDefaultSetter(CsmMethod defaultSetter) {
        this.defaultSetter = defaultSetter;
    }

    public void setGetterName(String getterName) {
        this.getterName = getterName;
    }

    public void setSetterName(String setterName) {
        this.setterName = setterName;
    }

    public void setMethodModifiers(Set<CsmVisibility> methodModifiers) {
        this.methodModifiers = Collections.unmodifiableSet(new HashSet<CsmVisibility>(methodModifiers));
    }

    public void setFieldModifiers(Set<CsmVisibility> fieldModifiers) {
        this.fieldModifiers = Collections.unmodifiableSet(new HashSet<CsmVisibility>(fieldModifiers));
    }

    public void setAlwaysUseAccessors(boolean alwaysUseAccessors) {
        this.alwaysUseAccessors = alwaysUseAccessors;
    }

    public void setMethodInline(boolean methodInline) {
        this.methodInline = methodInline;
    }
}

