/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;

public final class TypeHierarchyResolverImpl
extends CsmTypeHierarchyResolver {
    private static Map<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>> cache = new HashMap<CsmUID<CsmProject>, Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>>();
    private static long lastVersion = -1L;

    public Collection<CsmReference> getSubTypes(CsmClass csmClass, boolean bl) {
        return this.getSubTypes2(csmClass, bl);
    }

    public Collection<CsmReference> getSubTypes1(CsmClass csmClass, boolean bl) {
        CsmFile csmFile = csmClass.getContainingFile();
        long l = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmProject csmProject = csmFile.getProject();
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map = this.getOrCreateFullMap(csmProject, l);
        HierarchyModelImpl hierarchyModelImpl = new HierarchyModelImpl(map, csmClass, !bl);
        CsmUID csmUID = UIDs.get((Object)csmClass);
        Set<CsmUID<CsmClass>> set = hierarchyModelImpl.getModel().get(csmUID);
        if (set != null) {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
            for (CsmUID<CsmClass> csmUID2 : set) {
                CsmClass csmClass2 = (CsmClass)csmUID2.getObject();
                if (csmClass2 == null) continue;
                arrayList.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmClass2));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private Collection<CsmReference> getSubTypes2(CsmClass csmClass, boolean bl) {
        CsmFile csmFile = csmClass.getContainingFile();
        long l = CsmFileInfoQuery.getDefault().getFileVersion(csmFile);
        CsmProject csmProject = csmFile.getProject();
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map = this.getOrCreateFullMap2(csmProject, l);
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
        for (CsmUID<CsmClass> csmUID : this.getSubTypes2(csmClass, map, bl)) {
            arrayList.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)((CsmOffsetable)csmUID.getObject())));
        }
        return arrayList;
    }

    private Set<CsmUID<CsmClass>> getSubTypes2(CsmClass csmClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map, boolean bl) {
        int n;
        if (bl) {
            return this.getSubTypes2(csmClass, map);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Set<CsmUID<CsmClass>> set = this.getSubTypes2(csmClass, map);
        hashSet.add(UIDs.get((Object)csmClass));
        do {
            n = set.size();
            HashSet<CsmUID<CsmClass>> hashSet2 = new HashSet<CsmUID<CsmClass>>();
            for (CsmUID<CsmClass> csmUID : set) {
                if (hashSet.contains(csmUID)) continue;
                CsmClass csmClass2 = (CsmClass)csmUID.getObject();
                for (CsmUID<CsmClass> csmUID2 : this.getSubTypes2(csmClass2, map)) {
                    if (hashSet.contains(csmUID2)) continue;
                    hashSet2.add(csmUID2);
                }
                hashSet.add(csmUID);
            }
            set.addAll(hashSet2);
        } while (set.size() != n);
        return set;
    }

    private Set<CsmUID<CsmClass>> getSubTypes2(CsmClass csmClass, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map) {
        CsmUID csmUID = UIDs.get((Object)csmClass);
        Set<CsmUID<CsmClass>> set = map.get(csmUID);
        if (set != null) {
            return set;
        }
        CsmFile csmFile = csmClass.getContainingFile();
        CsmProject csmProject = csmFile.getProject();
        set = new HashSet<CsmUID<CsmClass>>();
        for (CsmInheritance csmInheritance : csmProject.findInheritances(csmClass.getName())) {
            CsmScope csmScope;
            CsmUID csmUID2;
            CsmClassifier csmClassifier = csmInheritance.getClassifier();
            if (csmClassifier == null) continue;
            if (CsmKindUtilities.isInstantiation((CsmObject)csmClassifier) && CsmKindUtilities.isClassifier((CsmObject)(csmUID2 = ((CsmInstantiation)csmClassifier).getTemplateDeclaration()))) {
                csmClassifier = (CsmClassifier)csmUID2;
            }
            if (!csmUID.equals(csmUID2 = UIDs.get((Object)csmClassifier)) || !CsmKindUtilities.isClass((CsmObject)(csmScope = csmInheritance.getScope()))) continue;
            set.add((CsmUID<CsmClass>)UIDs.get((Object)((CsmClass)csmScope)));
        }
        map.put((CsmUID<CsmClass>)csmUID, set);
        return set;
    }

    private synchronized Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> getOrCreateFullMap2(CsmProject csmProject, long l) {
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map;
        if (lastVersion != l) {
            cache.clear();
        }
        lastVersion = l;
        CsmUID csmUID = UIDs.get((Object)csmProject);
        Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>> reference = cache.get(csmUID);
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map2 = map = reference == null ? null : reference.get();
        if (map == null) {
            map = new HashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
            cache.put((CsmUID<CsmProject>)csmUID, new SoftReference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>(map));
        }
        return map;
    }

    private synchronized Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> getOrCreateFullMap(CsmProject csmProject, long l) {
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map;
        if (lastVersion != l) {
            cache.clear();
        }
        lastVersion = l;
        CsmUID csmUID = UIDs.get((Object)csmProject);
        Reference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>> reference = cache.get(csmUID);
        Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map2 = map = reference == null ? null : reference.get();
        if (map == null) {
            map = new HashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
            TypeHierarchyResolverImpl.buildSubHierarchy(csmProject.getGlobalNamespace(), map);
            cache.put((CsmUID<CsmProject>)csmUID, new SoftReference<Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>>(map));
        }
        return map;
    }

    private static CsmSelect.CsmFilter getClassFilter() {
        return CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT});
    }

    private static CsmClass getClassDeclaration(CsmInheritance csmInheritance) {
        CsmOffsetableDeclaration csmOffsetableDeclaration;
        CsmClass csmClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
        if (CsmKindUtilities.isInstantiation((CsmObject)csmClass) && CsmKindUtilities.isClass((CsmObject)(csmOffsetableDeclaration = ((CsmInstantiation)csmClass).getTemplateDeclaration()))) {
            csmClass = (CsmClass)csmOffsetableDeclaration;
        }
        return csmClass;
    }

    private static void buildSubHierarchy(CsmNamespace csmNamespace, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map) {
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            TypeHierarchyResolverImpl.buildSubHierarchy(csmNamespace2, map);
        }
        Iterator iterator = CsmSelect.getDeclarations((CsmNamespace)csmNamespace, (CsmSelect.CsmFilter)TypeHierarchyResolverImpl.getClassFilter());
        while (iterator.hasNext()) {
            CsmNamespace csmNamespace2;
            csmNamespace2 = (CsmClass)iterator.next();
            TypeHierarchyResolverImpl.buildSubHierarchy(map, (CsmClass)csmNamespace2);
        }
    }

    private static void buildSubHierarchy(Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map, CsmClass csmClass) {
        Collection collection = csmClass.getBaseClasses();
        CsmUID csmUID = UIDs.get((Object)csmClass);
        if (collection != null && collection.size() > 0) {
            for (CsmClass csmClass2 : collection) {
                CsmClass csmClass3 = TypeHierarchyResolverImpl.getClassDeclaration((CsmInheritance)csmClass2);
                if (csmClass3 == null) continue;
                CsmUID csmUID2 = UIDs.get((Object)csmClass3);
                Set<CsmUID<CsmClass>> set = map.get(csmUID2);
                if (set == null) {
                    set = new HashSet<CsmUID<CsmClass>>();
                    map.put((CsmUID<CsmClass>)csmUID2, set);
                }
                set.add((CsmUID<CsmClass>)csmUID);
            }
        }
        Iterator iterator = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)TypeHierarchyResolverImpl.getClassFilter());
        while (iterator.hasNext()) {
            CsmClass csmClass2;
            csmClass2 = (CsmClass)iterator.next();
            TypeHierarchyResolverImpl.buildSubHierarchy(map, csmClass2);
        }
    }

    private static final class HierarchyModelImpl {
        private Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> myMap;

        public HierarchyModelImpl(Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map, CsmClass csmClass, boolean bl) {
            Set<Object> set;
            CsmUID csmUID = UIDs.get((Object)csmClass);
            this.myMap = Collections.unmodifiableMap(map);
            if (!bl) {
                set = this.myMap.get(csmUID);
                if (set == null) {
                    set = new HashSet();
                }
                this.myMap = new HashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
                this.myMap.put((CsmUID<CsmClass>)csmUID, set);
            }
            set = new HashSet();
            HierarchyModelImpl.gatherList((CsmUID<CsmClass>)csmUID, set, this.myMap);
            this.myMap = new HashMap<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>>();
            this.myMap.put((CsmUID<CsmClass>)csmUID, set);
        }

        public Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> getModel() {
            return this.myMap;
        }

        private static void gatherList(CsmUID<CsmClass> csmUID, Set<CsmUID<CsmClass>> set, Map<CsmUID<CsmClass>, Set<CsmUID<CsmClass>>> map) {
            Set<CsmUID<CsmClass>> set2 = map.get(csmUID);
            if (set2 == null) {
                return;
            }
            for (CsmUID<CsmClass> csmUID2 : set2) {
                if (set.contains(csmUID2)) continue;
                set.add(csmUID2);
                HierarchyModelImpl.gatherList(csmUID2, set, map);
            }
        }
    }
}

