/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import java.awt.Image;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSUtils;
import org.netbeans.modules.maven.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.maven.jaxws.actions.WSEditAttributesAction;
import org.netbeans.modules.maven.jaxws.nodes.ClientHandlerButtonListener;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.maven.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.maven.jaxws.nodes.WsImportFailedMessage;
import org.netbeans.modules.maven.jaxws.wizards.JaxWsClientCreator;
import org.netbeans.modules.maven.jaxws.wseditor.EditWSAttributesCookieImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandler;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChain;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerChains;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsHandlerClass;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModelFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.GlobalBindings;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.RefreshClientDialog;
import org.netbeans.modules.websvc.api.support.RefreshCookie;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsClientNode
extends AbstractNode
implements OpenCookie,
RefreshCookie,
ConfigureHandlerCookie {
    JaxWsService client;
    JAXWSLightSupport jaxWsSupport;
    InstanceContent content;
    private FileObject wsdlFileObject;
    boolean modelGenerationFinished;
    WsdlModel wsdlModel;
    private static final String WAITING_BADGE = "org/netbeans/modules/maven/jaxws/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/maven/jaxws/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/maven/jaxws/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsClientNode(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService) {
        this(jAXWSLightSupport, jaxWsService, new InstanceContent());
    }

    private JaxWsClientNode(JAXWSLightSupport jAXWSLightSupport, JaxWsService jaxWsService, InstanceContent instanceContent) {
        super((Children)new JaxWsClientChildren(jAXWSLightSupport, jaxWsService), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.jaxWsSupport = jAXWSLightSupport;
        this.client = jaxWsService;
        this.content = instanceContent;
        instanceContent.add((Object)this);
        instanceContent.add((Object)jaxWsService);
        instanceContent.add((Object)jAXWSLightSupport);
        final WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null) {
            this.changeIcon();
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel wsdlModel) {
                    JaxWsClientNode.this.modelGenerationFinished = true;
                    JaxWsClientNode.this.changeIcon();
                    if (wsdlModeler.getCreationException() == null && wsdlModel != null) {
                        JaxWsClientNode.this.wsdlModel = wsdlModel;
                    }
                }
            });
        }
        instanceContent.add((Object)new EditWSAttributesCookieImpl((Node)this));
    }

    public WsdlModel getWsdlModel() {
        return this.getWsdlModeler().getAndWaitForWsdlModel();
    }

    public String getName() {
        return this.client.getId();
    }

    public String getDisplayName() {
        return this.client.getId();
    }

    public String getShortDescription() {
        return this.client.getLocalWsdl();
    }

    public Image getIcon(int n) {
        if (this.wsdlModel != null) {
            return this.getServiceImage();
        }
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null && wsdlModeler.getCreationException() == null) {
            if (this.modelGenerationFinished) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image image = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (this.modelGenerationFinished) {
            return image;
        }
        return ImageUtilities.mergeImages((Image)image, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public void open() {
        EditCookie editCookie = this.getEditCookie();
        if (editCookie != null) {
            editCookie.edit();
        }
    }

    void changeIcon() {
        this.fireIconChange();
    }

    private EditCookie getEditCookie() {
        try {
            FileObject fileObject = this.jaxWsSupport.getWsdlFolder(false).getFileObject(this.client.getLocalWsdl());
            assert (fileObject != null) : "Cannot find local WSDL file";
            if (fileObject != null) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return (EditCookie)dataObject.getCookie(EditCookie.class);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            return null;
        }
        return null;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        ArrayList<CallableSystemAction> arrayList = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshAction.class), (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(arrayList, "WebServices/Clients/Actions");
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addFromLayers(ArrayList<Action> arrayList, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                arrayList.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            arrayList.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        FileObject fileObject = this.jaxWsSupport.getWsdlFolder(false);
        if (fileObject != null) {
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null) {
                final String string = this.client.getId();
                ModelOperation<POMModel> modelOperation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel pOMModel) {
                        MavenModelUtils.removeWsimportExecution(pOMModel, string);
                    }
                };
                final FileObject fileObject2 = project.getProjectDirectory().getFileObject("pom.xml");
                RequestProcessor.getDefault().post(new Runnable((ModelOperation)modelOperation){
                    final /* synthetic */ ModelOperation val$oper;
                    {
                        this.val$oper = modelOperation;
                    }

                    @Override
                    public void run() {
                        Utilities.performPOMModelOperations((FileObject)fileObject2, Collections.singletonList(this.val$oper));
                    }
                });
                if (this.wsdlFileObject != null) {
                    boolean bl = false;
                    List list = this.jaxWsSupport.getServices();
                    for (JaxWsService jaxWsService : list) {
                        if (string == null || string.equals(jaxWsService.getId()) || !this.client.getLocalWsdl().equals(jaxWsService.getLocalWsdl())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.wsdlFileObject.delete();
                    }
                }
                try {
                    this.removeStaleFile(project, string);
                }
                catch (IOException iOException) {
                    Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", iOException);
                }
            }
            super.destroy();
        }
    }

    public void configureHandler() {
        BindingsHandlerChains bindingsHandlerChains;
        Object object;
        GlobalBindings globalBindings;
        Project project = FileOwnerQuery.getOwner((FileObject)this.wsdlFileObject);
        ArrayList<String> arrayList = new ArrayList<String>();
        BindingsModel bindingsModel = this.getBindingsModel();
        if (bindingsModel != null && (globalBindings = bindingsModel.getGlobalBindings()) != null && (object = globalBindings.getDefinitionsBindings()) != null) {
            bindingsHandlerChains = object.getHandlerChains();
            BindingsHandlerChain bindingsHandlerChain = (BindingsHandlerChain)bindingsHandlerChains.getHandlerChains().iterator().next();
            Collection collection = bindingsHandlerChain.getHandlers();
            for (BindingsHandler bindingsHandler : collection) {
                BindingsHandlerClass bindingsHandlerClass = bindingsHandler.getHandlerClass();
                arrayList.add(bindingsHandlerClass.getClassName());
            }
        }
        globalBindings = new MessageHandlerPanel(project, arrayList, true, this.client.getServiceName());
        object = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        bindingsHandlerChains = new DialogDescriptor((Object)globalBindings, (String)object);
        bindingsHandlerChains.setButtonListener((ActionListener)new ClientHandlerButtonListener((MessageHandlerPanel)globalBindings, bindingsModel, this.client, (Node)this));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)bindingsHandlerChains);
    }

    WsdlModeler getWsdlModeler() {
        if (this.getLocalWsdl() != null) {
            try {
                WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlFileObject.getURL());
                if (wsdlModeler != null) {
                    wsdlModeler.setCatalog(this.jaxWsSupport.getCatalog());
                    return wsdlModeler;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().log(fileStateInvalidException.getLocalizedMessage());
            }
        } else {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingLocalWsdl"));
        }
        return null;
    }

    FileObject getLocalWsdl() {
        String string;
        FileObject fileObject;
        if (this.wsdlFileObject == null && (fileObject = this.jaxWsSupport.getWsdlFolder(false)) != null && (string = this.client.getLocalWsdl()) != null) {
            this.wsdlFileObject = fileObject.getFileObject(string);
        }
        return this.wsdlFileObject;
    }

    void setModelGenerationFinished(boolean bl) {
        this.modelGenerationFinished = bl;
    }

    public void refreshService(boolean bl) {
        if (bl) {
            RefreshClientDialog.Result result;
            Preferences preferences;
            String string = this.client.getWsdlUrl();
            if (string == null && this.wsdlFileObject != null && (preferences = ProjectUtils.getPreferences((Project)(result = FileOwnerQuery.getOwner((FileObject)this.wsdlFileObject)), MavenWebService.class, (boolean)true)) != null && (string = preferences.get("_C_" + this.client.getId(), null)) != null) {
                this.client.setWsdlUrl(string);
            }
            if (RefreshClientDialog.Result.CLOSE.equals((Object)(result = RefreshClientDialog.open((boolean)true, (String)string)))) {
                return;
            }
            if (RefreshClientDialog.Result.REFRESH_ONLY.equals((Object)result)) {
                this.updateNode();
            } else {
                preferences = this.jaxWsSupport.getWsdlFolder(false);
                if (preferences != null) {
                    Object object;
                    String string2;
                    String string3 = result.getWsdlUrl();
                    boolean bl2 = false;
                    if (string3.length() > 0 && !string3.equals(string)) {
                        bl2 = true;
                    }
                    FileObject fileObject = null;
                    try {
                        fileObject = WSUtils.retrieveResource((FileObject)preferences, new URI("src/jax-ws-catalog.xml"), new URI(string3));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        string2 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_IncorrectURI", (Object)string);
                        object = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                    }
                    catch (UnknownHostException unknownHostException) {
                        string2 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_UnknownHost", (Object)unknownHostException.getMessage());
                        object = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                    }
                    catch (IOException iOException) {
                        string2 = NbBundle.getMessage(JaxWsClientCreator.class, (String)"ERR_WsdlRetrieverFailure", (Object)string);
                        object = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)object);
                    }
                    if (fileObject != null) {
                        String string4;
                        Object object22;
                        String string5 = FileUtil.getRelativePath((FileObject)preferences, (FileObject)fileObject);
                        string2 = FileOwnerQuery.getOwner((FileObject)fileObject);
                        object = this.client.getId();
                        ArrayList<JaxWsService> arrayList = new ArrayList<JaxWsService>();
                        for (Object object22 : this.jaxWsSupport.getServices()) {
                            string4 = object22.getId();
                            if (string4 == null || string4.equals(object)) continue;
                            arrayList.add((JaxWsService)object22);
                        }
                        String string6 = WSUtils.getUniqueId(fileObject.getName(), arrayList);
                        if (bl2) {
                            string = string3;
                            this.client.setWsdlUrl(string);
                            object22 = ProjectUtils.getPreferences((Project)string2, MavenWebService.class, (boolean)true);
                            if (object22 != null) {
                                ((Preferences)object22).remove("_C_" + (String)object);
                                ((Preferences)object22).put("_C_" + (String)string6, string3);
                            }
                        }
                        if (!string5.equals(this.client.getLocalWsdl())) {
                            this.wsdlFileObject = fileObject;
                            object22 = new ModelOperation<POMModel>((String)object, string6, string5){
                                final /* synthetic */ String val$oldId;
                                final /* synthetic */ String val$newId;
                                final /* synthetic */ String val$relativePath;
                                {
                                    this.val$oldId = string;
                                    this.val$newId = string2;
                                    this.val$relativePath = string3;
                                }

                                public void performOperation(POMModel pOMModel) {
                                    MavenModelUtils.renameWsdlFile(pOMModel, this.val$oldId, this.val$newId, JaxWsClientNode.this.client.getLocalWsdl(), this.val$relativePath);
                                }
                            };
                            string4 = string2.getProjectDirectory().getFileObject("pom.xml");
                            Utilities.performPOMModelOperations((FileObject)string4, Collections.singletonList(object22));
                            try {
                                this.removeStaleFile((Project)string2, (String)object);
                            }
                            catch (IOException iOException) {
                                Logger.getLogger(JaxWsClientNode.class.getName()).log(Level.FINE, "Cannot remove stale file", iOException);
                            }
                        }
                    }
                    this.updateNode();
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"MSG_RefreshClient")));
            this.updateNode();
        }
    }

    private void updateNode() {
        final WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null) {
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel wsdlModel) {
                    JaxWsClientNode.this.wsdlModel = wsdlModel;
                    JaxWsClientNode.this.setModelGenerationFinished(true);
                    JaxWsClientNode.this.changeIcon();
                    if (wsdlModel == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(false, wsdlModeler.getCreationException()));
                    }
                    ((JaxWsClientChildren)JaxWsClientNode.this.getChildren()).setWsdlModel(JaxWsClientNode.this.wsdlModel);
                    ((JaxWsClientChildren)JaxWsClientNode.this.getChildren()).updateKeys();
                }
            });
        }
    }

    private BindingsModel getBindingsModel() {
        String string = this.client.getHandlerBindingFile();
        BindingsModel bindingsModel = null;
        try {
            FileObject fileObject;
            FileObject fileObject2;
            if (string != null && (fileObject2 = this.jaxWsSupport.getBindingsFolder(false)) != null && (fileObject = fileObject2.getFileObject(string)) != null) {
                ModelSource modelSource = org.netbeans.modules.xml.retriever.catalog.Utilities.getModelSource((FileObject)fileObject, (boolean)true);
                bindingsModel = BindingsModelFactory.getDefault().getModel(modelSource);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
        return bindingsModel;
    }

    private void removeStaleFile(Project project, String string) throws IOException {
        FileObject fileObject = project.getProjectDirectory().getFileObject("target/jaxws/stale/" + string + ".stale");
        if (fileObject != null) {
            fileObject.delete();
        }
    }
}

