/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.EnumSet;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.modules.javascript.editing.BrowserVersion;
import org.netbeans.modules.javascript.editing.options.JsOptionsController;
import org.openide.util.NbPreferences;

public class SupportedBrowsers {
    private static final String SUPPORTED_KEY = "supported";
    private static final String LANGUAGE_KEY = "language";
    private static final String BROWSERS = "browsers";
    private Set<BrowserVersion> supported;
    private int languageVersion;
    static SupportedBrowsers instance;

    public static SupportedBrowsers getInstance() {
        return instance;
    }

    SupportedBrowsers() {
        Preferences preferences = this.getPreferences();
        String browsers = preferences.get(SUPPORTED_KEY, null);
        this.supported = browsers == null || browsers.length() == 0 ? EnumSet.allOf(BrowserVersion.class) : BrowserVersion.fromFlags(browsers);
        String languageStr = preferences.get(LANGUAGE_KEY, null);
        this.languageVersion = languageStr == null || "default".equals(languageStr) ? 0 : ("1.0".equals(languageStr) ? 100 : ("1.1".equals(languageStr) ? 110 : ("1.2".equals(languageStr) ? 120 : ("1.3".equals(languageStr) ? 130 : ("1.4".equals(languageStr) ? 140 : ("1.5".equals(languageStr) ? 150 : ("1.6".equals(languageStr) ? 160 : ("1.7".equals(languageStr) ? 170 : ("1.8".equals(languageStr) ? 180 : 0)))))))));
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(SupportedBrowsers.class).node(BROWSERS);
    }

    public boolean isSupported(BrowserVersion version) {
        return this.supported.contains((Object)version);
    }

    public boolean isSupported(EnumSet<BrowserVersion> versions) {
        return versions.containsAll(this.supported);
    }

    void setSupported(EnumSet<BrowserVersion> versions) {
        if (((Object)this.supported).equals(versions)) {
            return;
        }
        this.supported = versions;
        String flags = BrowserVersion.toFlags(versions);
        this.getPreferences().put(SUPPORTED_KEY, flags);
    }

    public int getLanguageVersion() {
        return this.languageVersion;
    }

    public static String getLanguageVersionString(int version) {
        String value;
        switch (version) {
            case 100: {
                value = "1.0";
                break;
            }
            case 110: {
                value = "1.1";
                break;
            }
            case 120: {
                value = "1.2";
                break;
            }
            case 130: {
                value = "1.3";
                break;
            }
            case 140: {
                value = "1.4";
                break;
            }
            case 150: {
                value = "1.5";
                break;
            }
            case 160: {
                value = "1.6";
                break;
            }
            case 170: {
                value = "1.7";
                break;
            }
            case 180: {
                value = "1.8";
                break;
            }
            case 0: {
                value = "default";
                break;
            }
            default: {
                assert (false) : version;
                value = "default";
            }
        }
        return value;
    }

    public void setLanguageVersion(int version) {
        this.languageVersion = version;
        String value = SupportedBrowsers.getLanguageVersionString(version);
        this.getPreferences().put(LANGUAGE_KEY, value);
    }

    static {
        JsOptionsController.Accessor.DEFAULT = new JsOptionsController.Accessor(){

            @Override
            public void setLanguageVersion(SupportedBrowsers supported, int version) {
                supported.setLanguageVersion(version);
            }

            @Override
            public void setSupported(SupportedBrowsers supported, EnumSet<BrowserVersion> versions) {
                supported.setSupported(versions);
            }
        };
        instance = new SupportedBrowsers();
    }
}

