/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makefile.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.makefile.wizard.CompilerFlags;
import org.netbeans.modules.cnd.makefile.wizard.MakefileData;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizard;
import org.netbeans.modules.cnd.makefile.wizard.MakefileWizardPanel;
import org.netbeans.modules.cnd.makefile.wizard.OptionSource;
import org.netbeans.modules.cnd.makefile.wizard.TargetData;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;
import org.openide.util.NbBundle;

public class MakefileReviewPanel
extends MakefileWizardPanel
implements FocusListener {
    static final long serialVersionUID = 6675031915575184904L;
    private JLabel reviewLabel;
    private JTextArea reviewText;
    private JScrollPane reviewSP;
    private String finishLabel;
    private int finishMnemonic;
    private StringBuffer summary;
    private boolean initialized;
    private boolean enableTextSelection = false;
    ActionListener finishButtonListener = null;

    MakefileReviewPanel(MakefileWizard wd) {
        super(wd);
        String subtitle = new String(this.getString("LBL_MakefileReviewPanel"));
        this.setSubTitle(subtitle);
        this.getAccessibleContext().setAccessibleDescription(subtitle + this.getString("ACSD_MakefileReview"));
        this.initialized = false;
    }

    private void create() {
        this.setLayout(new GridBagLayout());
        this.reviewLabel = new JLabel();
        this.reviewLabel.setText(NbBundle.getMessage(MakefileReviewPanel.class, (String)"LBL_Summary"));
        this.reviewLabel.setDisplayedMnemonic(NbBundle.getMessage(MakefileReviewPanel.class, (String)"MNEM_Summary").charAt(0));
        GridBagConstraints grid = new GridBagConstraints();
        grid.anchor = 18;
        grid.gridx = 0;
        grid.gridy = 1;
        grid.gridheight = 1;
        grid.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.reviewLabel, grid);
        this.reviewText = new JTextArea();
        this.reviewText.setEditable(false);
        this.reviewText.getCaret().setVisible(false);
        this.reviewText.getCaret().setSelectionVisible(false);
        this.reviewText.setBackground(this.getBackground());
        this.reviewText.addFocusListener(this);
        this.reviewLabel.setLabelFor(this.reviewText);
        this.reviewSP = new JScrollPane(this.reviewText);
        this.reviewSP.getViewport().setBackground(this.reviewText.getBackground());
        grid = new GridBagConstraints();
        grid.gridx = 0;
        grid.gridy = 2;
        grid.weightx = 100.0;
        grid.weighty = 100.0;
        grid.fill = 1;
        this.add((Component)this.reviewSP, grid);
        if (CndPathUtilitities.IfdefDiagnostics) {
            this.reviewText.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ev) {
                    int mods = ev.getModifiers();
                    if (ev.isControlDown() && ev.getKeyCode() == 80) {
                        MakefileReviewPanel.this.getMakefileData().dump();
                    }
                }
            });
        }
    }

    private String getSummaryString() {
        MakefileData md = this.getMakefileData();
        String base = md.getBaseDirectory(true);
        String makefile = md.getMakefileName();
        String dir = this.getMakefileDirectory(base, makefile);
        String name = this.getMakefileName(makefile);
        this.summary = new StringBuffer(1024);
        this.append("LBL_MakefileSummaryDir", dir);
        this.append("LBL_MakefileSummaryName", name);
        this.append("LBL_BuildInstructions");
        this.append("LBL_BuildInstruction1", name, dir);
        this.append("LBL_BuildInstruction2", name);
        this.append("LBL_MakefileSpecifics");
        if (md.getTargetList().size() == 1 || md.getMakefileType() < 4) {
            TargetData td = md.getTargetList().get(0);
            if (td.isExecutable()) {
                this.append("LBL_SingleExe", td.getName());
            } else if (td.isArchive()) {
                this.append("LBL_SingleArchive", td.getName());
            } else if (td.isSharedLib()) {
                this.append("LBL_SingleSharedLib", td.getName());
            } else if (td.isMakeTarget()) {
                this.append("LBL_SingleMake", td.getName());
            } else if (td.isCustomTarget()) {
                this.append("LBL_SingleCustom", td.getName());
            } else if (CndPathUtilitities.IfdefDiagnostics) {
                System.out.println("Error: Unknown target type in summary");
            }
            if (td.getSourcesList() == null) {
                this.append("LBL_SingleTargetSrcs", 0);
            } else if (td.getSourcesList().length == 1) {
                this.append("LBL_SingleTargetSrcs1");
            } else {
                this.append("LBL_SingleTargetSrcs", td.getSourcesList().length);
            }
        } else {
            List<TargetData> tlist = md.getTargetList();
            this.append("LBL_MultiTarget");
            for (int i = 0; i < tlist.size(); ++i) {
                TargetData td = tlist.get(i);
                int srcCnt = td.getSourcesList() == null ? 0 : td.getSourcesList().length;
                if (td.isExecutable()) {
                    if (srcCnt == 1) {
                        this.append("LBL_MultiExe1", td.getName());
                        continue;
                    }
                    this.append("LBL_MultiExe", td.getName(), srcCnt);
                    continue;
                }
                if (td.isArchive()) {
                    if (srcCnt == 1) {
                        this.append("LBL_MultiArchive1", td.getName());
                        continue;
                    }
                    this.append("LBL_MultiArchive", td.getName(), srcCnt);
                    continue;
                }
                if (td.isSharedLib()) {
                    if (srcCnt == 1) {
                        this.append("LBL_MultiSharedLib1", td.getName());
                        continue;
                    }
                    this.append("LBL_MultiSharedLib", td.getName(), srcCnt);
                    continue;
                }
                if (td.isMakeTarget()) {
                    this.append("LBL_MultiMake", td.getName());
                    continue;
                }
                if (td.isCustomTarget()) {
                    if (srcCnt == 1) {
                        this.append("LBL_MultiCustom1", td.getName());
                        continue;
                    }
                    this.append("LBL_MultiCustom", td.getName(), srcCnt);
                    continue;
                }
                if (!CndPathUtilitities.IfdefDiagnostics) continue;
                System.out.println("Error: Unknown target type in summary");
            }
        }
        if (this.isDebug() && !this.isOptimize()) {
            this.append("LBL_DebugCompile");
        } else if (this.isDebug() && this.isOptimize()) {
            this.append("LBL_DebugOptCompile");
        } else if (this.isOptimize()) {
            this.append("LBL_OptimizeCompile");
        } else if (CndPathUtilitities.IfdefDiagnostics) {
            this.append("LBL_NoOptDebugCompile");
        }
        this.validateAllData();
        this.append("LBL_Finish");
        return this.summary.toString();
    }

    private String getMakefileDirectory(String base, String makefile) {
        String path;
        if (makefile.charAt(0) != File.separatorChar) {
            makefile = base + File.separator + makefile;
        }
        File file = new File(makefile);
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException ex) {
            return makefile.substring(0, makefile.lastIndexOf(File.separator) - 1);
        }
        return path.substring(0, path.lastIndexOf(File.separator));
    }

    private String getMakefileName(String makefile) {
        int pos = makefile.lastIndexOf(File.separator);
        if (pos >= 0) {
            return makefile.substring(pos + 1);
        }
        return makefile;
    }

    private boolean isDebug() {
        MakefileData md = this.getMakefileData();
        CompilerFlags copts = md.getCompilerFlags();
        if (md.getMakefileType() < 4) {
            return copts.isSimpleDebug();
        }
        return copts.getOptionSource() == OptionSource.DEVELOPMENT;
    }

    private boolean isOptimize() {
        MakefileData md = this.getMakefileData();
        CompilerFlags copts = md.getCompilerFlags();
        if (md.getMakefileType() < 4) {
            return copts.isSimpleOptimize();
        }
        if (copts.getOptionSource() == OptionSource.FINAL) {
            return copts.isFinalOptimize();
        }
        if (copts.getOptionSource() == OptionSource.DEVELOPMENT) {
            return !copts.isDevelDebug();
        }
        return false;
    }

    private void validateAllData() {
        ArrayList msgs = MakefileWizard.getMakefileWizard().validateAllData();
        this.append("LBL_Warnings");
        if (msgs.size() == 0) {
            this.append("LBL_NoWarnings");
        } else {
            for (int i = 0; i < msgs.size(); ++i) {
                this.append(msgs.get(i));
            }
        }
    }

    public void addNotify() {
        if (!this.initialized) {
            this.create();
            this.initialized = true;
        }
        super.addNotify();
        this.reviewText.setText(this.getSummaryString());
        this.reviewText.setCaretPosition(0);
        MakefileWizard mw = MakefileWizard.getMakefileWizard();
        mw.getNextButton().setEnabled(false);
        mw.setFinishEnabled(true);
        JButton finishButton = mw.getFinishButton();
        this.finishLabel = finishButton.getText();
        this.finishMnemonic = finishButton.getMnemonic();
        finishButton.setText(mw.getFinishLabel());
        finishButton.setMnemonic(mw.getFinishMnemonic());
        finishButton.setEnabled(true);
        this.getRootPane().setDefaultButton(finishButton);
        CndUIUtilities.requestFocus((Component)finishButton);
        this.enableTextSelection = false;
        if (this.finishButtonListener == null) {
            this.finishButtonListener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    MakefileReviewPanel.this.finishButtonListenerActionPerformed();
                }
            };
        }
        finishButton.addActionListener(this.finishButtonListener);
    }

    public void removeNotify() {
        super.removeNotify();
        JButton finishButton = MakefileWizard.getMakefileWizard().getFinishButton();
        finishButton.setText(this.finishLabel);
        finishButton.setMnemonic(this.finishMnemonic);
        this.getRootPane().setDefaultButton(MakefileWizard.getMakefileWizard().getNextButton());
        finishButton.removeActionListener(this.finishButtonListener);
    }

    public void finishButtonListenerActionPerformed() {
        MakefileWizard mw = MakefileWizard.getMakefileWizard();
        mw.setFinishClosingEnabled(true);
    }

    private void append(Object msg) {
        this.summary.append(msg.toString());
    }

    private void append(String msg) {
        this.summary.append(NbBundle.getBundle(MakefileReviewPanel.class).getString(msg));
    }

    private void append(String msg, Object arg1) {
        if (arg1 instanceof Integer && (Integer)arg1 == 1) {
            msg = msg + "1";
        }
        this.summary.append(NbBundle.getMessage(MakefileReviewPanel.class, (String)msg, (Object)arg1));
    }

    private void append(String msg, Object arg1, Object arg2) {
        if (arg2 instanceof Integer && (Integer)arg2 == 1) {
            msg = msg + "1";
        }
        this.summary.append(NbBundle.getMessage(MakefileReviewPanel.class, (String)msg, (Object)arg1, (Object)arg2));
    }

    public void focusGained(FocusEvent evt) {
    }

    public void focusLost(FocusEvent evt) {
    }
}

