/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.form.CopySupport;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormOthersNode;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.actions.AddAction;
import org.netbeans.modules.form.actions.ReloadAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;

class FormRootNode
extends FormNode {
    private Node.Property[] codeGenProperties;
    private Node.Property[] resourceProperties;
    private Node.Property[] allProperties;

    public FormRootNode(FormModel formModel) {
        super((Children)new RootChildren(formModel), formModel);
        this.setName("Form Root Node");
        this.setIconBaseWithExtension("org/netbeans/modules/form/resources/formDesigner.gif");
        this.updateName(formModel.getName());
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    @Override
    public Action[] getActions(boolean bl) {
        if (this.actions == null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.isModifiableContainer()) {
                arrayList.add(SystemAction.get(AddAction.class));
                arrayList.add(null);
                arrayList.add(SystemAction.get(PasteAction.class));
                arrayList.add(null);
                arrayList.add(SystemAction.get(ReorderAction.class));
                arrayList.add(null);
            }
            arrayList.add(SystemAction.get(ReloadAction.class));
            arrayList.add(null);
            for (Action action : super.getActions(bl)) {
                arrayList.add(action);
            }
            this.actions = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.actions;
    }

    void updateName(String string) {
        this.setDisplayName(FormUtils.getFormattedBundleString("FMT_FormNodeName", new Object[]{string}));
    }

    FormOthersNode getOthersNode() {
        return ((RootChildren)this.getChildren()).othersNode;
    }

    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet propertySet = new Node.PropertySet("codeGeneration", FormUtils.getBundleString("CTL_SyntheticTab"), FormUtils.getBundleString("CTL_SyntheticTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getCodeGenProperties();
            }
        };
        Node.PropertySet propertySet2 = new Node.PropertySet("resources", FormUtils.getBundleString("CTL_ResourceTab"), FormUtils.getBundleString("CTL_ResourceTabHint")){

            public Node.Property[] getProperties() {
                return FormRootNode.this.getResourceProperties();
            }
        };
        return new Node.PropertySet[]{propertySet, propertySet2};
    }

    Node.Property[] getCodeGenProperties() {
        if (this.codeGenProperties == null) {
            this.codeGenProperties = this.createCodeGenProperties();
        }
        return this.codeGenProperties;
    }

    private Node.Property[] createCodeGenProperties() {
        return FormEditor.getCodeGenerator(this.getFormModel()).getSyntheticProperties(null);
    }

    Node.Property[] getResourceProperties() {
        if (this.resourceProperties == null) {
            this.resourceProperties = this.createResourceProperties();
        }
        return this.resourceProperties;
    }

    private Node.Property[] createResourceProperties() {
        return FormEditor.getResourceSupport(this.getFormModel()).createFormProperties();
    }

    Node.Property[] getAllProperties() {
        if (this.allProperties == null) {
            int n = this.getCodeGenProperties().length;
            int n2 = this.getResourceProperties().length;
            this.allProperties = new Node.Property[n + n2];
            System.arraycopy(this.codeGenProperties, 0, this.allProperties, 0, n);
            System.arraycopy(this.resourceProperties, 0, this.allProperties, n, n2);
        }
        return this.allProperties;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        if (this.isModifiableContainer()) {
            CopySupport.createPasteTypes(transferable, list, this.getFormModel(), null);
        }
    }

    private boolean isModifiableContainer() {
        return !this.getFormModel().isReadOnly() && !FormRootNode.shouldHaveOthersNode(this.getFormModel());
    }

    private static boolean shouldHaveOthersNode(FormModel formModel) {
        return formModel.getTopRADComponent() instanceof RADVisualContainer;
    }

    static class RootChildren
    extends FormNode.FormNodeChildren {
        static final Object OTHERS_ROOT = new Object();
        private FormModel formModel;
        private FormOthersNode othersNode;

        protected RootChildren(FormModel formModel) {
            this.formModel = formModel;
            this.updateKeys();
        }

        @Override
        protected void updateKeys() {
            RADComponent rADComponent;
            this.othersNode = null;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            boolean bl = FormRootNode.shouldHaveOthersNode(this.formModel);
            if (bl) {
                linkedList.add(OTHERS_ROOT);
            }
            if ((rADComponent = this.formModel.getTopRADComponent()) != null) {
                linkedList.add(rADComponent);
            }
            if (!bl) {
                linkedList.addAll(this.formModel.getOtherComponents());
            }
            this.setKeys(linkedList.toArray());
        }

        protected Node[] createNodes(Object object) {
            FormNode formNode;
            if (object == OTHERS_ROOT) {
                this.othersNode = new FormOthersNode(this.formModel);
                formNode = this.othersNode;
            } else {
                formNode = new RADComponentNode((RADComponent)object);
            }
            formNode.getChildren().getNodes();
            return new Node[]{formNode};
        }

        protected final FormModel getFormModel() {
            return this.formModel;
        }
    }
}

