/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.common.api.SourceFileMap;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.api.restricted.RegistrationUtils;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class Utils {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.j2ee.Bundle");
    static final File[] EMPTY_FILE_LIST = new File[0];

    private Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempPasswordFile(String string, String string2) {
        PrintWriter printWriter = null;
        File file = null;
        try {
            file = File.createTempFile("admin", null);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("AS_ADMIN_ADMINPASSWORD=" + string);
            printWriter.println("AS_ADMIN_PASSWORD=" + string);
            printWriter.println("AS_ADMIN_MASTERPASSWORD=" + string2);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return file;
    }

    public static Object getResource(File file) {
        Resources resources = Utils.getResourceGraph(file);
        JdbcConnectionPool jdbcConnectionPool = null;
        JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
        if (jdbcConnectionPoolArray.length != 0) {
            jdbcConnectionPool = jdbcConnectionPoolArray[0];
        }
        JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
        if (null == jdbcConnectionPool && jdbcResourceArray.length != 0) {
            jdbcConnectionPool = jdbcResourceArray[0];
        }
        return jdbcConnectionPool;
    }

    public static String getResourceType(Resources resources) {
        String string = null;
        PersistenceManagerFactoryResource[] persistenceManagerFactoryResourceArray = resources.getPersistenceManagerFactoryResource();
        if (persistenceManagerFactoryResourceArray.length != 0) {
            string = "persistence-manager-factory-resource";
        }
        MailResource[] mailResourceArray = resources.getMailResource();
        if (null == string && mailResourceArray.length != 0) {
            string = "mail-resource";
        }
        ConnectorResource[] connectorResourceArray = resources.getConnectorResource();
        ConnectorConnectionPool[] connectorConnectionPoolArray = resources.getConnectorConnectionPool();
        AdminObjectResource[] adminObjectResourceArray = resources.getAdminObjectResource();
        if (null == string && (adminObjectResourceArray.length != 0 || connectorConnectionPoolArray.length != 0 && connectorResourceArray.length != 0)) {
            string = "jms-resource";
        }
        return string;
    }

    public static void setTopManagerStatus(String string) {
        StatusDisplayer.getDefault().setStatusText(string);
    }

    public static File[] getResourceDirs(J2eeModule j2eeModule) {
        File[] fileArray = EMPTY_FILE_LIST;
        SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((J2eeModule)j2eeModule);
        if (sourceFileMap != null) {
            fileArray = sourceFileMap.getEnterpriseResourceDirs();
        }
        return fileArray;
    }

    public static File[] getResourceDirs(File file) {
        File[] fileArray = EMPTY_FILE_LIST;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        SourceFileMap sourceFileMap = SourceFileMap.findSourceMap((FileObject)fileObject);
        if (sourceFileMap != null) {
            fileArray = sourceFileMap.getEnterpriseResourceDirs();
        }
        return fileArray;
    }

    public static void registerResources(File[] fileArray, ServerInterface serverInterface) {
        SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)serverInterface.getDeploymentManager();
        System.out.println(bundle.getString("Msg_ProjResRegisterStart"));
        try {
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                File[] fileArray2 = null;
                if (file != null) {
                    fileArray2 = file.listFiles(new SunResourceFileFilter());
                }
                if (fileArray2 == null) continue;
                Utils.registerSunResources(serverInterface, fileArray2);
            }
        }
        catch (Exception exception) {
            String string = MessageFormat.format(bundle.getString("Msg_RegFailure"), exception.getLocalizedMessage());
            System.out.println(string);
        }
        System.out.println(bundle.getString("Msg_ProjResRegisterFinish"));
    }

    private static void registerSunResources(ServerInterface serverInterface, File[] fileArray) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file == null || file.isDirectory()) continue;
            Utils.registerIndvResources(serverInterface, file);
        }
    }

    private static void prepareSunResources(ServerInterface serverInterface, File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file == null || file.isDirectory()) continue;
            RegistrationUtils.checkUpdateServerResources((ServerInterface)serverInterface, (File)file);
        }
    }

    public static void registerIndvResources(ServerInterface serverInterface, File file) throws Exception {
        String string;
        Resources resources = Utils.getResourceGraph(file);
        Object var3_3 = null;
        JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
        for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
            JdbcConnectionPool jdbcConnectionPool = jdbcConnectionPoolArray[i];
            ResourceUtils.register((JdbcConnectionPool)jdbcConnectionPool, (ServerInterface)serverInterface, (boolean)true);
        }
        JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
        for (int i = 0; i < jdbcResourceArray.length; ++i) {
            JdbcResource jdbcResource = jdbcResourceArray[i];
            try {
                ResourceUtils.register((JdbcResource)jdbcResource, (ServerInterface)serverInterface, (boolean)true);
                continue;
            }
            catch (Exception exception) {
                string = MessageFormat.format(bundle.getString("Msg_RegFailure"), exception.getLocalizedMessage());
                System.out.println(string);
            }
        }
        MailResource[] mailResourceArray = resources.getMailResource();
        for (int i = 0; i < mailResourceArray.length; ++i) {
            MailResource mailResource = mailResourceArray[i];
            ResourceUtils.register((MailResource)mailResource, (ServerInterface)serverInterface, (boolean)true);
        }
        AdminObjectResource[] adminObjectResourceArray = resources.getAdminObjectResource();
        for (int i = 0; i < adminObjectResourceArray.length; ++i) {
            string = adminObjectResourceArray[i];
            ResourceUtils.register((AdminObjectResource)string, (ServerInterface)serverInterface, (boolean)true);
        }
        ConnectorConnectionPool[] connectorConnectionPoolArray = resources.getConnectorConnectionPool();
        for (int i = 0; i < connectorConnectionPoolArray.length; ++i) {
            ConnectorConnectionPool connectorConnectionPool = connectorConnectionPoolArray[i];
            ResourceUtils.register((ConnectorConnectionPool)connectorConnectionPool, (ServerInterface)serverInterface, (boolean)true);
        }
        ConnectorResource[] connectorResourceArray = resources.getConnectorResource();
        for (int i = 0; i < connectorResourceArray.length; ++i) {
            ConnectorResource connectorResource = connectorResourceArray[i];
            ResourceUtils.register((ConnectorResource)connectorResource, (ServerInterface)serverInterface, (boolean)true);
        }
    }

    private static void registerConnectionPools(ServerInterface serverInterface, File[] fileArray) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            File file = fileArray[i];
            if (file == null || file.isDirectory() || (object = Utils.getResource(file)) == null || !(object instanceof JdbcConnectionPool)) continue;
            JdbcConnectionPool jdbcConnectionPool = (JdbcConnectionPool)object;
            ResourceUtils.register((JdbcConnectionPool)jdbcConnectionPool, (ServerInterface)serverInterface, (boolean)true);
        }
    }

    private static void registerDatasources(ServerInterface serverInterface, File[] fileArray) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            Object object;
            File file = fileArray[i];
            if (file == null || file.isDirectory() || (object = Utils.getResource(file)) == null || !(object instanceof JdbcResource)) continue;
            JdbcResource jdbcResource = (JdbcResource)object;
            ResourceUtils.register((JdbcResource)jdbcResource, (ServerInterface)serverInterface, (boolean)true);
        }
    }

    private static void registerOtherResources(File[] fileArray, SunDeploymentManagerInterface sunDeploymentManagerInterface) throws Exception {
        for (int i = 0; i < fileArray.length; ++i) {
            Resources resources;
            String string;
            File file = fileArray[i];
            if (file == null || file.isDirectory() || (string = Utils.getResourceType(resources = Utils.getResourceGraph(file))) == null) continue;
            ResourceUtils.register((Resources)resources, (SunDeploymentManagerInterface)sunDeploymentManagerInterface, (boolean)true, (String)string);
        }
    }

    static Resources getResourceGraph(File file) {
        Resources resources = null;
        try {
            if (file.exists() && !file.isDirectory()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                resources = DDProvider.getDefault().getResourcesGraph((InputStream)fileInputStream);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canWrite(File file) {
        if (Utilities.isWindows()) {
            boolean bl = true;
            File file2 = null;
            if (!file.exists()) {
                bl = false;
            } else if (file.isDirectory()) {
                try {
                    file2 = File.createTempFile("foo", ".tmp", file);
                }
                catch (IOException iOException) {
                    bl = false;
                }
                finally {
                    if (null != file2) {
                        file2.delete();
                    }
                }
            } else {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file, true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    bl = false;
                }
                finally {
                    if (null != fileOutputStream) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(Utils.class.getName()).log(Level.FINEST, null, iOException);
                        }
                    }
                }
            }
            return bl;
        }
        return file.canWrite();
    }

    public static class SunResourceFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().equals("sun-resources.xml");
        }
    }
}

