/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.runner;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class TextFeedbackTest
extends TestCase {
    OutputStream output;
    TestRunner runner;

    public static void main(String[] args) {
        TestRunner.run(TextFeedbackTest.class);
    }

    public void setUp() {
        this.output = new ByteArrayOutputStream();
        this.runner = new TestRunner(new TestResultPrinter(new PrintStream(this.output)));
    }

    public void testEmptySuite() {
        String expected = this.expected(new String[]{"", "Time: 0", "", "OK (0 tests)", ""});
        this.runner.doRun(new TestSuite());
        TextFeedbackTest.assertEquals(expected, this.output.toString());
    }

    public void testOneTest() {
        String expected = this.expected(new String[]{".", "Time: 0", "", "OK (1 test)", ""});
        TestSuite suite = new TestSuite();
        suite.addTest(new TestCase(){

            public void runTest() {
            }
        });
        this.runner.doRun(suite);
        TextFeedbackTest.assertEquals(expected, this.output.toString());
    }

    public void testTwoTests() {
        String expected = this.expected(new String[]{"..", "Time: 0", "", "OK (2 tests)", ""});
        TestSuite suite = new TestSuite();
        suite.addTest(new TestCase(){

            public void runTest() {
            }
        });
        suite.addTest(new TestCase(){

            public void runTest() {
            }
        });
        this.runner.doRun(suite);
        TextFeedbackTest.assertEquals(expected, this.output.toString());
    }

    public void testFailure() {
        String expected = this.expected(new String[]{".F", "Time: 0", "Failures here", "", "FAILURES!!!", "Tests run: 1,  Failures: 1,  Errors: 0", ""});
        TestResultPrinter printer = new TestResultPrinter(new PrintStream(this.output)){

            public void printFailures(TestResult result) {
                this.getWriter().println("Failures here");
            }
        };
        this.runner.setPrinter(printer);
        TestSuite suite = new TestSuite();
        suite.addTest(new TestCase(){

            public void runTest() {
                throw new AssertionFailedError();
            }
        });
        this.runner.doRun(suite);
        TextFeedbackTest.assertEquals(expected, this.output.toString());
    }

    public void testError() {
        String expected = this.expected(new String[]{".E", "Time: 0", "Errors here", "", "FAILURES!!!", "Tests run: 1,  Failures: 0,  Errors: 1", ""});
        TestResultPrinter printer = new TestResultPrinter(new PrintStream(this.output)){

            public void printErrors(TestResult result) {
                this.getWriter().println("Errors here");
            }
        };
        this.runner.setPrinter(printer);
        TestSuite suite = new TestSuite();
        suite.addTest(new TestCase(){

            public void runTest() throws Exception {
                throw new Exception();
            }
        });
        this.runner.doRun(suite);
        TextFeedbackTest.assertEquals(expected, this.output.toString());
    }

    private String expected(String[] lines) {
        ByteArrayOutputStream expected = new ByteArrayOutputStream();
        PrintStream expectedWriter = new PrintStream(expected);
        for (int i = 0; i < lines.length; ++i) {
            expectedWriter.println(lines[i]);
        }
        return ((Object)expected).toString();
    }

    static class TestResultPrinter
    extends ResultPrinter {
        TestResultPrinter(PrintStream writer) {
            super(writer);
        }

        protected String elapsedTimeAsString(long runTime) {
            return "0";
        }
    }
}

