/*
 * Decompiled with CFR 0.152.
 */
package junit.tests.framework;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.tests.WasRun;
import junit.tests.framework.NoArgTestCaseTest;

public class TestCaseTest
extends TestCase {
    public void testCaseToString() {
        TestCaseTest.assertEquals("testCaseToString(junit.tests.framework.TestCaseTest)", this.toString());
    }

    public void testError() {
        TestCase error = new TestCase("error"){

            protected void runTest() {
                throw new Error();
            }
        };
        this.verifyError(error);
    }

    public void testRunAndTearDownFails() {
        TornDown fails = new TornDown(){

            protected void tearDown() {
                super.tearDown();
                throw new Error();
            }

            protected void runTest() {
                throw new Error();
            }
        };
        this.verifyError(fails);
        TestCaseTest.assertTrue(fails.fTornDown);
    }

    public void testSetupFails() {
        TestCase fails = new TestCase("success"){

            protected void setUp() {
                throw new Error();
            }

            protected void runTest() {
            }
        };
        this.verifyError(fails);
    }

    public void testSuccess() {
        TestCase success = new TestCase("success"){

            protected void runTest() {
            }
        };
        this.verifySuccess(success);
    }

    public void testFailure() {
        TestCase failure = new TestCase("failure"){

            protected void runTest() {
                5.fail();
            }
        };
        this.verifyFailure(failure);
    }

    public void testTearDownAfterError() {
        TornDown fails = new TornDown();
        this.verifyError(fails);
        TestCaseTest.assertTrue(fails.fTornDown);
    }

    public void testTearDownFails() {
        TestCase fails = new TestCase("success"){

            protected void tearDown() {
                throw new Error();
            }

            protected void runTest() {
            }
        };
        this.verifyError(fails);
    }

    public void testTearDownSetupFails() {
        TornDown fails = new TornDown(){

            protected void setUp() {
                throw new Error();
            }
        };
        this.verifyError(fails);
        TestCaseTest.assertTrue(!fails.fTornDown);
    }

    public void testWasRun() {
        WasRun test = new WasRun();
        test.run();
        TestCaseTest.assertTrue(test.fWasRun);
    }

    public void testExceptionRunningAndTearDown() {
        TornDown t = new TornDown(){

            public void tearDown() {
                throw new Error("tearingDown");
            }
        };
        TestResult result = new TestResult();
        t.run(result);
        TestFailure failure = (TestFailure)result.errors().nextElement();
        TestCaseTest.assertEquals("running", failure.thrownException().getMessage());
    }

    public void testErrorTearingDownDoesntMaskErrorRunning() {
        final Exception running = new Exception("Running");
        TestCase t = new TestCase(){

            protected void runTest() throws Throwable {
                throw running;
            }

            protected void tearDown() throws Exception {
                throw new Error("Tearing down");
            }
        };
        try {
            t.runBare();
        }
        catch (Throwable thrown) {
            TestCaseTest.assertSame(running, thrown);
        }
    }

    public void testNoArgTestCasePasses() {
        TestSuite t = new TestSuite(NoArgTestCaseTest.class);
        TestResult result = new TestResult();
        t.run(result);
        TestCaseTest.assertTrue(result.runCount() == 1);
        TestCaseTest.assertTrue(result.failureCount() == 0);
        TestCaseTest.assertTrue(result.errorCount() == 0);
    }

    public void testNamelessTestCase() {
        TestCase t = new TestCase(){};
        try {
            t.run();
            TestCaseTest.fail();
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    void verifyError(TestCase test) {
        TestResult result = test.run();
        TestCaseTest.assertTrue(result.runCount() == 1);
        TestCaseTest.assertTrue(result.failureCount() == 0);
        TestCaseTest.assertTrue(result.errorCount() == 1);
    }

    void verifyFailure(TestCase test) {
        TestResult result = test.run();
        TestCaseTest.assertTrue(result.runCount() == 1);
        TestCaseTest.assertTrue(result.failureCount() == 1);
        TestCaseTest.assertTrue(result.errorCount() == 0);
    }

    void verifySuccess(TestCase test) {
        TestResult result = test.run();
        TestCaseTest.assertTrue(result.runCount() == 1);
        TestCaseTest.assertTrue(result.failureCount() == 0);
        TestCaseTest.assertTrue(result.errorCount() == 0);
    }

    static class TornDown
    extends TestCase {
        boolean fTornDown = false;

        TornDown() {
        }

        protected void tearDown() {
            this.fTornDown = true;
        }

        protected void runTest() {
            throw new Error("running");
        }
    }
}

