/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyClassPathVariable;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.java.MiniJava;
import org.jruby.java.addons.ArrayJavaAddons;
import org.jruby.java.addons.IOJavaAddons;
import org.jruby.java.addons.KernelJavaAddons;
import org.jruby.java.addons.StringJavaAddons;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaInterfaceTemplate;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaArrayUtilities;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaProxyMethods;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;
import org.jruby.runtime.load.Library;
import org.jruby.util.ClassProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"Java"})
public class Java
implements Library {
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;
    private static final CallableAcceptor Exact;
    private static final CallableAcceptor AssignableAndPrimitivable;
    private static final CallableAcceptor AssignableOrDuckable;

    @Override
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        Java.createJavaModule(runtime2);
        runtime2.getLoadService().smartLoad("builtin/javasupport");
        RubyClassPathVariable.createClassPathVariable(runtime2);
    }

    public static RubyModule createJavaModule(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        RubyModule javaModule = runtime2.defineModule("Java");
        javaModule.defineAnnotatedMethods(Java.class);
        JavaObject.createJavaObjectClass(runtime2, javaModule);
        JavaArray.createJavaArrayClass(runtime2, javaModule);
        JavaClass.createJavaClassClass(runtime2, javaModule);
        JavaMethod.createJavaMethodClass(runtime2, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime2, javaModule);
        JavaField.createJavaFieldClass(runtime2, javaModule);
        JavaProxyMethods.createJavaProxyMethods(context);
        JavaProxy.createJavaProxy(context);
        ConcreteJavaProxy.createConcreteJavaProxy(context);
        ArrayJavaProxy.createArrayJavaProxy(context);
        JavaProxyClass.createJavaProxyModule(runtime2);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(context);
        RubyModule javaUtils = runtime2.defineModule("JavaUtilities");
        javaUtils.defineAnnotatedMethods(JavaUtilities.class);
        runtime2.getJavaSupport().setConcreteProxyCallback(new Callback(){

            public IRubyObject execute(IRubyObject recv2, IRubyObject[] args2, Block block) {
                Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, 1);
                return Java.concrete_proxy_inherited(recv2, args2[0]);
            }

            public Arity getArity() {
                return Arity.ONE_ARGUMENT;
            }
        });
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime2);
        runtime2.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        runtime2.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        runtime2.getString().defineAnnotatedMethods(StringJavaAddons.class);
        runtime2.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        if (runtime2.getObject().isConstantDefined("StringIO")) {
            runtime2.getObject().defineAnnotatedMethods(IOJavaAddons.AnyIO.class);
        }
        Java.addNameClassMappings(runtime2, runtime2.getJavaSupport().getNameClassMap());
        runtime2.getJavaSupport().setObjectJavaClass(JavaClass.get(runtime2, Object.class));
        runtime2.getJavaSupport().setActive(true);
        return javaModule;
    }

    private static void addNameClassMappings(Ruby runtime2, Map<String, JavaClass> nameClassMap) {
        JavaClass booleanPrimClass = JavaClass.get(runtime2, Boolean.TYPE);
        JavaClass booleanClass = JavaClass.get(runtime2, Boolean.class);
        nameClassMap.put("boolean", booleanPrimClass);
        nameClassMap.put("Boolean", booleanClass);
        nameClassMap.put("java.lang.Boolean", booleanClass);
        JavaClass bytePrimClass = JavaClass.get(runtime2, Byte.TYPE);
        JavaClass byteClass = JavaClass.get(runtime2, Byte.class);
        nameClassMap.put("byte", bytePrimClass);
        nameClassMap.put("Byte", byteClass);
        nameClassMap.put("java.lang.Byte", byteClass);
        JavaClass shortPrimClass = JavaClass.get(runtime2, Short.TYPE);
        JavaClass shortClass = JavaClass.get(runtime2, Short.class);
        nameClassMap.put("short", shortPrimClass);
        nameClassMap.put("Short", shortClass);
        nameClassMap.put("java.lang.Short", shortClass);
        JavaClass charPrimClass = JavaClass.get(runtime2, Character.TYPE);
        JavaClass charClass = JavaClass.get(runtime2, Character.class);
        nameClassMap.put("char", charPrimClass);
        nameClassMap.put("Character", charClass);
        nameClassMap.put("Char", charClass);
        nameClassMap.put("java.lang.Character", charClass);
        JavaClass intPrimClass = JavaClass.get(runtime2, Integer.TYPE);
        JavaClass intClass = JavaClass.get(runtime2, Integer.class);
        nameClassMap.put("int", intPrimClass);
        nameClassMap.put("Integer", intClass);
        nameClassMap.put("Int", intClass);
        nameClassMap.put("java.lang.Integer", intClass);
        JavaClass longPrimClass = JavaClass.get(runtime2, Long.TYPE);
        JavaClass longClass = JavaClass.get(runtime2, Long.class);
        nameClassMap.put("long", longPrimClass);
        nameClassMap.put("Long", longClass);
        nameClassMap.put("java.lang.Long", longClass);
        JavaClass floatPrimClass = JavaClass.get(runtime2, Float.TYPE);
        JavaClass floatClass = JavaClass.get(runtime2, Float.class);
        nameClassMap.put("float", floatPrimClass);
        nameClassMap.put("Float", floatClass);
        nameClassMap.put("java.lang.Float", floatClass);
        JavaClass doublePrimClass = JavaClass.get(runtime2, Double.TYPE);
        JavaClass doubleClass = JavaClass.get(runtime2, Double.class);
        nameClassMap.put("double", doublePrimClass);
        nameClassMap.put("Double", doubleClass);
        nameClassMap.put("java.lang.Double", doubleClass);
        JavaClass bigintClass = JavaClass.get(runtime2, BigInteger.class);
        nameClassMap.put("big_int", bigintClass);
        nameClassMap.put("big_integer", bigintClass);
        nameClassMap.put("BigInteger", bigintClass);
        nameClassMap.put("java.math.BigInteger", bigintClass);
        JavaClass bigdecimalClass = JavaClass.get(runtime2, BigDecimal.class);
        nameClassMap.put("big_decimal", bigdecimalClass);
        nameClassMap.put("BigDecimal", bigdecimalClass);
        nameClassMap.put("java.math.BigDecimal", bigdecimalClass);
        JavaClass objectClass = JavaClass.get(runtime2, Object.class);
        nameClassMap.put("object", objectClass);
        nameClassMap.put("Object", objectClass);
        nameClassMap.put("java.lang.Object", objectClass);
        JavaClass stringClass = JavaClass.get(runtime2, String.class);
        nameClassMap.put("string", stringClass);
        nameClassMap.put("String", stringClass);
        nameClassMap.put("java.lang.String", stringClass);
    }

    public static IRubyObject is_primitive_type(IRubyObject recv2, IRubyObject sym) {
        return recv2.getRuntime().newBoolean(JAVA_PRIMITIVES.containsKey(sym.asJavaString()));
    }

    public static IRubyObject create_proxy_class(IRubyObject recv2, IRubyObject constant, IRubyObject javaClass, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw recv2.getRuntime().newTypeError(module, recv2.getRuntime().getModule());
        }
        return ((RubyModule)module).const_set(constant, Java.get_proxy_class(recv2, javaClass));
    }

    public static IRubyObject get_java_class(IRubyObject recv2, IRubyObject name2) {
        try {
            return JavaClass.for_name(recv2, name2);
        }
        catch (Exception e) {
            return recv2.getRuntime().getNil();
        }
    }

    public static IRubyObject new_instance_for(IRubyObject recv2, IRubyObject java_object) {
        if (java_object instanceof JavaObject) {
            return Java.getInstance(((JavaObject)java_object).getValue(), (RubyClass)recv2);
        }
        IRubyObject new_instance3 = ((RubyClass)recv2).allocate();
        new_instance3.getInstanceVariables().fastSetInstanceVariable("@java_object", java_object);
        new_instance3.dataWrapStruct(java_object);
        return new_instance3;
    }

    public static IRubyObject getInstance(Object rawJavaObject, RubyClass clazz) {
        return clazz.getRuntime().getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, clazz);
    }

    public static IRubyObject getInstance(Ruby runtime2, Object rawJavaObject) {
        if (rawJavaObject != null) {
            return runtime2.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, (RubyClass)Java.getProxyClass(runtime2, JavaClass.get(runtime2, rawJavaObject.getClass())));
        }
        return runtime2.getNil();
    }

    public static IRubyObject to_java_object(IRubyObject recv2) {
        return recv2.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Deprecated
    public static IRubyObject add_proxy_extender(IRubyObject recv2, IRubyObject extender) {
        recv2.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "JavaUtilities.add_proxy_extender is deprecated - use JavaUtilities.extend_proxy instead", "add_proxy_extender", "JavaUtilities.extend_proxy");
        IRubyObject javaClassVar = extender.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (!(javaClassVar instanceof JavaClass)) {
            throw recv2.getRuntime().newArgumentError("extender does not have a valid @java_class");
        }
        ((JavaClass)javaClassVar).addProxyExtender(extender);
        return recv2.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby runtime2, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw runtime2.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule interfaceModule = javaClass.getProxyModule();
        if (interfaceModule != null) {
            return interfaceModule;
        }
        javaClass.lockProxy();
        try {
            interfaceModule = javaClass.getProxyModule();
            if (interfaceModule == null) {
                interfaceModule = (RubyModule)runtime2.getJavaSupport().getJavaInterfaceTemplate().dup();
                interfaceModule.fastSetInstanceVariable("@java_class", javaClass);
                Java.addToJavaPackageModule(interfaceModule, javaClass);
                javaClass.setupInterfaceModule(interfaceModule);
                Class<?>[] extended2 = javaClass.javaClass().getInterfaces();
                int i = extended2.length;
                while (--i >= 0) {
                    JavaClass extendedClass = JavaClass.get(runtime2, extended2[i]);
                    RubyModule extModule = Java.getInterfaceModule(runtime2, extendedClass);
                    interfaceModule.includeModule(extModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return interfaceModule;
    }

    public static IRubyObject get_interface_module(IRubyObject recv2, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime2 = recv2.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv2, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime2.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        return Java.getInterfaceModule(runtime2, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_deprecated_interface_proxy(ThreadContext context, IRubyObject recv2, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime2 = context.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv2, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime2.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        if (!javaClass.javaClass().isInterface()) {
            throw runtime2.newArgumentError("expected Java interface class, got " + javaClassObject);
        }
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                RubyModule interfaceModule = Java.getInterfaceModule(runtime2, javaClass);
                RubyClass interfaceJavaProxy = runtime2.fastGetClass("InterfaceJavaProxy");
                proxyClass = RubyClass.newClass(runtime2, interfaceJavaProxy);
                proxyClass.setAllocator(interfaceJavaProxy.getAllocator());
                proxyClass.makeMetaClass(interfaceJavaProxy.getMetaClass());
                proxyClass.inherit(interfaceJavaProxy);
                proxyClass.callMethod(context, "java_class=", javaClass);
                proxyClass.includeModule(interfaceModule);
                javaClass.setupProxy(proxyClass);
                if (proxyClass.fastGetConstantAt("Includable") == null) {
                    proxyClass.fastSetConstant("Includable", interfaceModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getProxyClass(Ruby runtime2, JavaClass javaClass) {
        final Class c = javaClass.javaClass();
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        if (c.isInterface()) {
            return Java.getInterfaceModule(runtime2, javaClass);
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                if (c.isArray()) {
                    proxyClass = Java.createProxyClass(runtime2, runtime2.getJavaSupport().getArrayProxyClass(), javaClass, true);
                } else if (c.isPrimitive()) {
                    proxyClass = Java.createProxyClass(runtime2, runtime2.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (c == Object.class) {
                    proxyClass = Java.createProxyClass(runtime2, runtime2.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    proxyClass.getMetaClass().defineFastMethod("inherited", runtime2.getJavaSupport().getConcreteProxyCallback());
                    Java.addToJavaPackageModule(proxyClass, javaClass);
                } else {
                    proxyClass = Java.createProxyClass(runtime2, (RubyClass)Java.getProxyClass(runtime2, JavaClass.get(runtime2, c.getSuperclass())), javaClass, false);
                    Class<?>[] interfaces2 = c.getInterfaces();
                    int i = interfaces2.length;
                    while (--i >= 0) {
                        JavaClass ifc = JavaClass.get(runtime2, interfaces2[i]);
                        proxyClass.includeModule(Java.getInterfaceModule(runtime2, ifc));
                    }
                    if (Modifier.isPublic(c.getModifiers())) {
                        Java.addToJavaPackageModule(proxyClass, javaClass);
                    }
                }
                if (Modifier.isFinal(c.getModifiers())) {
                    proxyClass.getMetaClass().addMethod("inherited", new org.jruby.internal.runtime.methods.JavaMethod(){

                        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                            throw context.getRuntime().newTypeError("can not extend final Java class: " + c.getCanonicalName());
                        }
                    });
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject recv2, IRubyObject java_class_object) {
        JavaClass javaClass;
        Ruby runtime2 = recv2.getRuntime();
        if (java_class_object instanceof RubyString) {
            javaClass = JavaClass.for_name(recv2, java_class_object);
        } else if (java_class_object instanceof JavaClass) {
            javaClass = (JavaClass)java_class_object;
        } else {
            throw runtime2.newTypeError(java_class_object, runtime2.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(runtime2, javaClass);
    }

    private static RubyClass createProxyClass(Ruby runtime2, RubyClass baseType, JavaClass javaClass, boolean invokeInherited) {
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        RubyClass.checkInheritable(baseType);
        RubyClass superClass = baseType;
        proxyClass = RubyClass.newClass(runtime2, superClass);
        proxyClass.makeMetaClass(superClass.getMetaClass());
        proxyClass.setAllocator(superClass.getAllocator());
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        proxyClass.callMethod(runtime2.getCurrentContext(), "java_class=", javaClass);
        javaClass.setupProxy(proxyClass);
        return proxyClass;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject recv2, IRubyObject subclass) {
        Ruby runtime2 = recv2.getRuntime();
        ThreadContext tc = runtime2.getCurrentContext();
        JavaSupport javaSupport = runtime2.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        RuntimeHelpers.invokeAs(tc, javaProxyClass, recv2, "inherited", subclass, Block.NULL_BLOCK);
        return Java.setupJavaSubclass(tc, subclass, recv2.callMethod(tc, "java_class"));
    }

    private static IRubyObject setupJavaSubclass(ThreadContext context, IRubyObject subclass, IRubyObject java_class2) {
        Ruby runtime2 = context.getRuntime();
        if (!(subclass instanceof RubyClass)) {
            throw runtime2.newTypeError(subclass, runtime2.getClassClass());
        }
        RubyClass rubySubclass = (RubyClass)subclass;
        rubySubclass.getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", runtime2.getNil());
        RubyClass subclassSingleton = rubySubclass.getSingletonClass();
        subclassSingleton.addReadWriteAttribute(context, "java_proxy_class");
        subclassSingleton.addMethod("java_interfaces", new JavaMethod.JavaMethodZero(subclassSingleton, Visibility.PUBLIC){

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2) {
                IRubyObject javaInterfaces = self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                if (javaInterfaces != null) {
                    return javaInterfaces.dup();
                }
                return context.getRuntime().getNil();
            }
        });
        rubySubclass.addMethod("__jcreate!", new JavaMethod.JavaMethodN(subclassSingleton, Visibility.PUBLIC){
            private final Map<Integer, ParameterTypes> methodCache = new HashMap<Integer, ParameterTypes>();

            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2) {
                IRubyObject proxyClass = self.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_proxy_class");
                if (proxyClass == null || proxyClass.isNil()) {
                    proxyClass = JavaProxyClass.get_with_class(self, self.getMetaClass());
                    self.getMetaClass().getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", proxyClass);
                }
                JavaProxyClass realProxyClass = (JavaProxyClass)proxyClass;
                RubyArray constructors2 = realProxyClass.constructors();
                ArrayList<JavaProxyConstructor> forArity = new ArrayList<JavaProxyConstructor>();
                for (int i = 0; i < constructors2.size(); ++i) {
                    JavaProxyConstructor constructor2 = (JavaProxyConstructor)constructors2.eltInternal(i);
                    if (constructor2.getParameterTypes().length != args2.length) continue;
                    forArity.add(constructor2);
                }
                if (forArity.size() == 0) {
                    throw context.getRuntime().newArgumentError("wrong # of arguments for constructor");
                }
                JavaProxyConstructor matching = (JavaProxyConstructor)Java.matchingCallableArityN(self, this.methodCache, forArity.toArray(new JavaProxyConstructor[forArity.size()]), args2, args2.length);
                Object[] newArgs = new Object[args2.length];
                Class<?>[] parameterTypes = matching.getParameterTypes();
                for (int i = 0; i < args2.length; ++i) {
                    newArgs[i] = JavaUtil.convertArgumentToType(context, args2[i], parameterTypes[i]);
                }
                JavaObject newObject = matching.newInstance(self, newArgs);
                return JavaUtilities.set_java_object(self, self, newObject);
            }
        });
        return runtime2.getNil();
    }

    private static void addToJavaPackageModule(RubyModule proxyClass, JavaClass javaClass) {
        String className;
        String packageString;
        Class clazz = javaClass.javaClass();
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        int endPackage = fullName.lastIndexOf(46);
        if (fullName.indexOf(36) != -1 || !Character.isUpperCase(fullName.charAt(endPackage + 1))) {
            return;
        }
        Ruby runtime2 = proxyClass.getRuntime();
        RubyModule packageModule = Java.getJavaPackageModule(runtime2, packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage));
        if (packageModule != null && packageModule.getConstantAt(className = fullName.substring(endPackage + 1)) == null) {
            packageModule.const_set(runtime2.newSymbol(className), proxyClass);
        }
    }

    private static RubyModule getJavaPackageModule(Ruby runtime2, String packageString) {
        String packageName;
        int length2 = packageString.length();
        if (length2 == 0) {
            packageName = "Default";
        } else {
            StringBuilder buf = new StringBuilder();
            int start2 = 0;
            int offset2 = 0;
            while (start2 < length2) {
                offset2 = packageString.indexOf(46, start2);
                if (offset2 == -1) {
                    offset2 = length2;
                }
                buf.append(Character.toUpperCase(packageString.charAt(start2))).append(packageString.substring(start2 + 1, offset2));
                start2 = offset2 + 1;
            }
            packageName = buf.toString();
        }
        RubyModule javaModule = runtime2.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule parent, String name2, String packageString) {
        Ruby runtime2 = parent.getRuntime();
        RubyModule packageModule = (RubyModule)runtime2.getJavaSupport().getPackageModuleTemplate().dup();
        packageModule.fastSetInstanceVariable("@package_name", runtime2.newString(packageString.length() > 0 ? packageString + '.' : packageString));
        packageModule.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        parent.const_set(runtime2.newSymbol(name2), packageModule);
        MetaClass metaClass = (MetaClass)packageModule.getMetaClass();
        metaClass.setAttached(packageModule);
        return packageModule;
    }

    public static RubyModule getPackageModule(Ruby runtime2, String name2) {
        String packageName;
        RubyModule javaModule = runtime2.getJavaSupport().getJavaModule();
        IRubyObject value2 = javaModule.getConstantAt(name2);
        if (value2 instanceof RubyModule) {
            return (RubyModule)value2;
        }
        if ("Default".equals(name2)) {
            packageName = "";
        } else {
            Matcher m = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name2);
            packageName = m.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(javaModule, name2, packageName);
    }

    public static IRubyObject get_package_module(IRubyObject recv2, IRubyObject symObject) {
        return Java.getPackageModule(recv2.getRuntime(), symObject.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject recv2, IRubyObject dottedName) {
        Ruby runtime2 = recv2.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime2, dottedName.asJavaString());
        return module == null ? runtime2.getNil() : module;
    }

    public static RubyModule getProxyOrPackageUnderPackage(ThreadContext context, final Ruby runtime2, RubyModule parentPackage, String sym) {
        IRubyObject packageNameObj = parentPackage.fastGetInstanceVariable("@package_name");
        if (packageNameObj == null) {
            throw runtime2.newArgumentError("invalid package module");
        }
        String packageName = packageNameObj.asJavaString();
        String name2 = sym.trim().intern();
        if (name2.length() == 0) {
            throw runtime2.newArgumentError("empty class or package name");
        }
        String fullName = packageName + name2;
        if (!Character.isUpperCase(name2.charAt(0))) {
            if (JAVA_PRIMITIVES.containsKey(name2)) {
                throw runtime2.newArgumentError("illegal package name component: " + name2);
            }
            try {
                return Java.getProxyClass(runtime2, JavaClass.forNameQuiet(runtime2, fullName));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime2, runtime2.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime2, fullName);
            if (packageModule == null) {
                return null;
            }
            final String ivarName = ("@__pkg__" + name2).intern();
            parentPackage.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = parentPackage.getSingletonClass();
            singleton.addMethod(name2, new org.jruby.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    IRubyObject variable;
                    if (args2.length != 0) {
                        Arity.raiseArgumentError(runtime2, args2.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime2.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        return Java.getProxyClass(runtime2, JavaClass.forNameVerbose(runtime2, fullName));
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv2, IRubyObject parentPackage, IRubyObject sym) {
        Ruby runtime2 = recv2.getRuntime();
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime2.newTypeError(parentPackage, runtime2.getModule());
        }
        RubyModule result = Java.getProxyOrPackageUnderPackage(context, runtime2, (RubyModule)parentPackage, sym.asJavaString());
        if (result != null) {
            return result;
        }
        return runtime2.getNil();
    }

    public static RubyModule getTopLevelProxyOrPackage(ThreadContext context, final Ruby runtime2, String sym) {
        String name2 = sym.trim().intern();
        if (name2.length() == 0) {
            throw runtime2.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name2.charAt(0))) {
            try {
                return Java.getProxyClass(runtime2, JavaClass.forNameQuiet(runtime2, name2));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime2, runtime2.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime2, name2);
            if (packageModule == null) {
                return null;
            }
            RubyModule javaModule = runtime2.getJavaSupport().getJavaModule();
            if (javaModule.getMetaClass().isMethodBound(name2, false)) {
                return packageModule;
            }
            final String ivarName = ("@__pkg__" + name2).intern();
            javaModule.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = javaModule.getSingletonClass();
            singleton.addMethod(name2, new org.jruby.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    IRubyObject variable;
                    if (args2.length != 0) {
                        Arity.raiseArgumentError(runtime2, args2.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime2.getNil();
                }

                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        try {
            return Java.getProxyClass(runtime2, JavaClass.forNameQuiet(runtime2, name2));
        }
        catch (RaiseException re) {
            RubyException rubyEx = re.getException();
            if (rubyEx.kind_of_p(context, runtime2.getStandardError()).isTrue()) {
                RuntimeHelpers.setErrorInfo(runtime2, runtime2.getNil());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Java.getPackageModule(runtime2, name2);
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv2, IRubyObject sym) {
        Ruby runtime2 = context.getRuntime();
        RubyModule result = Java.getTopLevelProxyOrPackage(context, runtime2, sym.asJavaString());
        return result != null ? result : runtime2.getNil();
    }

    public static IRubyObject matching_method(IRubyObject recv2, IRubyObject methods2, IRubyObject args2) {
        Map matchCache = recv2.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arg_types = new ArrayList();
        int alen = ((RubyArray)args2).getLength();
        IRubyObject[] aargs = ((RubyArray)args2).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < alen; ++i) {
            if (aargs[i] instanceof JavaObject) {
                arg_types.add(((JavaClass)((JavaObject)aargs[i]).java_class()).javaClass());
                continue;
            }
            arg_types.add(aargs[i].getClass());
        }
        HashMap ms = (HashMap)matchCache.get(methods2);
        if (ms == null) {
            ms = new HashMap();
            matchCache.put(methods2, ms);
        } else {
            IRubyObject method2 = (IRubyObject)ms.get(arg_types);
            if (method2 != null) {
                return method2;
            }
        }
        int mlen = ((RubyArray)methods2).getLength();
        IRubyObject[] margs = ((RubyArray)methods2).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < mlen; ++k) {
                IRubyObject method3 = margs[k];
                List<Class<?>> types = Arrays.asList(((ParameterTypes)((Object)method3)).getParameterTypes());
                if (arg_types.size() != types.size()) continue;
                if (types.equals(arg_types)) {
                    ms.put(arg_types, method3);
                    return method3;
                }
                boolean match2 = true;
                for (int j = 0; j < types.size(); ++j) {
                    if (JavaClass.assignable(types.get(j), (Class)arg_types.get(j)) && (i > 0 || Java.primitive_match(types.get(j), arg_types.get(j))) || JavaUtil.isDuckTypeConvertable((Class)arg_types.get(j), types.get(j))) continue;
                    match2 = false;
                    break;
                }
                if (!match2) continue;
                ms.put(arg_types, method3);
                return method3;
            }
        }
        throw Java.argumentError(recv2.getRuntime().getCurrentContext(), margs[0], recv2, arg_types);
    }

    public static int argsHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.getClass().hashCode());
        }
        return result;
    }

    public static int argsHashCode(Class[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Class element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static int argsHashCode(IRubyObject a0) {
        return 31 + Java.classHashCode(a0);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1) {
        return 31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2) {
        return 31 * (31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1)) + Java.classHashCode(a2);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2, IRubyObject a3) {
        return 31 * (31 * (31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1)) + Java.classHashCode(a2)) + Java.classHashCode(a3);
    }

    private static int classHashCode(IRubyObject o) {
        return o == null ? 0 : o.getJavaClass().hashCode();
    }

    public static int argsHashCode(IRubyObject[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (IRubyObject element : a) {
            result = 31 * result + Java.classHashCode(element);
        }
        return result;
    }

    public static Class argClass(Object a) {
        if (a == null) {
            return Void.TYPE;
        }
        return a.getClass();
    }

    public static Class argClass(IRubyObject a) {
        if (a == null) {
            return Void.TYPE;
        }
        return a.getJavaClass();
    }

    public static JavaCallable matching_method_internal(IRubyObject recv2, Map cache, JavaCallable[] methods2, Object[] args2, int len) {
        Class<?>[] types;
        int k;
        int signatureCode = Java.argsHashCode(args2);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 != null) {
            return method2;
        }
        int mlen = methods2.length;
        block0: for (k = 0; k < mlen; ++k) {
            method2 = methods2[k];
            types = method2.getParameterTypes();
            if (len != types.length) continue;
            boolean same2 = true;
            int y = len;
            for (int x = 0; x < y; ++x) {
                if (types[x].equals(Java.argClass(args2[x]))) continue;
                same2 = false;
                break;
            }
            if (same2) {
                cache.put(signatureCode, method2);
                return method2;
            }
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], Java.argClass(args2[j])) || !Java.primitive_match(types[j], Java.argClass(args2[j]))) continue block0;
            }
            cache.put(signatureCode, method2);
            return method2;
        }
        block3: for (k = 0; k < mlen; ++k) {
            method2 = methods2[k];
            types = method2.getParameterTypes();
            if (len != types.length) continue;
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], Java.argClass(args2[j])) && !JavaUtil.isDuckTypeConvertable(Java.argClass(args2[j]), types[j])) continue block3;
            }
            cache.put(signatureCode, method2);
            return method2;
        }
        throw Java.argTypesDoNotMatch(recv2.getRuntime(), recv2, methods2, args2);
    }

    public static ParameterTypes matchingCallableArityN(IRubyObject recv2, Map cache, ParameterTypes[] methods2, IRubyObject[] args2, int argsLength) {
        int signatureCode = Java.argsHashCode(args2);
        ParameterTypes method2 = (ParameterTypes)cache.get(signatureCode);
        if (method2 == null) {
            method2 = Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, args2);
        }
        return method2;
    }

    private static ParameterTypes findMatchingCallableForArgs(IRubyObject recv2, Map cache, int signatureCode, ParameterTypes[] methods2, IRubyObject ... args2) {
        ParameterTypes method2 = Java.findCallable(methods2, Exact, args2);
        if (method2 == null) {
            method2 = Java.findCallable(methods2, AssignableAndPrimitivable, args2);
        }
        if (method2 == null) {
            method2 = Java.findCallable(methods2, AssignableOrDuckable, args2);
        }
        if (method2 == null) {
            throw Java.argTypesDoNotMatch(recv2.getRuntime(), recv2, methods2, args2);
        }
        cache.put(signatureCode, method2);
        return method2;
    }

    private static ParameterTypes findCallable(ParameterTypes[] callables, CallableAcceptor acceptor, IRubyObject ... args2) {
        ParameterTypes bestCallable = null;
        int bestScore = -1;
        for (int k = 0; k < callables.length; ++k) {
            int currentScore;
            ParameterTypes callable = callables[k];
            Class<?>[] types = callable.getParameterTypes();
            if (!acceptor.accept(types, args2) || (currentScore = Java.getExactnessScore(types, args2)) <= bestScore) continue;
            bestCallable = callable;
            bestScore = currentScore;
        }
        return bestCallable;
    }

    private static int getExactnessScore(Class<?>[] types, IRubyObject[] args2) {
        int count2 = 0;
        for (int i = 0; i < args2.length; ++i) {
            if (!types[i].equals(Java.argClass(args2[i]))) continue;
            ++count2;
        }
        return count2;
    }

    public static JavaCallable matchingCallableArityN(IRubyObject recv2, Map cache, JavaCallable[] methods2, IRubyObject[] args2, int argsLength) {
        int signatureCode = Java.argsHashCode(args2);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, args2);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityOne(IRubyObject recv2, Map cache, JavaCallable[] methods2, IRubyObject arg0) {
        int signatureCode = Java.argsHashCode(arg0);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, arg0);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityTwo(IRubyObject recv2, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1) {
        int signatureCode = Java.argsHashCode(arg0, arg1);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, arg0, arg1);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityThree(IRubyObject recv2, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int signatureCode = Java.argsHashCode(arg0, arg1, arg2);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, arg0, arg1, arg2);
        }
        return method2;
    }

    public static JavaCallable matchingCallableArityFour(IRubyObject recv2, Map cache, JavaCallable[] methods2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int signatureCode = Java.argsHashCode(arg0, arg1, arg2, arg3);
        JavaCallable method2 = (JavaCallable)cache.get(signatureCode);
        if (method2 == null) {
            method2 = (JavaCallable)Java.findMatchingCallableForArgs(recv2, cache, signatureCode, methods2, arg0, arg1, arg2, arg3);
        }
        return method2;
    }

    private static boolean exactMatch(Class[] types, IRubyObject ... args2) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equals(Java.argClass(args2[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivable(Class[] types, IRubyObject ... args2) {
        for (int i = 0; i < types.length; ++i) {
            if (Java.assignable(types[i], args2[i]) && Java.primitivable(types[i], args2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableOrDuckable(Class[] types, IRubyObject ... args2) {
        for (int i = 0; i < types.length; ++i) {
            if (Java.assignable(types[i], args2[i]) || Java.duckable(types[i], args2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignable(Class type2, IRubyObject arg2) {
        return JavaClass.assignable(type2, Java.argClass(arg2));
    }

    private static boolean primitivable(Class type2, IRubyObject arg2) {
        Class argClass = Java.argClass(arg2);
        if (type2.isPrimitive()) {
            if (type2 == Integer.TYPE || type2 == Long.TYPE || type2 == Short.TYPE || type2 == Character.TYPE) {
                return argClass == Long.TYPE || argClass == Byte.TYPE || argClass == Short.TYPE || argClass == Character.TYPE || argClass == Integer.TYPE || argClass == Long.class || argClass == Byte.class || argClass == Short.class || argClass == Character.class || argClass == Integer.class;
            }
            if (type2 == Float.TYPE || type2 == Double.TYPE) {
                return argClass == Double.TYPE || argClass == Float.TYPE || argClass == Float.class || argClass == Double.class;
            }
            if (type2 == Boolean.TYPE) {
                return argClass == Boolean.TYPE || argClass == Boolean.class;
            }
        }
        return false;
    }

    private static boolean duckable(Class type2, IRubyObject arg2) {
        return JavaUtil.isDuckTypeConvertable(Java.argClass(arg2), type2);
    }

    private static RaiseException argTypesDoNotMatch(Ruby runtime2, IRubyObject receiver2, Object[] methods2, Object ... args2) {
        ArrayList argTypes = new ArrayList(args2.length);
        for (Object o : args2) {
            argTypes.add(Java.argClassTypeError(o));
        }
        return Java.argumentError(runtime2.getCurrentContext(), methods2[0], receiver2, argTypes);
    }

    private static Class argClassTypeError(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        if (object instanceof ConcreteJavaProxy) {
            return ((ConcreteJavaProxy)object).getJavaClass();
        }
        return object.getClass();
    }

    private static RaiseException argumentError(ThreadContext context, Object method2, IRubyObject receiver2, List<Class<?>> argTypes) {
        String methodName = method2 instanceof JavaConstructor || method2 instanceof JavaProxyConstructor ? "constructor" : ((JavaMethod)method2).name().toString();
        return context.getRuntime().newNameError("no " + methodName + " with arguments matching " + argTypes + " on object " + receiver2.callMethod(context, "inspect"), null);
    }

    public static IRubyObject access(IRubyObject recv2, IRubyObject java_type2) {
        int modifiers2 = ((JavaClass)java_type2).javaClass().getModifiers();
        return recv2.getRuntime().newString(Modifier.isPublic(modifiers2) ? "public" : (Modifier.isProtected(modifiers2) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject recv2, IRubyObject name2) {
        RubyString sname = name2.convertToString();
        if (sname.getByteList().length() == 0) {
            return recv2.getRuntime().getFalse();
        }
        return Character.isUpperCase(sname.getByteList().charAt(0)) ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object v1, Object v2) {
        if (((Class)v1).isPrimitive()) {
            if (v1 == Integer.TYPE || v1 == Long.TYPE || v1 == Short.TYPE || v1 == Character.TYPE) {
                return v2 == Integer.class || v2 == Long.class || v2 == Short.class || v2 == Character.class;
            }
            if (v1 == Float.TYPE || v1 == Double.TYPE) {
                return v2 == Float.class || v2 == Double.class;
            }
            if (v1 == Boolean.TYPE) {
                return v2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject recv2, IRubyObject t1, IRubyObject t2) {
        if (((JavaClass)t1).primitive_p().isTrue()) {
            Object v2;
            Object v1 = ((JavaObject)t1).getValue();
            return Java.primitive_match(v1, v2 = ((JavaObject)t2).getValue()) ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
        }
        return recv2.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject recv2, IRubyObject java_object) {
        return Java.getInstance(recv2.getRuntime(), ((JavaObject)java_object).getValue());
    }

    public static IRubyObject wrap(Ruby runtime2, IRubyObject java_object) {
        return Java.getInstance(runtime2, ((JavaObject)java_object).getValue());
    }

    @JRubyMethod(required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_exception_handler(IRubyObject recv2, IRubyObject[] args2, Block block) {
        String name2 = args2[0].toString();
        RubyProc handler = null;
        handler = args2.length > 1 ? (RubyProc)args2[1] : recv2.getRuntime().newProc(Block.Type.PROC, block);
        recv2.getRuntime().getJavaSupport().defineExceptionHandler(name2, handler);
        return recv2;
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject primitive_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.primitive_to_java(recv2, object, unusedBlock);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        try {
            return JavaUtil.java_to_ruby(recv2.getRuntime(), object);
        }
        catch (RuntimeException e) {
            recv2.getRuntime().getJavaSupport().handleNativeException(e);
            return recv2.getRuntime().getNil();
        }
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.ruby_to_java(recv2, object, unusedBlock);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_primitive(recv2, object, unusedBlock);
    }

    @JRubyMethod(required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    @Deprecated
    public static IRubyObject new_proxy_instance(final IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyProc proc2;
        int size2 = Arity.checkArgumentCount(recv2.getRuntime(), args2, 1, -1) - 1;
        if (args2[size2] instanceof RubyProc) {
            proc2 = (RubyProc)args2[size2];
        } else {
            proc2 = recv2.getRuntime().newProc(Block.Type.PROC, block);
            ++size2;
        }
        Class[] interfaces2 = new Class[size2];
        for (int i = 0; i < size2; ++i) {
            if (!(args2[i] instanceof JavaClass) || !((JavaClass)args2[i]).interface_p().isTrue()) {
                throw recv2.getRuntime().newArgumentError("Java interface expected. got: " + args2[i]);
            }
            interfaces2[i] = ((JavaClass)args2[i]).javaClass();
        }
        return JavaObject.wrap(recv2.getRuntime(), Proxy.newProxyInstance(recv2.getRuntime().getJRubyClassLoader(), interfaces2, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            public Object invoke(Object proxy2, Method method2, Object[] nargs) throws Throwable {
                Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method2);
                if (parameterTypes == null) {
                    parameterTypes = method2.getParameterTypes();
                    this.parameterTypeCache.put(method2, parameterTypes);
                }
                int methodArgsLength = parameterTypes.length;
                String methodName = method2.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy2.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy2.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && parameterTypes[0].equals(Object.class)) {
                    return proxy2 == nargs[0];
                }
                Ruby runtime2 = recv2.getRuntime();
                int length2 = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length2 + 2];
                rubyArgs[0] = JavaObject.wrap(runtime2, proxy2);
                rubyArgs[1] = new JavaMethod(runtime2, method2);
                for (int i = 0; i < length2; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(runtime2, nargs[i]);
                }
                return JavaUtil.convertArgument(runtime2, proc2.call(runtime2.getCurrentContext(), rubyArgs), method2.getReturnType());
            }
        }));
    }

    @JRubyMethod(required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject recv2, final IRubyObject wrapper, IRubyObject ifcs, Block block) {
        IRubyObject[] javaClasses = ((RubyArray)ifcs).toJavaArray();
        final Ruby runtime2 = recv2.getRuntime();
        Class[] interfaces2 = new Class[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            if (!(javaClasses[i] instanceof JavaClass) || !((JavaClass)javaClasses[i]).interface_p().isTrue()) {
                throw recv2.getRuntime().newArgumentError("Java interface expected. got: " + javaClasses[i]);
            }
            interfaces2[i] = ((JavaClass)javaClasses[i]).javaClass();
        }
        if (!Boolean.getBoolean("jruby.interfaces.useProxy")) {
            Class proxyImplClass;
            int interfacesHashCode = Java.argsHashCode(interfaces2);
            interfacesHashCode = wrapper.getMetaClass().isSingleton() && wrapper.getMetaClass().getRealClass() == runtime2.getProc() ? 31 * interfacesHashCode + runtime2.getProc().hashCode() : 31 * interfacesHashCode + wrapper.getMetaClass().hashCode();
            String implClassName = "org.jruby.gen.InterfaceImpl" + Math.abs(interfacesHashCode);
            try {
                proxyImplClass = Class.forName(implClassName, true, runtime2.getJRubyClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                proxyImplClass = MiniJava.createOldStyleImplClass(interfaces2, wrapper.getMetaClass(), runtime2, implClassName);
            }
            try {
                Constructor proxyConstructor = proxyImplClass.getConstructor(IRubyObject.class);
                return JavaObject.wrap(recv2.getRuntime(), proxyConstructor.newInstance(wrapper));
            }
            catch (NoSuchMethodException nsme) {
                throw runtime2.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
            }
            catch (InvocationTargetException ite) {
                throw runtime2.newTypeError("Exception instantiating generated interface impl:\n" + ite);
            }
            catch (InstantiationException ie) {
                throw runtime2.newTypeError("Exception instantiating generated interface impl:\n" + ie);
            }
            catch (IllegalAccessException iae) {
                throw runtime2.newTypeError("Exception instantiating generated interface impl:\n" + iae);
            }
        }
        return JavaObject.wrap(recv2.getRuntime(), Proxy.newProxyInstance(recv2.getRuntime().getJRubyClassLoader(), interfaces2, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            public Object invoke(Object proxy2, Method method2, Object[] nargs) throws Throwable {
                int length2;
                String methodName = method2.getName();
                int n = length2 = nargs == null ? 0 : nargs.length;
                if (methodName == "toString" && length2 == 0) {
                    return proxy2.getClass().getName();
                }
                if (methodName == "hashCode" && length2 == 0) {
                    return new Integer(proxy2.getClass().hashCode());
                }
                if (methodName == "equals" && length2 == 1) {
                    Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method2);
                    if (parameterTypes == null) {
                        parameterTypes = method2.getParameterTypes();
                        this.parameterTypeCache.put(method2, parameterTypes);
                    }
                    if (parameterTypes[0].equals(Object.class)) {
                        return proxy2 == nargs[0];
                    }
                }
                IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime2, nargs);
                try {
                    return JavaUtil.convertRubyToJava(RuntimeHelpers.invoke(runtime2.getCurrentContext(), wrapper, methodName, rubyArgs), method2.getReturnType());
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }));
    }

    static {
        String[] primitives;
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            public RubyClass defineClassUnder(RubyModule pkg, String name2, RubyClass superClazz) {
                if (superClazz != null) {
                    return null;
                }
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime2 = pkg.getRuntime();
                return (RubyClass)Java.get_proxy_class(runtime2.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime2, packageName.asJavaString() + name2));
            }

            public RubyModule defineModuleUnder(RubyModule pkg, String name2) {
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime2 = pkg.getRuntime();
                return (RubyModule)Java.get_interface_module(runtime2.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime2, packageName.asJavaString() + name2));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String primitive : primitives = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(primitive, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        Exact = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args2) {
                return Java.exactMatch(types, args2);
            }
        };
        AssignableAndPrimitivable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args2) {
                return Java.assignableAndPrimitivable(types, args2);
            }
        };
        AssignableOrDuckable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args2) {
                return Java.assignableOrDuckable(types, args2);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface CallableAcceptor {
        public boolean accept(Class<?>[] var1, IRubyObject[] var2);
    }

    @JRubyModule(name={"JavaUtilities"})
    public static class JavaUtilities {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject wrap(IRubyObject recv2, IRubyObject arg0) {
            return Java.wrap(recv2, arg0);
        }

        @JRubyMethod(name={"valid_constant_name?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject valid_constant_name_p(IRubyObject recv2, IRubyObject arg0) {
            return Java.valid_constant_name_p(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject primitive_match(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return Java.primitive_match(recv2, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject access(IRubyObject recv2, IRubyObject arg0) {
            return Java.access(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject matching_method(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return Java.matching_method(recv2, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject set_java_object(IRubyObject recv2, IRubyObject self, IRubyObject java_object) {
            self.getInstanceVariables().fastSetInstanceVariable("@java_object", java_object);
            self.dataWrapStruct(java_object);
            return java_object;
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_deprecated_interface_proxy(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return Java.get_deprecated_interface_proxy(context, recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_interface_module(IRubyObject recv2, IRubyObject arg0) {
            return Java.get_interface_module(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module(IRubyObject recv2, IRubyObject arg0) {
            return Java.get_package_module(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module_dot_format(IRubyObject recv2, IRubyObject arg0) {
            return Java.get_package_module_dot_format(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_class(IRubyObject recv2, IRubyObject arg0) {
            return Java.get_proxy_class(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject is_primitive_type(IRubyObject recv2, IRubyObject arg0) {
            return Java.is_primitive_type(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject create_proxy_class(IRubyObject recv2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return Java.create_proxy_class(recv2, arg0, arg1, arg2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_java_class(IRubyObject recv2, IRubyObject arg0) {
            return Java.get_java_class(recv2, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv2, IRubyObject arg0) {
            return Java.get_top_level_proxy_or_package(context, recv2, arg0);
        }

        @JRubyMethod(module=true, backtrace=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv2, IRubyObject arg0, IRubyObject arg1) {
            return Java.get_proxy_or_package_under_package(context, recv2, arg0, arg1);
        }

        @Deprecated
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject add_proxy_extender(IRubyObject recv2, IRubyObject arg0) {
            return Java.add_proxy_extender(recv2, arg0);
        }
    }
}

