/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Identity;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.misc.HexDumpEncoder;
import sun.security.pkcs.PKCS10;
import sun.security.pkcs.PKCS10Attribute;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.tools.KeyStoreUtil;
import sun.security.tools.Pair;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.util.Password;
import sun.security.util.PathList;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectInfoAccessExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X500Signer;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class KeyTool {
    private boolean debug = false;
    private int command = -1;
    private String sigAlgName = null;
    private String keyAlgName = null;
    private boolean verbose = false;
    private int keysize = -1;
    private boolean rfc = false;
    private long validity = 90L;
    private String alias = null;
    private String dname = null;
    private String dest = null;
    private String filename = null;
    private String infilename = null;
    private String outfilename = null;
    private String srcksfname = null;
    private Set<Pair<String, String>> providers = null;
    private String storetype = null;
    private String srcProviderName = null;
    private String providerName = null;
    private String pathlist = null;
    private char[] storePass = null;
    private char[] storePassNew = null;
    private char[] keyPass = null;
    private char[] keyPassNew = null;
    private char[] newPass = null;
    private char[] destKeyPass = null;
    private char[] srckeyPass = null;
    private String ksfname = null;
    private File ksfile = null;
    private InputStream ksStream = null;
    private String sslserver = null;
    private KeyStore keyStore = null;
    private boolean token = false;
    private boolean nullStream = false;
    private boolean kssave = false;
    private boolean noprompt = false;
    private boolean trustcacerts = false;
    private boolean protectedPath = false;
    private boolean srcprotectedPath = false;
    private CertificateFactory cf = null;
    private KeyStore caks = null;
    private char[] srcstorePass = null;
    private String srcstoretype = null;
    private Set<char[]> passwords = new HashSet<char[]>();
    private String startDate = null;
    private List<String> v3ext = new ArrayList<String>();
    private static final int CERTREQ = 1;
    private static final int CHANGEALIAS = 2;
    private static final int DELETE = 3;
    private static final int EXPORTCERT = 4;
    private static final int GENKEYPAIR = 5;
    private static final int GENSECKEY = 6;
    private static final int IDENTITYDB = 7;
    private static final int IMPORTCERT = 8;
    private static final int IMPORTKEYSTORE = 9;
    private static final int KEYCLONE = 10;
    private static final int KEYPASSWD = 11;
    private static final int LIST = 12;
    private static final int PRINTCERT = 13;
    private static final int SELFCERT = 14;
    private static final int STOREPASSWD = 15;
    private static final int GENCERT = 16;
    private static final int PRINTCERTREQ = 17;
    private static final Class[] PARAM_STRING = new Class[]{String.class};
    private static final String JKS = "jks";
    private static final String NONE = "NONE";
    private static final String P11KEYSTORE = "PKCS11";
    private static final String P12KEYSTORE = "PKCS12";
    private final String keyAlias = "mykey";
    private static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.Resources");
    private static final Collator collator = Collator.getInstance();
    private static final String[] extSupported;

    private KeyTool() {
    }

    public static void main(String[] stringArray) throws Exception {
        KeyTool keyTool = new KeyTool();
        keyTool.run(stringArray, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(String[] stringArray, PrintStream printStream) throws Exception {
        block10: {
            try {
                this.parseArgs(stringArray);
                if (this.command != -1) {
                    this.doCommands(printStream);
                }
            }
            catch (Exception exception) {
                System.out.println(rb.getString("keytool error: ") + exception);
                if (this.verbose) {
                    exception.printStackTrace(System.out);
                }
                if (!this.debug) {
                    System.exit(1);
                    break block10;
                }
                throw exception;
            }
            finally {
                for (char[] cArray : this.passwords) {
                    if (cArray == null) continue;
                    Arrays.fill(cArray, ' ');
                    cArray = null;
                }
                if (this.ksStream != null) {
                    this.ksStream.close();
                }
            }
        }
    }

    void parseArgs(String[] stringArray) {
        Object object;
        Object object2;
        if (stringArray.length == 0) {
            this.usage();
            return;
        }
        int n = 0;
        for (n = 0; n < stringArray.length && stringArray[n].startsWith("-"); ++n) {
            object2 = stringArray[n];
            if (collator.compare((String)object2, "-certreq") == 0) {
                this.command = 1;
                continue;
            }
            if (collator.compare((String)object2, "-delete") == 0) {
                this.command = 3;
                continue;
            }
            if (collator.compare((String)object2, "-export") == 0 || collator.compare((String)object2, "-exportcert") == 0) {
                this.command = 4;
                continue;
            }
            if (collator.compare((String)object2, "-genkey") == 0 || collator.compare((String)object2, "-genkeypair") == 0) {
                this.command = 5;
                continue;
            }
            if (collator.compare((String)object2, "-help") == 0) {
                this.usage();
                return;
            }
            if (collator.compare((String)object2, "-identitydb") == 0) {
                this.command = 7;
                continue;
            }
            if (collator.compare((String)object2, "-import") == 0 || collator.compare((String)object2, "-importcert") == 0) {
                this.command = 8;
                continue;
            }
            if (collator.compare((String)object2, "-keyclone") == 0) {
                this.command = 10;
                continue;
            }
            if (collator.compare((String)object2, "-changealias") == 0) {
                this.command = 2;
                continue;
            }
            if (collator.compare((String)object2, "-keypasswd") == 0) {
                this.command = 11;
                continue;
            }
            if (collator.compare((String)object2, "-list") == 0) {
                this.command = 12;
                continue;
            }
            if (collator.compare((String)object2, "-printcert") == 0) {
                this.command = 13;
                continue;
            }
            if (collator.compare((String)object2, "-selfcert") == 0) {
                this.command = 14;
                continue;
            }
            if (collator.compare((String)object2, "-storepasswd") == 0) {
                this.command = 15;
                continue;
            }
            if (collator.compare((String)object2, "-importkeystore") == 0) {
                this.command = 9;
                continue;
            }
            if (collator.compare((String)object2, "-genseckey") == 0) {
                this.command = 6;
                continue;
            }
            if (collator.compare((String)object2, "-gencert") == 0) {
                this.command = 16;
                continue;
            }
            if (collator.compare((String)object2, "-printcertreq") == 0) {
                this.command = 17;
                continue;
            }
            if (collator.compare((String)object2, "-keystore") == 0 || collator.compare((String)object2, "-destkeystore") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.ksfname = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-storepass") == 0 || collator.compare((String)object2, "-deststorepass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.storePass = stringArray[n].toCharArray();
                this.passwords.add(this.storePass);
                continue;
            }
            if (collator.compare((String)object2, "-storetype") == 0 || collator.compare((String)object2, "-deststoretype") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.storetype = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-srcstorepass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.srcstorePass = stringArray[n].toCharArray();
                this.passwords.add(this.srcstorePass);
                continue;
            }
            if (collator.compare((String)object2, "-srcstoretype") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.srcstoretype = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-srckeypass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.srckeyPass = stringArray[n].toCharArray();
                this.passwords.add(this.srckeyPass);
                continue;
            }
            if (collator.compare((String)object2, "-srcprovidername") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.srcProviderName = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-providername") == 0 || collator.compare((String)object2, "-destprovidername") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.providerName = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-providerpath") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.pathlist = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-keypass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.keyPass = stringArray[n].toCharArray();
                this.passwords.add(this.keyPass);
                continue;
            }
            if (collator.compare((String)object2, "-new") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.newPass = stringArray[n].toCharArray();
                this.passwords.add(this.newPass);
                continue;
            }
            if (collator.compare((String)object2, "-destkeypass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.destKeyPass = stringArray[n].toCharArray();
                this.passwords.add(this.destKeyPass);
                continue;
            }
            if (collator.compare((String)object2, "-alias") == 0 || collator.compare((String)object2, "-srcalias") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.alias = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-dest") == 0 || collator.compare((String)object2, "-destalias") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.dest = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-dname") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.dname = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-keysize") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.keysize = Integer.parseInt(stringArray[n]);
                continue;
            }
            if (collator.compare((String)object2, "-keyalg") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.keyAlgName = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-sigalg") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.sigAlgName = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-startdate") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.startDate = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-validity") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.validity = Long.parseLong(stringArray[n]);
                continue;
            }
            if (collator.compare((String)object2, "-ext") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.v3ext.add(stringArray[n]);
                continue;
            }
            if (collator.compare((String)object2, "-file") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.filename = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-infile") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.infilename = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-outfile") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.outfilename = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-sslserver") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.sslserver = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-srckeystore") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                this.srcksfname = stringArray[n];
                continue;
            }
            if (collator.compare((String)object2, "-provider") == 0 || collator.compare((String)object2, "-providerclass") == 0) {
                if (++n == stringArray.length) {
                    this.errorNeedArgument((String)object2);
                }
                if (this.providers == null) {
                    this.providers = new HashSet<Pair<String, String>>(3);
                }
                object = stringArray[n];
                String string = null;
                if (stringArray.length > n + 1 && collator.compare((String)(object2 = stringArray[n + 1]), "-providerarg") == 0) {
                    if (stringArray.length == n + 2) {
                        this.errorNeedArgument((String)object2);
                    }
                    string = stringArray[n + 2];
                    n += 2;
                }
                this.providers.add(Pair.of(object, string));
                continue;
            }
            if (collator.compare((String)object2, "-v") == 0) {
                this.verbose = true;
                continue;
            }
            if (collator.compare((String)object2, "-debug") == 0) {
                this.debug = true;
                continue;
            }
            if (collator.compare((String)object2, "-rfc") == 0) {
                this.rfc = true;
                continue;
            }
            if (collator.compare((String)object2, "-noprompt") == 0) {
                this.noprompt = true;
                continue;
            }
            if (collator.compare((String)object2, "-trustcacerts") == 0) {
                this.trustcacerts = true;
                continue;
            }
            if (collator.compare((String)object2, "-protected") == 0 || collator.compare((String)object2, "-destprotected") == 0) {
                this.protectedPath = true;
                continue;
            }
            if (collator.compare((String)object2, "-srcprotected") == 0) {
                this.srcprotectedPath = true;
                continue;
            }
            System.err.println(rb.getString("Illegal option:  ") + (String)object2);
            this.tinyHelp();
        }
        if (n < stringArray.length) {
            object2 = new MessageFormat(rb.getString("Usage error, <arg> is not a legal command"));
            object = new Object[]{stringArray[n]};
            throw new RuntimeException(((Format)object2).format(object));
        }
        if (this.command == -1) {
            System.err.println(rb.getString("Usage error: no command provided"));
            this.tinyHelp();
        }
    }

    boolean isKeyStoreRelated(int n) {
        return n != 13 && n != 17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCommands(PrintStream object) throws Exception {
        Object object3;
        block153: {
            if (this.storetype == null) {
                this.storetype = KeyStore.getDefaultType();
            }
            this.storetype = KeyStoreUtil.niceStoreTypeName(this.storetype);
            if (this.srcstoretype == null) {
                this.srcstoretype = KeyStore.getDefaultType();
            }
            this.srcstoretype = KeyStoreUtil.niceStoreTypeName(this.srcstoretype);
            if (P11KEYSTORE.equalsIgnoreCase(this.storetype) || KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
                this.token = true;
                if (this.ksfname == null) {
                    this.ksfname = NONE;
                }
            }
            if (NONE.equals(this.ksfname)) {
                this.nullStream = true;
            }
            if (this.token && !this.nullStream) {
                System.err.println(MessageFormat.format(rb.getString("-keystore must be NONE if -storetype is {0}"), this.storetype));
                System.err.println();
                this.tinyHelp();
            }
            if (this.token && (this.command == 11 || this.command == 15)) {
                throw new UnsupportedOperationException(MessageFormat.format(rb.getString("-storepasswd and -keypasswd commands not supported if -storetype is {0}"), this.storetype));
            }
            if (P12KEYSTORE.equalsIgnoreCase(this.storetype) && this.command == 11) {
                throw new UnsupportedOperationException(rb.getString("-keypasswd commands not supported if -storetype is PKCS12"));
            }
            if (this.token && (this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(MessageFormat.format(rb.getString("-keypass and -new can not be specified if -storetype is {0}"), this.storetype));
            }
            if (this.protectedPath && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(rb.getString("if -protected is specified, then -storepass, -keypass, and -new must not be specified"));
            }
            if (this.srcprotectedPath && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(rb.getString("if -srcprotected is specified, then -srcstorepass and -srckeypass must not be specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.storetype) && (this.storePass != null || this.keyPass != null || this.newPass != null || this.destKeyPass != null)) {
                throw new IllegalArgumentException(rb.getString("if keystore is not password protected, then -storepass, -keypass, and -new must not be specified"));
            }
            if (KeyStoreUtil.isWindowsKeyStore(this.srcstoretype) && (this.srcstorePass != null || this.srckeyPass != null)) {
                throw new IllegalArgumentException(rb.getString("if source keystore is not password protected, then -srcstorepass and -srckeypass must not be specified"));
            }
            if (this.validity <= 0L) {
                throw new Exception(rb.getString("Validity must be greater than zero"));
            }
            if (this.providers != null) {
                ClassLoader classLoader = null;
                if (this.pathlist != null) {
                    object3 = null;
                    object3 = PathList.appendPath(object3, System.getProperty("java.class.path"));
                    object3 = PathList.appendPath((String)object3, System.getProperty("env.class.path"));
                    object3 = PathList.appendPath((String)object3, this.pathlist);
                    URL[] object22 = PathList.pathToURLs((String)object3);
                    classLoader = new URLClassLoader(object22);
                } else {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                for (Pair pair : this.providers) {
                    Object object2;
                    Object obj;
                    String string = (String)pair.fst;
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    String string2 = (String)pair.snd;
                    if (string2 == null) {
                        obj = clazz.newInstance();
                    } else {
                        object2 = clazz.getConstructor(PARAM_STRING);
                        obj = ((Constructor)object2).newInstance(string2);
                    }
                    if (!(obj instanceof Provider)) {
                        object2 = new MessageFormat(rb.getString("provName not a provider"));
                        Object[] objectArray = new Object[]{string};
                        throw new Exception(((Format)object2).format(objectArray));
                    }
                    Security.addProvider((Provider)obj);
                }
            }
            if (this.command == 12 && this.verbose && this.rfc) {
                System.err.println(rb.getString("Must not specify both -v and -rfc with 'list' command"));
                this.tinyHelp();
            }
            if (this.command == 5 && this.keyPass != null && this.keyPass.length < 6) {
                throw new Exception(rb.getString("Key password must be at least 6 characters"));
            }
            if (this.newPass != null && this.newPass.length < 6) {
                throw new Exception(rb.getString("New password must be at least 6 characters"));
            }
            if (this.destKeyPass != null && this.destKeyPass.length < 6) {
                throw new Exception(rb.getString("New password must be at least 6 characters"));
            }
            if (this.isKeyStoreRelated(this.command)) {
                if (this.ksfname == null) {
                    this.ksfname = System.getProperty("user.home") + File.separator + ".keystore";
                }
                if (!this.nullStream) {
                    try {
                        this.ksfile = new File(this.ksfname);
                        if (this.ksfile.exists() && this.ksfile.length() == 0L) {
                            throw new Exception(rb.getString("Keystore file exists, but is empty: ") + this.ksfname);
                        }
                        this.ksStream = new FileInputStream(this.ksfile);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (this.command == 5 || this.command == 6 || this.command == 7 || this.command == 8 || this.command == 9) break block153;
                        throw new Exception(rb.getString("Keystore file does not exist: ") + this.ksfname);
                    }
                }
            }
        }
        if ((this.command == 10 || this.command == 2) && this.dest == null) {
            this.dest = this.getAlias("destination");
            if ("".equals(this.dest)) {
                throw new Exception(rb.getString("Must specify destination alias"));
            }
        }
        if (this.command == 3 && this.alias == null) {
            this.alias = this.getAlias(null);
            if ("".equals(this.alias)) {
                throw new Exception(rb.getString("Must specify alias"));
            }
        }
        this.keyStore = this.providerName == null ? KeyStore.getInstance(this.storetype) : KeyStore.getInstance(this.storetype, this.providerName);
        if (!this.nullStream) {
            this.keyStore.load(this.ksStream, this.storePass);
            if (this.ksStream != null) {
                this.ksStream.close();
            }
        }
        if (this.nullStream && this.storePass != null) {
            this.keyStore.load(null, this.storePass);
        } else if (!this.nullStream && this.storePass != null) {
            if (this.ksStream == null && this.storePass.length < 6) {
                throw new Exception(rb.getString("Keystore password must be at least 6 characters"));
            }
        } else if (this.storePass == null) {
            if (!(this.protectedPath || KeyStoreUtil.isWindowsKeyStore(this.storetype) || this.command != 1 && this.command != 3 && this.command != 5 && this.command != 6 && this.command != 8 && this.command != 9 && this.command != 10 && this.command != 2 && this.command != 14 && this.command != 15 && this.command != 11 && this.command != 7)) {
                int n = 0;
                do {
                    if (this.command == 9) {
                        System.err.print(rb.getString("Enter destination keystore password:  "));
                    } else {
                        System.err.print(rb.getString("Enter keystore password:  "));
                    }
                    System.err.flush();
                    this.storePass = Password.readPassword(System.in);
                    this.passwords.add(this.storePass);
                    if (!(this.nullStream || this.storePass != null && this.storePass.length >= 6)) {
                        System.err.println(rb.getString("Keystore password is too short - must be at least 6 characters"));
                        this.storePass = null;
                    }
                    if (this.storePass == null || this.nullStream || this.ksStream != null) continue;
                    System.err.print(rb.getString("Re-enter new password: "));
                    object3 = Password.readPassword(System.in);
                    this.passwords.add((char[])object3);
                    if (Arrays.equals(this.storePass, (char[])object3)) continue;
                    System.err.println(rb.getString("They don't match. Try again"));
                    this.storePass = null;
                } while (this.storePass == null && ++n < 3);
                if (this.storePass == null) {
                    System.err.println(rb.getString("Too many failures - try later"));
                    return;
                }
            } else if (!this.protectedPath && !KeyStoreUtil.isWindowsKeyStore(this.storetype) && this.isKeyStoreRelated(this.command)) {
                System.err.print(rb.getString("Enter keystore password:  "));
                System.err.flush();
                this.storePass = Password.readPassword(System.in);
                this.passwords.add(this.storePass);
            }
            if (this.nullStream) {
                this.keyStore.load(null, this.storePass);
            } else if (this.ksStream != null) {
                this.ksStream = new FileInputStream(this.ksfile);
                this.keyStore.load(this.ksStream, this.storePass);
                this.ksStream.close();
            }
        }
        if (this.storePass != null && P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Warning:  Different store and key passwords not supported for PKCS12 KeyStores. Ignoring user-specified <command> value."));
            if (this.keyPass != null && !Arrays.equals(this.storePass, this.keyPass)) {
                object3 = new Object[]{"-keypass"};
                System.err.println(messageFormat.format(object3));
                this.keyPass = this.storePass;
            }
            if (this.newPass != null && !Arrays.equals(this.storePass, this.newPass)) {
                object3 = new Object[]{"-new"};
                System.err.println(messageFormat.format(object3));
                this.newPass = this.storePass;
            }
            if (this.destKeyPass != null && !Arrays.equals(this.storePass, this.destKeyPass)) {
                object3 = new Object[]{"-destkeypass"};
                System.err.println(messageFormat.format(object3));
                this.destKeyPass = this.storePass;
            }
        }
        if (this.command == 13 || this.command == 8 || this.command == 7) {
            this.cf = CertificateFactory.getInstance("X509");
        }
        if (this.trustcacerts) {
            this.caks = KeyTool.getCacertsKeyStore();
        }
        if (this.command == 1) {
            PrintStream printStream = null;
            if (this.filename != null) {
                printStream = new PrintStream(new FileOutputStream(this.filename));
                object = printStream;
            }
            try {
                this.doCertReq(this.alias, this.sigAlgName, (PrintStream)object);
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
            if (this.verbose && this.filename != null) {
                object3 = new MessageFormat(rb.getString("Certification request stored in file <filename>"));
                Object[] objectArray = new Object[]{this.filename};
                System.err.println(((Format)object3).format(objectArray));
                System.err.println(rb.getString("Submit this to your CA"));
            }
        } else if (this.command == 3) {
            this.doDeleteEntry(this.alias);
            this.kssave = true;
        } else if (this.command == 4) {
            PrintStream printStream = null;
            if (this.filename != null) {
                printStream = new PrintStream(new FileOutputStream(this.filename));
                object = printStream;
            }
            try {
                this.doExportCert(this.alias, (PrintStream)object);
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
            }
            if (this.filename != null) {
                object3 = new MessageFormat(rb.getString("Certificate stored in file <filename>"));
                Object[] objectArray = new Object[]{this.filename};
                System.err.println(((Format)object3).format(objectArray));
            }
        } else if (this.command == 5) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DSA";
            }
            this.doGenKeyPair(this.alias, this.dname, this.keyAlgName, this.keysize, this.sigAlgName);
            this.kssave = true;
        } else if (this.command == 6) {
            if (this.keyAlgName == null) {
                this.keyAlgName = "DES";
            }
            this.doGenSecretKey(this.alias, this.keyAlgName, this.keysize);
            this.kssave = true;
        } else {
            if (this.command == 7) {
                InputStream inputStream = System.in;
                if (this.filename != null) {
                    inputStream = new FileInputStream(this.filename);
                }
                try {
                    this.doImportIdentityDatabase(inputStream);
                }
                finally {
                    if (inputStream != System.in) {
                        inputStream.close();
                    }
                }
            }
            if (this.command == 8) {
                String string;
                InputStream inputStream = System.in;
                if (this.filename != null) {
                    inputStream = new FileInputStream(this.filename);
                }
                object3 = new ByteArrayOutputStream();
                try {
                    int n;
                    byte[] byArray = new byte[4096];
                    while ((n = inputStream.read(byArray)) >= 0) {
                        ((ByteArrayOutputStream)object3).write(byArray, 0, n);
                    }
                }
                finally {
                    if (inputStream != System.in) {
                        inputStream.close();
                    }
                }
                inputStream = new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray());
                String string3 = string = this.alias != null ? this.alias : "mykey";
                if (this.keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
                    this.kssave = this.installReply(string, inputStream);
                    if (this.kssave) {
                        System.err.println(rb.getString("Certificate reply was installed in keystore"));
                    } else {
                        System.err.println(rb.getString("Certificate reply was not installed in keystore"));
                    }
                } else if (!this.keyStore.containsAlias(string) || this.keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
                    this.kssave = this.addTrustedCert(string, inputStream);
                    if (this.kssave) {
                        System.err.println(rb.getString("Certificate was added to keystore"));
                    } else {
                        System.err.println(rb.getString("Certificate was not added to keystore"));
                    }
                }
            } else if (this.command == 9) {
                this.doImportKeyStore();
                this.kssave = true;
            } else if (this.command == 10) {
                this.keyPassNew = this.newPass;
                if (this.alias == null) {
                    this.alias = "mykey";
                }
                if (!this.keyStore.containsAlias(this.alias)) {
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
                    object3 = new Object[]{this.alias};
                    throw new Exception(messageFormat.format(object3));
                }
                if (!this.keyStore.entryInstanceOf(this.alias, KeyStore.PrivateKeyEntry.class)) {
                    MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> references an entry type that is not a private key entry.  The -keyclone command only supports cloning of private key entries"));
                    object3 = new Object[]{this.alias};
                    throw new Exception(messageFormat.format(object3));
                }
                this.doCloneEntry(this.alias, this.dest, true);
                this.kssave = true;
            } else if (this.command == 2) {
                if (this.alias == null) {
                    this.alias = "mykey";
                }
                this.doCloneEntry(this.alias, this.dest, false);
                if (this.keyStore.containsAlias(this.alias)) {
                    this.doDeleteEntry(this.alias);
                }
                this.kssave = true;
            } else if (this.command == 11) {
                this.keyPassNew = this.newPass;
                this.doChangeKeyPasswd(this.alias);
                this.kssave = true;
            } else if (this.command == 12) {
                if (this.alias != null) {
                    this.doPrintEntry(this.alias, (PrintStream)object, true);
                } else {
                    this.doPrintEntries((PrintStream)object);
                }
            } else if (this.command == 13) {
                this.doPrintCert((PrintStream)object);
            } else if (this.command == 14) {
                this.doSelfCert(this.alias, this.dname, this.sigAlgName);
                this.kssave = true;
            } else if (this.command == 15) {
                this.storePassNew = this.newPass;
                if (this.storePassNew == null) {
                    this.storePassNew = this.getNewPasswd("keystore password", this.storePass);
                }
                this.kssave = true;
            } else {
                if (this.command == 16) {
                    if (this.alias == null) {
                        this.alias = "mykey";
                    }
                    InputStream inputStream = System.in;
                    if (this.infilename != null) {
                        inputStream = new FileInputStream(this.infilename);
                    }
                    object3 = null;
                    if (this.outfilename != null) {
                        object = object3 = new PrintStream(new FileOutputStream(this.outfilename));
                    }
                    try {
                        this.doGenCert(this.alias, this.sigAlgName, inputStream, (PrintStream)object);
                    }
                    finally {
                        if (inputStream != System.in) {
                            inputStream.close();
                        }
                        if (object3 != null) {
                            ((PrintStream)object3).close();
                        }
                    }
                }
                if (this.command == 17) {
                    InputStream inputStream = System.in;
                    if (this.filename != null) {
                        inputStream = new FileInputStream(this.filename);
                    }
                    try {
                        this.doPrintCertReq(inputStream, (PrintStream)object);
                    }
                    finally {
                        if (inputStream != System.in) {
                            inputStream.close();
                        }
                    }
                }
            }
        }
        if (this.kssave) {
            if (this.verbose) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("[Storing ksfname]"));
                object3 = new Object[]{this.nullStream ? "keystore" : this.ksfname};
                System.err.println(messageFormat.format(object3));
            }
            if (this.token) {
                this.keyStore.store(null, null);
            } else {
                try (FileOutputStream fileOutputStream = null;){
                    fileOutputStream = this.nullStream ? (FileOutputStream)null : new FileOutputStream(this.ksfname);
                    this.keyStore.store(fileOutputStream, this.storePassNew != null ? this.storePassNew : this.storePass);
                }
            }
        }
    }

    private void doGenCert(String string, String string2, InputStream inputStream, PrintStream printStream) throws Exception {
        Object object2;
        Certificate certificate = this.keyStore.getCertificate(string);
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        X500Name x500Name = (X500Name)x509CertInfo.get("subject.dname");
        Date date = KeyTool.getStartDate(this.startDate);
        Date date2 = new Date();
        date2.setTime(date.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        PrivateKey privateKey = (PrivateKey)this.recoverKey((String)string, (char[])this.storePass, (char[])this.keyPass).fst;
        if (string2 == null) {
            string2 = KeyTool.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(string2);
        signature.initSign(privateKey);
        X500Signer x500Signer = new X500Signer(signature, x500Name);
        X509CertInfo x509CertInfo2 = new X509CertInfo();
        x509CertInfo2.set("validity", certificateValidity);
        x509CertInfo2.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        x509CertInfo2.set("version", new CertificateVersion(2));
        x509CertInfo2.set("algorithmID", new CertificateAlgorithmId(x500Signer.getAlgorithmId()));
        x509CertInfo2.set("issuer", new CertificateIssuerName(x500Signer.getSigner()));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while ((object2 = bufferedReader.readLine()) != null) {
            if (((String)object2).startsWith("-----BEGIN") && ((String)object2).indexOf("REQUEST") >= 0) {
                bl = true;
                continue;
            }
            if (((String)object2).startsWith("-----END") && ((String)object2).indexOf("REQUEST") >= 0) break;
            if (!bl) continue;
            stringBuffer.append((String)object2);
        }
        object2 = new BASE64Decoder().decodeBuffer(new String(stringBuffer));
        PKCS10 pKCS10 = new PKCS10((byte[])object2);
        x509CertInfo2.set("key", new CertificateX509Key(pKCS10.getSubjectPublicKeyInfo()));
        x509CertInfo2.set("subject", new CertificateSubjectName(this.dname == null ? pKCS10.getSubjectName() : new X500Name(this.dname)));
        CertificateExtensions certificateExtensions = null;
        for (PKCS10Attribute object3 : pKCS10.getAttributes().getAttributes()) {
            if (!object3.getAttributeId().equals(PKCS9Attribute.EXTENSION_REQUEST_OID)) continue;
            certificateExtensions = (CertificateExtensions)object3.getAttributeValue();
        }
        CertificateExtensions certificateExtensions2 = this.createV3Extensions(certificateExtensions, null, this.v3ext, pKCS10.getSubjectPublicKeyInfo(), certificate.getPublicKey());
        x509CertInfo2.set("extensions", certificateExtensions2);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo2);
        x509CertImpl2.sign(privateKey, string2);
        this.dumpCert(x509CertImpl2, printStream);
    }

    private void doCertReq(String string, String string2, PrintStream printStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = "mykey";
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        PKCS10 pKCS10 = new PKCS10(certificate.getPublicKey());
        CertificateExtensions certificateExtensions = this.createV3Extensions(null, null, this.v3ext, certificate.getPublicKey(), null);
        pKCS10.getAttributes().setAttribute("extensions", new PKCS10Attribute(PKCS9Attribute.EXTENSION_REQUEST_OID, certificateExtensions));
        if (string2 == null) {
            string2 = KeyTool.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        Signature signature = Signature.getInstance(string2);
        signature.initSign(privateKey);
        X500Name x500Name = this.dname == null ? new X500Name(((X509Certificate)certificate).getSubjectDN().toString()) : new X500Name(this.dname);
        X500Signer x500Signer = new X500Signer(signature, x500Name);
        pKCS10.encodeAndSign(x500Signer);
        pKCS10.print(printStream);
    }

    private void doDeleteEntry(String string) throws Exception {
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.keyStore.deleteEntry(string);
    }

    private void doExportCert(String string, PrintStream printStream) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        }
        if (string == null) {
            string = "mykey";
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = (X509Certificate)this.keyStore.getCertificate(string);
        if (x509Certificate == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> has no certificate"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        this.dumpCert(x509Certificate, printStream);
    }

    private char[] promptForKeyPass(String string, String string2, char[] cArray) throws Exception {
        if (P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
            return cArray;
        }
        if (!this.token) {
            int n;
            for (n = 0; n < 3; ++n) {
                Object[] objectArray;
                MessageFormat messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                Object[] objectArray2 = new Object[]{string};
                System.err.println(messageFormat.format(objectArray2));
                if (string2 == null) {
                    System.err.print(rb.getString("\t(RETURN if same as keystore password):  "));
                } else {
                    messageFormat = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                    objectArray = new Object[]{string2};
                    System.err.print(messageFormat.format(objectArray));
                }
                System.err.flush();
                objectArray = Password.readPassword(System.in);
                this.passwords.add((char[])objectArray);
                if (objectArray == null) {
                    return cArray;
                }
                if (objectArray.length >= 6) {
                    System.err.print(rb.getString("Re-enter new password: "));
                    char[] cArray2 = Password.readPassword(System.in);
                    this.passwords.add(cArray2);
                    if (!Arrays.equals(objectArray, cArray2)) {
                        System.err.println(rb.getString("They don't match. Try again"));
                        continue;
                    }
                    return objectArray;
                }
                System.err.println(rb.getString("Key password is too short - must be at least 6 characters"));
            }
            if (n == 3) {
                if (this.command == 10) {
                    throw new Exception(rb.getString("Too many failures. Key entry not cloned"));
                }
                throw new Exception(rb.getString("Too many failures - key not added to keystore"));
            }
        }
        return null;
    }

    private void doGenSecretKey(String string, String string2, int n) throws Exception {
        if (string == null) {
            string = "mykey";
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Secret key not generated, alias <alias> already exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        SecretKey secretKey = null;
        KeyGenerator keyGenerator = KeyGenerator.getInstance(string2);
        if (n != -1) {
            keyGenerator.init(n);
        } else if ("DES".equalsIgnoreCase(string2)) {
            keyGenerator.init(56);
        } else if ("DESede".equalsIgnoreCase(string2)) {
            keyGenerator.init(168);
        } else {
            throw new Exception(rb.getString("Please provide -keysize for secret key generation"));
        }
        secretKey = keyGenerator.generateKey();
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(string, null, this.storePass);
        }
        this.keyStore.setKeyEntry(string, secretKey, this.keyPass, null);
    }

    private static String getCompatibleSigAlgName(String string) throws Exception {
        if ("DSA".equalsIgnoreCase(string)) {
            return "SHA1WithDSA";
        }
        if ("RSA".equalsIgnoreCase(string)) {
            return "SHA256WithRSA";
        }
        if ("EC".equalsIgnoreCase(string)) {
            return "SHA1withECDSA";
        }
        throw new Exception(rb.getString("Cannot derive signature algorithm"));
    }

    private void doGenKeyPair(String string, String string2, String string3, int n, String string4) throws Exception {
        if (n == -1) {
            n = "EC".equalsIgnoreCase(string3) ? 256 : ("RSA".equalsIgnoreCase(string3) ? 2048 : 1024);
        }
        if (string == null) {
            string = "mykey";
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Key pair not generated, alias <alias> already exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (string4 == null) {
            string4 = KeyTool.getCompatibleSigAlgName(string3);
        }
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen(string3, string4, this.providerName);
        X500Name x500Name = string2 == null ? this.getX500Name() : new X500Name(string2);
        certAndKeyGen.generate(n);
        PrivateKey privateKey = certAndKeyGen.getPrivateKey();
        Certificate[] certificateArray = new X509Certificate[]{certAndKeyGen.getSelfCertificate(x500Name, KeyTool.getStartDate(this.startDate), this.validity * 24L * 60L * 60L)};
        if (this.verbose) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Generating keysize bit keyAlgName key pair and self-signed certificate (sigAlgName) with a validity of validality days\n\tfor: x500Name"));
            Object[] objectArray = new Object[]{new Integer(n), privateKey.getAlgorithm(), ((X509Certificate)certificateArray[0]).getSigAlgName(), new Long(this.validity), x500Name};
            System.err.println(messageFormat.format(objectArray));
        }
        if (this.keyPass == null) {
            this.keyPass = this.promptForKeyPass(string, null, this.storePass);
        }
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass, certificateArray);
        this.doSelfCert(string, null, string4);
    }

    private void doCloneEntry(String string, String string2, boolean bl) throws Exception {
        if (string == null) {
            string = "mykey";
        }
        if (this.keyStore.containsAlias(string2)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Destination alias <dest> already exists"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        Pair<KeyStore.Entry, char[]> pair = this.recoverEntry(this.keyStore, string, this.storePass, this.keyPass);
        KeyStore.Entry entry = (KeyStore.Entry)pair.fst;
        this.keyPass = (char[])pair.snd;
        KeyStore.PasswordProtection passwordProtection = null;
        if (this.keyPass != null) {
            if (!bl || P12KEYSTORE.equalsIgnoreCase(this.storetype)) {
                this.keyPassNew = this.keyPass;
            } else if (this.keyPassNew == null) {
                this.keyPassNew = this.promptForKeyPass(string2, string, this.keyPass);
            }
            passwordProtection = new KeyStore.PasswordProtection(this.keyPassNew);
        }
        this.keyStore.setEntry(string2, entry, passwordProtection);
    }

    private void doChangeKeyPasswd(String string) throws Exception {
        if (string == null) {
            string = "mykey";
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        Key key = (Key)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if (this.keyPassNew == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("key password for <alias>"));
            Object[] objectArray = new Object[]{string};
            this.keyPassNew = this.getNewPasswd(messageFormat.format(objectArray), this.keyPass);
        }
        this.keyStore.setKeyEntry(string, key, this.keyPassNew, this.keyStore.getCertificateChain(string));
    }

    private void doImportIdentityDatabase(InputStream inputStream) throws Exception {
        Certificate[] certificateArray = null;
        boolean bl = false;
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(inputStream);
        Enumeration<Identity> enumeration = identityDatabase.identities();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object[] objectArray;
            Object object;
            Identity identity = enumeration.nextElement();
            X509Certificate x509Certificate = null;
            if ((!(identity instanceof SystemSigner) || !((SystemSigner)identity).isTrusted()) && (!(identity instanceof SystemIdentity) || !((SystemIdentity)identity).isTrusted())) continue;
            if (this.keyStore.containsAlias(identity.getName())) {
                object = new MessageFormat(rb.getString("Keystore entry for <id.getName()> already exists"));
                objectArray = new Object[]{identity.getName()};
                System.err.println(((Format)object).format(objectArray));
                continue;
            }
            object = identity.certificates();
            if (object == null || ((java.security.Certificate[])object).length <= 0) continue;
            objectArray = new DerOutputStream();
            object[0].encode((OutputStream)objectArray);
            byte[] byArray = objectArray.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            x509Certificate = (X509Certificate)this.cf.generateCertificate(byteArrayInputStream);
            byteArrayInputStream.close();
            if (this.isSelfSigned(x509Certificate)) {
                serializable = x509Certificate.getPublicKey();
                try {
                    x509Certificate.verify((PublicKey)serializable);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (identity instanceof SystemSigner) {
                serializable = new MessageFormat(rb.getString("Creating keystore entry for <id.getName()> ..."));
                Object[] objectArray2 = new Object[]{identity.getName()};
                System.err.println(((Format)serializable).format(objectArray2));
                if (certificateArray == null) {
                    certificateArray = new Certificate[]{x509Certificate};
                }
                PrivateKey privateKey = ((SystemSigner)identity).getPrivateKey();
                this.keyStore.setKeyEntry(identity.getName(), privateKey, this.storePass, certificateArray);
            } else {
                this.keyStore.setCertificateEntry(identity.getName(), x509Certificate);
            }
            this.kssave = true;
        }
        if (!this.kssave) {
            System.err.println(rb.getString("No entries from identity database added"));
        }
    }

    private void doPrintEntry(String string, PrintStream printStream, boolean bl) throws Exception {
        Object object;
        Object[] objectArray;
        Object object2;
        if (this.storePass == null && bl && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        }
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray2 = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray2));
        }
        if (this.verbose || this.rfc || this.debug) {
            object2 = new MessageFormat(rb.getString("Alias name: alias"));
            objectArray = new Object[]{string};
            printStream.println(((Format)object2).format(objectArray));
            if (!this.token) {
                object2 = new MessageFormat(rb.getString("Creation date: keyStore.getCreationDate(alias)"));
                object = new Object[]{this.keyStore.getCreationDate(string)};
                printStream.println(((Format)object2).format(object));
            }
        } else if (!this.token) {
            object2 = new MessageFormat(rb.getString("alias, keyStore.getCreationDate(alias), "));
            objectArray = new Object[]{string, this.keyStore.getCreationDate(string)};
            printStream.print(((Format)object2).format(objectArray));
        } else {
            object2 = new MessageFormat(rb.getString("alias, "));
            objectArray = new Object[]{string};
            printStream.print(((Format)object2).format(objectArray));
        }
        if (this.keyStore.entryInstanceOf(string, KeyStore.SecretKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                object2 = new Object[]{"SecretKeyEntry"};
                printStream.println(new MessageFormat(rb.getString("Entry type: <type>")).format(object2));
            } else {
                printStream.println("SecretKeyEntry, ");
            }
        } else if (this.keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) {
            if (this.verbose || this.rfc || this.debug) {
                object2 = new Object[]{"PrivateKeyEntry"};
                printStream.println(new MessageFormat(rb.getString("Entry type: <type>")).format(object2));
            } else {
                printStream.println("PrivateKeyEntry, ");
            }
            object2 = this.keyStore.getCertificateChain(string);
            if (object2 != null) {
                if (this.verbose || this.rfc || this.debug) {
                    printStream.println(rb.getString("Certificate chain length: ") + ((Object)object2).length);
                    for (int i = 0; i < ((Object)object2).length; ++i) {
                        object = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                        Object[] objectArray3 = new Object[]{new Integer(i + 1)};
                        printStream.println(((Format)object).format(objectArray3));
                        if (this.verbose && object2[i] instanceof X509Certificate) {
                            this.printX509Cert((X509Certificate)object2[i], printStream);
                            continue;
                        }
                        if (this.debug) {
                            printStream.println(((Certificate)object2[i]).toString());
                            continue;
                        }
                        this.dumpCert((Certificate)object2[i], printStream);
                    }
                } else {
                    printStream.println(rb.getString("Certificate fingerprint (SHA1): ") + this.getCertFingerPrint("SHA1", (Certificate)object2[0]));
                }
            }
        } else if (this.keyStore.entryInstanceOf(string, KeyStore.TrustedCertificateEntry.class)) {
            object2 = this.keyStore.getCertificate(string);
            if (this.verbose && object2 instanceof X509Certificate) {
                printStream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.printX509Cert((X509Certificate)object2, printStream);
            } else if (this.rfc) {
                printStream.println(rb.getString("Entry type: trustedCertEntry\n"));
                this.dumpCert((Certificate)object2, printStream);
            } else if (this.debug) {
                printStream.println(((Certificate)object2).toString());
            } else {
                printStream.println(rb.getString("trustedCertEntry,"));
                printStream.println(rb.getString("Certificate fingerprint (SHA1): ") + this.getCertFingerPrint("SHA1", (Certificate)object2));
            }
        } else {
            printStream.println(rb.getString("Unknown Entry Type"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyStore loadSourceKeyStore() throws Exception {
        Object object;
        boolean bl = false;
        InputStream inputStream = null;
        if (P11KEYSTORE.equalsIgnoreCase(this.srcstoretype) || KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            if (!NONE.equals(this.srcksfname)) {
                System.err.println(MessageFormat.format(rb.getString("-keystore must be NONE if -storetype is {0}"), this.srcstoretype));
                System.err.println();
                this.tinyHelp();
            }
            bl = true;
        } else if (this.srcksfname != null) {
            object = new File(this.srcksfname);
            if (((File)object).exists() && ((File)object).length() == 0L) {
                throw new Exception(rb.getString("Source keystore file exists, but is empty: ") + this.srcksfname);
            }
            inputStream = new FileInputStream((File)object);
        } else {
            throw new Exception(rb.getString("Please specify -srckeystore"));
        }
        try {
            object = this.srcProviderName == null ? KeyStore.getInstance(this.srcstoretype) : KeyStore.getInstance(this.srcstoretype, this.srcProviderName);
            if (this.srcstorePass == null && !this.srcprotectedPath && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
                System.err.print(rb.getString("Enter source keystore password:  "));
                System.err.flush();
                this.srcstorePass = Password.readPassword(System.in);
                this.passwords.add(this.srcstorePass);
            }
            if (P12KEYSTORE.equalsIgnoreCase(this.srcstoretype) && this.srckeyPass != null && this.srcstorePass != null && !Arrays.equals(this.srcstorePass, this.srckeyPass)) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Warning:  Different store and key passwords not supported for PKCS12 KeyStores. Ignoring user-specified <command> value."));
                Object[] objectArray = new Object[]{"-srckeypass"};
                System.err.println(messageFormat.format(objectArray));
                this.srckeyPass = this.srcstorePass;
            }
            ((KeyStore)object).load(inputStream, this.srcstorePass);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (this.srcstorePass == null && !KeyStoreUtil.isWindowsKeyStore(this.srcstoretype)) {
            System.err.println();
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println(rb.getString("* The integrity of the information stored in the srckeystore*"));
            System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
            System.err.println(rb.getString("* you must provide the srckeystore password.                *"));
            System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
            System.err.println();
        }
        return object;
    }

    private void doImportKeyStore() throws Exception {
        if (this.alias != null) {
            this.doImportKeyStoreSingle(this.loadSourceKeyStore(), this.alias);
        } else {
            if (this.dest != null || this.srckeyPass != null || this.destKeyPass != null) {
                throw new Exception(rb.getString("if alias not specified, destalias, srckeypass, and destkeypass must not be specified"));
            }
            this.doImportKeyStoreAll(this.loadSourceKeyStore());
        }
    }

    private int doImportKeyStoreSingle(KeyStore keyStore, String string) throws Exception {
        Object object;
        Object object2;
        String string2;
        String string3 = string2 = this.dest == null ? string : this.dest;
        if (this.keyStore.containsAlias(string2)) {
            object2 = new Object[]{string};
            if (this.noprompt) {
                System.err.println(new MessageFormat(rb.getString("Warning: Overwriting existing alias <alias> in destination keystore")).format(object2));
            } else {
                object = this.getYesNoReply(new MessageFormat(rb.getString("Existing entry alias <alias> exists, overwrite? [no]:  ")).format(object2));
                if ("NO".equals(object) && "".equals(string2 = this.inputStringFromStdin(rb.getString("Enter new alias name\t(RETURN to cancel import for this entry):  ")))) {
                    System.err.println(new MessageFormat(rb.getString("Entry for alias <alias> not imported.")).format(object2));
                    return 0;
                }
            }
        }
        object2 = this.recoverEntry(keyStore, string, this.srcstorePass, this.srckeyPass);
        object = (KeyStore.Entry)object2.fst;
        KeyStore.PasswordProtection passwordProtection = null;
        if (this.destKeyPass != null) {
            passwordProtection = new KeyStore.PasswordProtection(this.destKeyPass);
        } else if (object2.snd != null) {
            passwordProtection = new KeyStore.PasswordProtection((char[])object2.snd);
        }
        try {
            this.keyStore.setEntry(string2, (KeyStore.Entry)object, passwordProtection);
            return 1;
        }
        catch (KeyStoreException keyStoreException) {
            Object[] objectArray = new Object[]{string, keyStoreException.toString()};
            MessageFormat messageFormat = new MessageFormat(rb.getString("Problem importing entry for alias <alias>: <exception>.\nEntry for alias <alias> not imported."));
            System.err.println(messageFormat.format(objectArray));
            return 2;
        }
    }

    private void doImportKeyStoreAll(KeyStore keyStore) throws Exception {
        Object object;
        int n = 0;
        int n2 = keyStore.size();
        Object[] objectArray = keyStore.aliases();
        while (objectArray.hasMoreElements()) {
            Object object2;
            object = objectArray.nextElement();
            int n3 = this.doImportKeyStoreSingle(keyStore, (String)object);
            if (n3 == 1) {
                ++n;
                object2 = new Object[]{object};
                MessageFormat messageFormat = new MessageFormat(rb.getString("Entry for alias <alias> successfully imported."));
                System.err.println(messageFormat.format(object2));
                continue;
            }
            if (n3 != 2 || this.noprompt || !"YES".equals(object2 = this.getYesNoReply("Do you want to quit the import process? [no]:  "))) continue;
            break;
        }
        objectArray = new Object[]{n, n2 - n};
        object = new MessageFormat(rb.getString("Import command completed:  <ok> entries successfully imported, <fail> entries failed or cancelled"));
        System.err.println(((Format)object).format(objectArray));
    }

    private void doPrintEntries(PrintStream printStream) throws Exception {
        if (this.storePass == null && !KeyStoreUtil.isWindowsKeyStore(this.storetype)) {
            this.printWarning();
        } else {
            printStream.println();
        }
        printStream.println(rb.getString("Keystore type: ") + this.keyStore.getType());
        printStream.println(rb.getString("Keystore provider: ") + this.keyStore.getProvider().getName());
        printStream.println();
        MessageFormat messageFormat = this.keyStore.size() == 1 ? new MessageFormat(rb.getString("Your keystore contains keyStore.size() entry")) : new MessageFormat(rb.getString("Your keystore contains keyStore.size() entries"));
        Object[] objectArray = new Object[]{new Integer(this.keyStore.size())};
        printStream.println(messageFormat.format(objectArray));
        printStream.println();
        Enumeration<String> enumeration = this.keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.doPrintEntry(string, printStream, false);
            if (!this.verbose && !this.rfc) continue;
            printStream.println(rb.getString("\n"));
            printStream.println(rb.getString("*******************************************"));
            printStream.println(rb.getString("*******************************************\n\n"));
        }
    }

    private void doPrintCertReq(InputStream inputStream, PrintStream printStream) throws Exception {
        Object object;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while ((object = bufferedReader.readLine()) != null) {
            if (!bl) {
                if (!((String)object).startsWith("-----")) continue;
                bl = true;
                continue;
            }
            if (((String)object).startsWith("-----")) break;
            stringBuffer.append((String)object);
        }
        object = new PKCS10(new BASE64Decoder().decodeBuffer(new String(stringBuffer)));
        PublicKey publicKey = ((PKCS10)object).getSubjectPublicKeyInfo();
        printStream.printf(rb.getString("PKCS #10 Certificate Request (Version 1.0)\nSubject: %s\nPublic Key: %s format %s key\n"), ((PKCS10)object).getSubjectName(), publicKey.getFormat(), publicKey.getAlgorithm());
        for (PKCS10Attribute pKCS10Attribute : ((PKCS10)object).getAttributes().getAttributes()) {
            ObjectIdentifier objectIdentifier = pKCS10Attribute.getAttributeId();
            if (objectIdentifier.equals(PKCS9Attribute.EXTENSION_REQUEST_OID)) {
                CertificateExtensions certificateExtensions = (CertificateExtensions)pKCS10Attribute.getAttributeValue();
                if (certificateExtensions == null) continue;
                KeyTool.printExtensions(rb.getString("Extension Request:"), certificateExtensions, printStream);
                continue;
            }
            printStream.println(pKCS10Attribute.getAttributeId());
            printStream.println(pKCS10Attribute.getAttributeValue());
        }
        if (this.debug) {
            printStream.println(object);
        }
    }

    private void printCertFromStream(InputStream inputStream, PrintStream printStream) throws Exception {
        Collection<? extends Certificate> collection = null;
        try {
            collection = this.cf.generateCertificates(inputStream);
        }
        catch (CertificateException certificateException) {
            throw new Exception(rb.getString("Failed to parse input"), certificateException);
        }
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Empty input"));
        }
        Certificate[] certificateArray = collection.toArray(new Certificate[collection.size()]);
        for (int i = 0; i < certificateArray.length; ++i) {
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = (X509Certificate)certificateArray[i];
            }
            catch (ClassCastException classCastException) {
                throw new Exception(rb.getString("Not X.509 certificate"));
            }
            if (certificateArray.length > 1) {
                MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate[(i + 1)]:"));
                Object[] objectArray = new Object[]{new Integer(i + 1)};
                printStream.println(messageFormat.format(objectArray));
            }
            if (this.rfc) {
                this.dumpCert(x509Certificate, printStream);
            } else {
                this.printX509Cert(x509Certificate, printStream);
            }
            if (i >= certificateArray.length - 1) continue;
            printStream.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrintCert(final PrintStream printStream) throws Exception {
        if (this.sslserver != null) {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            final boolean[] blArray = new boolean[1];
            sSLContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    for (int i = 0; i < x509CertificateArray.length; ++i) {
                        X509Certificate x509Certificate = x509CertificateArray[i];
                        try {
                            if (KeyTool.this.rfc) {
                                KeyTool.this.dumpCert(x509Certificate, printStream);
                                continue;
                            }
                            printStream.println("Certificate #" + i);
                            printStream.println("====================================");
                            KeyTool.this.printX509Cert(x509Certificate, printStream);
                            printStream.println();
                            continue;
                        }
                        catch (Exception exception) {
                            if (!KeyTool.this.debug) continue;
                            exception.printStackTrace();
                        }
                    }
                    if (x509CertificateArray.length > 0) {
                        blArray[0] = true;
                    }
                }
            }}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
            Exception exception = null;
            try {
                new URL("https://" + this.sslserver).openConnection().connect();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            if (!blArray[0]) {
                Exception exception3 = new Exception(rb.getString("No certificate from the SSL server"));
                if (exception != null) {
                    exception3.initCause(exception);
                }
                throw exception3;
            }
        } else {
            InputStream inputStream = System.in;
            if (this.filename != null) {
                inputStream = new FileInputStream(this.filename);
            }
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                while ((n = inputStream.read(byArray)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this.printCertFromStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), printStream);
            }
            finally {
                if (inputStream != System.in) {
                    inputStream.close();
                }
            }
        }
    }

    private void doSelfCert(String string, String string2, String string3) throws Exception {
        X500Name x500Name;
        Certificate certificate;
        if (string == null) {
            string = "mykey";
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if (string3 == null) {
            string3 = KeyTool.getCompatibleSigAlgName(privateKey.getAlgorithm());
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (!(certificate instanceof X509Certificate)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no X.509 certificate"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        byte[] byArray = certificate.getEncoded();
        X509CertImpl x509CertImpl = new X509CertImpl(byArray);
        X509CertInfo x509CertInfo = (X509CertInfo)x509CertImpl.get("x509.info");
        Date date = KeyTool.getStartDate(this.startDate);
        Date date2 = new Date();
        date2.setTime(date.getTime() + this.validity * 1000L * 24L * 60L * 60L);
        CertificateValidity certificateValidity = new CertificateValidity(date, date2);
        x509CertInfo.set("validity", certificateValidity);
        x509CertInfo.set("serialNumber", new CertificateSerialNumber(new Random().nextInt() & Integer.MAX_VALUE));
        if (string2 == null) {
            x500Name = (X500Name)x509CertInfo.get("subject.dname");
        } else {
            x500Name = new X500Name(string2);
            x509CertInfo.set("subject.dname", x500Name);
        }
        x509CertInfo.set("issuer.dname", x500Name);
        X509CertImpl x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        AlgorithmId algorithmId = (AlgorithmId)x509CertImpl2.get("x509.algorithm");
        x509CertInfo.set("algorithmID.algorithm", algorithmId);
        x509CertInfo.set("version", new CertificateVersion(2));
        CertificateExtensions certificateExtensions = this.createV3Extensions(null, (CertificateExtensions)x509CertInfo.get("extensions"), this.v3ext, certificate.getPublicKey(), null);
        x509CertInfo.set("extensions", certificateExtensions);
        x509CertImpl2 = new X509CertImpl(x509CertInfo);
        x509CertImpl2.sign(privateKey, string3);
        this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, new Certificate[]{x509CertImpl2});
        if (this.verbose) {
            System.err.println(rb.getString("New certificate (self-signed):"));
            System.err.print(x509CertImpl2.toString());
            System.err.println();
        }
    }

    private boolean installReply(String string, InputStream inputStream) throws Exception {
        Certificate certificate;
        if (string == null) {
            string = "mykey";
        }
        Pair<Key, char[]> pair = this.recoverKey(string, this.storePass, this.keyPass);
        PrivateKey privateKey = (PrivateKey)pair.fst;
        if (this.keyPass == null) {
            this.keyPass = (char[])pair.snd;
        }
        if ((certificate = this.keyStore.getCertificate(string)) == null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("alias has no public key (certificate)"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Collection<? extends Certificate> collection = this.cf.generateCertificates(inputStream);
        if (collection.isEmpty()) {
            throw new Exception(rb.getString("Reply has no certificates"));
        }
        Certificate[] certificateArray = collection.toArray(new Certificate[collection.size()]);
        Certificate[] certificateArray2 = certificateArray.length == 1 ? this.establishCertChain(certificate, certificateArray[0]) : this.validateReply(string, certificate, certificateArray);
        if (certificateArray2 != null) {
            this.keyStore.setKeyEntry(string, privateKey, this.keyPass != null ? this.keyPass : this.storePass, certificateArray2);
            return true;
        }
        return false;
    }

    private boolean addTrustedCert(String string, InputStream inputStream) throws Exception {
        Object object;
        if (string == null) {
            throw new Exception(rb.getString("Must specify alias"));
        }
        if (this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate not imported, alias <alias> already exists"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.cf.generateCertificate(inputStream);
        }
        catch (ClassCastException classCastException) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        catch (CertificateException certificateException) {
            throw new Exception(rb.getString("Input not an X.509 certificate"));
        }
        boolean bl = false;
        if (this.isSelfSigned(x509Certificate)) {
            x509Certificate.verify(x509Certificate.getPublicKey());
            bl = true;
        }
        if (this.noprompt) {
            this.keyStore.setCertificateEntry(string, x509Certificate);
            return true;
        }
        String string2 = null;
        String string3 = this.keyStore.getCertificateAlias(x509Certificate);
        if (string3 != null) {
            object = new MessageFormat(rb.getString("Certificate already exists in keystore under alias <trustalias>"));
            Object[] objectArray = new Object[]{string3};
            System.err.println(((Format)object).format(objectArray));
            string2 = this.getYesNoReply(rb.getString("Do you still want to add it? [no]:  "));
        } else if (bl) {
            if (this.trustcacerts && this.caks != null && (string3 = this.caks.getCertificateAlias(x509Certificate)) != null) {
                object = new MessageFormat(rb.getString("Certificate already exists in system-wide CA keystore under alias <trustalias>"));
                Object[] objectArray = new Object[]{string3};
                System.err.println(((Format)object).format(objectArray));
                string2 = this.getYesNoReply(rb.getString("Do you still want to add it to your own keystore? [no]:  "));
            }
            if (string3 == null) {
                this.printX509Cert(x509Certificate, System.out);
                string2 = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            }
        }
        if (string2 != null) {
            if ("YES".equals(string2)) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        try {
            object = this.establishCertChain(null, x509Certificate);
            if (object != null) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
        }
        catch (Exception exception) {
            this.printX509Cert(x509Certificate, System.out);
            string2 = this.getYesNoReply(rb.getString("Trust this certificate? [no]:  "));
            if ("YES".equals(string2)) {
                this.keyStore.setCertificateEntry(string, x509Certificate);
                return true;
            }
            return false;
        }
        return false;
    }

    private char[] getNewPasswd(String string, char[] cArray) throws Exception {
        char[] cArray2 = null;
        char[] cArray3 = null;
        for (int i = 0; i < 3; ++i) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("New prompt: "));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
            cArray2 = Password.readPassword(System.in);
            this.passwords.add(cArray2);
            if (cArray2 == null || cArray2.length < 6) {
                System.err.println(rb.getString("Password is too short - must be at least 6 characters"));
            } else if (Arrays.equals(cArray2, cArray)) {
                System.err.println(rb.getString("Passwords must differ"));
            } else {
                messageFormat = new MessageFormat(rb.getString("Re-enter new prompt: "));
                Object[] objectArray2 = new Object[]{string};
                System.err.print(messageFormat.format(objectArray2));
                cArray3 = Password.readPassword(System.in);
                this.passwords.add(cArray3);
                if (!Arrays.equals(cArray2, cArray3)) {
                    System.err.println(rb.getString("They don't match. Try again"));
                } else {
                    Arrays.fill(cArray3, ' ');
                    return cArray2;
                }
            }
            if (cArray2 != null) {
                Arrays.fill(cArray2, ' ');
                cArray2 = null;
            }
            if (cArray3 == null) continue;
            Arrays.fill(cArray3, ' ');
            cArray3 = null;
        }
        throw new Exception(rb.getString("Too many failures - try later"));
    }

    private String getAlias(String string) throws Exception {
        if (string != null) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Enter prompt alias name:  "));
            Object[] objectArray = new Object[]{string};
            System.err.print(messageFormat.format(objectArray));
        } else {
            System.err.print(rb.getString("Enter alias name:  "));
        }
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private String inputStringFromStdin(String string) throws Exception {
        System.err.print(string);
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] getKeyPasswd(String string, String string2, char[] cArray) throws Exception {
        int n = 0;
        char[] cArray2 = null;
        do {
            Object[] objectArray;
            MessageFormat messageFormat;
            if (cArray != null) {
                messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                objectArray = new Object[]{string};
                System.err.println(messageFormat.format(objectArray));
                messageFormat = new MessageFormat(rb.getString("\t(RETURN if same as for <otherAlias>)"));
                Object[] objectArray2 = new Object[]{string2};
                System.err.print(messageFormat.format(objectArray2));
            } else {
                messageFormat = new MessageFormat(rb.getString("Enter key password for <alias>"));
                objectArray = new Object[]{string};
                System.err.print(messageFormat.format(objectArray));
            }
            System.err.flush();
            cArray2 = Password.readPassword(System.in);
            this.passwords.add(cArray2);
            if (cArray2 != null) continue;
            cArray2 = cArray;
        } while (cArray2 == null && ++n < 3);
        if (cArray2 == null) {
            throw new Exception(rb.getString("Too many failures - try later"));
        }
        return cArray2;
    }

    private void printX509Cert(X509Certificate x509Certificate, PrintStream printStream) throws Exception {
        X509CertImpl x509CertImpl;
        X509CertInfo x509CertInfo;
        CertificateExtensions certificateExtensions;
        MessageFormat messageFormat = new MessageFormat(rb.getString("*PATTERN* printX509Cert"));
        Object[] objectArray = new Object[]{x509Certificate.getSubjectDN().toString(), x509Certificate.getIssuerDN().toString(), x509Certificate.getSerialNumber().toString(16), x509Certificate.getNotBefore().toString(), x509Certificate.getNotAfter().toString(), this.getCertFingerPrint("MD5", x509Certificate), this.getCertFingerPrint("SHA1", x509Certificate), this.getCertFingerPrint("SHA-256", x509Certificate), x509Certificate.getSigAlgName(), x509Certificate.getVersion()};
        printStream.println(messageFormat.format(objectArray));
        if (x509Certificate instanceof X509CertImpl && (certificateExtensions = (CertificateExtensions)(x509CertInfo = (X509CertInfo)(x509CertImpl = (X509CertImpl)x509Certificate).get("x509.info")).get("extensions")) != null) {
            KeyTool.printExtensions(rb.getString("Extensions: "), certificateExtensions, printStream);
        }
    }

    private static void printExtensions(String string, CertificateExtensions certificateExtensions, PrintStream printStream) throws Exception {
        int n = 0;
        Iterator<Extension> iterator = certificateExtensions.getAllExtensions().iterator();
        Iterator<Extension> iterator2 = certificateExtensions.getUnparseableExtensions().values().iterator();
        while (iterator.hasNext() || iterator2.hasNext()) {
            Extension extension;
            Extension extension2 = extension = iterator.hasNext() ? iterator.next() : iterator2.next();
            if (n == 0) {
                printStream.println();
                printStream.println(string);
                printStream.println();
            }
            printStream.print("#" + ++n + ": " + extension);
            if (extension.getClass() == Extension.class) {
                byte[] byArray = extension.getExtensionValue();
                if (byArray.length == 0) {
                    printStream.println(rb.getString("(Empty value)"));
                } else {
                    new HexDumpEncoder().encode(extension.getExtensionValue(), (OutputStream)printStream);
                    printStream.println();
                }
            }
            printStream.println();
        }
    }

    private boolean isSelfSigned(X509Certificate x509Certificate) {
        return this.signedBy(x509Certificate, x509Certificate);
    }

    private boolean signedBy(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (!x509Certificate2.getSubjectDN().equals(x509Certificate.getIssuerDN())) {
            return false;
        }
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isTrusted(Certificate certificate) throws Exception {
        if (this.keyStore.getCertificateAlias(certificate) != null) {
            return true;
        }
        return this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(certificate) != null;
    }

    private X500Name getX500Name() throws IOException {
        X500Name x500Name;
        Object[] objectArray;
        MessageFormat messageFormat;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "Unknown";
        String string2 = "Unknown";
        String string3 = "Unknown";
        String string4 = "Unknown";
        String string5 = "Unknown";
        String string6 = "Unknown";
        String string7 = null;
        int n = 20;
        do {
            if (n-- < 0) {
                throw new RuntimeException(rb.getString("Too may retries, program terminated"));
            }
            string = this.inputString(bufferedReader, rb.getString("What is your first and last name?"), string);
            string2 = this.inputString(bufferedReader, rb.getString("What is the name of your organizational unit?"), string2);
            string3 = this.inputString(bufferedReader, rb.getString("What is the name of your organization?"), string3);
            string4 = this.inputString(bufferedReader, rb.getString("What is the name of your City or Locality?"), string4);
            string5 = this.inputString(bufferedReader, rb.getString("What is the name of your State or Province?"), string5);
            string6 = this.inputString(bufferedReader, rb.getString("What is the two-letter country code for this unit?"), string6);
            x500Name = new X500Name(string, string2, string3, string4, string5, string6);
        } while (collator.compare(string7 = this.inputString(bufferedReader, (messageFormat = new MessageFormat(rb.getString("Is <name> correct?"))).format(objectArray = new Object[]{x500Name}), rb.getString("no")), rb.getString("yes")) != 0 && collator.compare(string7, rb.getString("y")) != 0);
        System.err.println();
        return x500Name;
    }

    private String inputString(BufferedReader bufferedReader, String string, String string2) throws IOException {
        System.err.println(string);
        MessageFormat messageFormat = new MessageFormat(rb.getString("  [defaultValue]:  "));
        Object[] objectArray = new Object[]{string2};
        System.err.print(messageFormat.format(objectArray));
        System.err.flush();
        String string3 = bufferedReader.readLine();
        if (string3 == null || collator.compare(string3, "") == 0) {
            string3 = string2;
        }
        return string3;
    }

    private void dumpCert(Certificate certificate, PrintStream printStream) throws IOException, CertificateException {
        if (this.rfc) {
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            printStream.println("-----BEGIN CERTIFICATE-----");
            bASE64Encoder.encodeBuffer(certificate.getEncoded(), (OutputStream)printStream);
            printStream.println("-----END CERTIFICATE-----");
        } else {
            printStream.write(certificate.getEncoded());
        }
    }

    private void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            this.byte2hex(byArray[i], stringBuffer);
            if (i >= n - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    private Pair<Key, char[]> recoverKey(String string, char[] cArray, char[] cArray2) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (!this.keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(string, KeyStore.SecretKeyEntry.class)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> has no key"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        if (cArray2 == null) {
            try {
                key = this.keyStore.getKey(string, cArray);
                cArray2 = cArray;
                this.passwords.add(cArray2);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                if (!this.token) {
                    cArray2 = this.getKeyPasswd(string, null, null);
                    key = this.keyStore.getKey(string, cArray2);
                }
                throw unrecoverableKeyException;
            }
        } else {
            key = this.keyStore.getKey(string, cArray2);
        }
        return Pair.of(key, cArray2);
    }

    private Pair<KeyStore.Entry, char[]> recoverEntry(KeyStore keyStore, String string, char[] cArray, char[] cArray2) throws Exception {
        KeyStore.Entry entry;
        if (!keyStore.containsAlias(string)) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Alias <alias> does not exist"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        KeyStore.PasswordProtection passwordProtection = null;
        try {
            entry = keyStore.getEntry(string, passwordProtection);
            cArray2 = null;
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            if (P11KEYSTORE.equalsIgnoreCase(keyStore.getType()) || KeyStoreUtil.isWindowsKeyStore(keyStore.getType())) {
                throw unrecoverableEntryException;
            }
            if (cArray2 != null) {
                passwordProtection = new KeyStore.PasswordProtection(cArray2);
                entry = keyStore.getEntry(string, passwordProtection);
            }
            try {
                passwordProtection = new KeyStore.PasswordProtection(cArray);
                entry = keyStore.getEntry(string, passwordProtection);
                cArray2 = cArray;
            }
            catch (UnrecoverableEntryException unrecoverableEntryException2) {
                if (P12KEYSTORE.equalsIgnoreCase(keyStore.getType())) {
                    throw unrecoverableEntryException2;
                }
                cArray2 = this.getKeyPasswd(string, null, null);
                passwordProtection = new KeyStore.PasswordProtection(cArray2);
                entry = keyStore.getEntry(string, passwordProtection);
            }
        }
        return Pair.of(entry, cArray2);
    }

    private String getCertFingerPrint(String string, Certificate certificate) throws Exception {
        byte[] byArray = certificate.getEncoded();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        byte[] byArray2 = messageDigest.digest(byArray);
        return this.toHexString(byArray2);
    }

    private void printWarning() {
        System.err.println();
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println(rb.getString("* The integrity of the information stored in your keystore  *"));
        System.err.println(rb.getString("* has NOT been verified!  In order to verify its integrity, *"));
        System.err.println(rb.getString("* you must provide your keystore password.                  *"));
        System.err.println(rb.getString("*****************  WARNING WARNING WARNING  *****************"));
        System.err.println();
    }

    private Certificate[] validateReply(String string, Certificate certificate, Certificate[] certificateArray) throws Exception {
        int n;
        PublicKey publicKey = certificate.getPublicKey();
        for (n = 0; n < certificateArray.length && !publicKey.equals(certificateArray[n].getPublicKey()); ++n) {
        }
        if (n == certificateArray.length) {
            MessageFormat messageFormat = new MessageFormat(rb.getString("Certificate reply does not contain public key for <alias>"));
            Object[] objectArray = new Object[]{string};
            throw new Exception(messageFormat.format(objectArray));
        }
        Certificate certificate2 = certificateArray[0];
        certificateArray[0] = certificateArray[n];
        certificateArray[n] = certificate2;
        X509Certificate x509Certificate = (X509Certificate)certificateArray[0];
        for (n = 1; n < certificateArray.length - 1; ++n) {
            int n2;
            for (n2 = n; n2 < certificateArray.length; ++n2) {
                if (!this.signedBy(x509Certificate, (X509Certificate)certificateArray[n2])) continue;
                certificate2 = certificateArray[n];
                certificateArray[n] = certificateArray[n2];
                certificateArray[n2] = certificate2;
                x509Certificate = (X509Certificate)certificateArray[n];
                break;
            }
            if (n2 != certificateArray.length) continue;
            throw new Exception(rb.getString("Incomplete certificate chain in reply"));
        }
        if (this.noprompt) {
            return certificateArray;
        }
        Certificate certificate3 = certificateArray[certificateArray.length - 1];
        if (!this.isTrusted(certificate3)) {
            Object object;
            boolean bl = false;
            Certificate certificate4 = null;
            if (this.trustcacerts && this.caks != null) {
                object = this.caks.aliases();
                while (object.hasMoreElements()) {
                    String string2 = object.nextElement();
                    certificate4 = this.caks.getCertificate(string2);
                    if (certificate4 == null) continue;
                    try {
                        certificate3.verify(certificate4.getPublicKey());
                        bl = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (!bl) {
                System.err.println();
                System.err.println(rb.getString("Top-level certificate in reply:\n"));
                this.printX509Cert((X509Certificate)certificate3, System.out);
                System.err.println();
                System.err.print(rb.getString("... is not trusted. "));
                object = this.getYesNoReply(rb.getString("Install reply anyway? [no]:  "));
                if ("NO".equals(object)) {
                    return null;
                }
            } else if (!this.isSelfSigned((X509Certificate)certificate3)) {
                object = new Certificate[certificateArray.length + 1];
                System.arraycopy(certificateArray, 0, object, 0, certificateArray.length);
                object[((Certificate[])object).length - 1] = certificate4;
                certificateArray = object;
            }
        }
        return certificateArray;
    }

    private Certificate[] establishCertChain(Certificate certificate, Certificate certificate2) throws Exception {
        Serializable serializable;
        Serializable serializable2;
        if (certificate != null) {
            serializable2 = certificate.getPublicKey();
            if (!serializable2.equals(serializable = certificate2.getPublicKey())) {
                throw new Exception(rb.getString("Public keys in reply and keystore don't match"));
            }
            if (certificate2.equals(certificate)) {
                throw new Exception(rb.getString("Certificate reply and certificate in keystore are identical"));
            }
        }
        serializable2 = null;
        if (this.keyStore.size() > 0) {
            serializable2 = new Hashtable(11);
            this.keystorecerts2Hashtable(this.keyStore, (Hashtable<Principal, Vector<Certificate>>)serializable2);
        }
        if (this.trustcacerts && this.caks != null && this.caks.size() > 0) {
            if (serializable2 == null) {
                serializable2 = new Hashtable(11);
            }
            this.keystorecerts2Hashtable(this.caks, (Hashtable<Principal, Vector<Certificate>>)serializable2);
        }
        if (this.buildChain((X509Certificate)certificate2, (Vector<Certificate>)(serializable = new Vector(2)), (Hashtable<Principal, Vector<Certificate>>)serializable2)) {
            Certificate[] certificateArray = new Certificate[((Vector)serializable).size()];
            int n = 0;
            for (int i = ((Vector)serializable).size() - 1; i >= 0; --i) {
                certificateArray[n] = (Certificate)((Vector)serializable).elementAt(i);
                ++n;
            }
            return certificateArray;
        }
        throw new Exception(rb.getString("Failed to establish chain from reply"));
    }

    private boolean buildChain(X509Certificate x509Certificate, Vector<Certificate> vector, Hashtable<Principal, Vector<Certificate>> hashtable) {
        Principal principal = x509Certificate.getIssuerDN();
        if (this.isSelfSigned(x509Certificate)) {
            vector.addElement(x509Certificate);
            return true;
        }
        Vector<Certificate> vector2 = hashtable.get(principal);
        if (vector2 == null) {
            return false;
        }
        Enumeration<Certificate> enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate2 = (X509Certificate)enumeration.nextElement();
            PublicKey publicKey = x509Certificate2.getPublicKey();
            try {
                x509Certificate.verify(publicKey);
            }
            catch (Exception exception) {
                continue;
            }
            if (!this.buildChain(x509Certificate2, vector, hashtable)) continue;
            vector.addElement(x509Certificate);
            return true;
        }
        return false;
    }

    private String getYesNoReply(String string) throws IOException {
        String string2 = null;
        int n = 20;
        do {
            if (n-- < 0) {
                throw new RuntimeException(rb.getString("Too may retries, program terminated"));
            }
            System.err.print(string);
            System.err.flush();
            string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
            if (collator.compare(string2, "") == 0 || collator.compare(string2, rb.getString("n")) == 0 || collator.compare(string2, rb.getString("no")) == 0) {
                string2 = "NO";
                continue;
            }
            if (collator.compare(string2, rb.getString("y")) == 0 || collator.compare(string2, rb.getString("yes")) == 0) {
                string2 = "YES";
                continue;
            }
            System.err.println(rb.getString("Wrong answer, try again"));
            string2 = null;
        } while (string2 == null);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        String string = File.separator;
        File file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + "cacerts");
        if (!file.exists()) {
            return null;
        }
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            keyStore = KeyStore.getInstance(JKS);
            keyStore.load(fileInputStream, null);
        }
        return keyStore;
    }

    private void keystorecerts2Hashtable(KeyStore keyStore, Hashtable<Principal, Vector<Certificate>> hashtable) throws Exception {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) continue;
            Principal principal = ((X509Certificate)certificate).getSubjectDN();
            Vector<Certificate> vector = hashtable.get(principal);
            if (vector == null) {
                vector = new Vector();
                vector.addElement(certificate);
            } else if (!vector.contains(certificate)) {
                vector.addElement(certificate);
            }
            hashtable.put(principal, vector);
        }
    }

    private static Date getStartDate(String string) throws IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        if (string != null) {
            IOException iOException = new IOException(rb.getString("Illegal startdate value"));
            int n = string.length();
            if (n == 0) {
                throw iOException;
            }
            if (string.charAt(0) == '-' || string.charAt(0) == '+') {
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    int n4;
                    int n5 = 0;
                    switch (string.charAt(n2)) {
                        case '+': {
                            n5 = 1;
                            break;
                        }
                        case '-': {
                            n5 = -1;
                            break;
                        }
                        default: {
                            throw iOException;
                        }
                    }
                    for (n4 = n2 + 1; n4 < n && (n3 = string.charAt(n4)) >= 48 && n3 <= 57; ++n4) {
                    }
                    if (n4 == n2 + 1) {
                        throw iOException;
                    }
                    n3 = Integer.parseInt(string.substring(n2 + 1, n4));
                    if (n4 >= n) {
                        throw iOException;
                    }
                    int n6 = 0;
                    switch (string.charAt(n4)) {
                        case 'y': {
                            n6 = 1;
                            break;
                        }
                        case 'm': {
                            n6 = 2;
                            break;
                        }
                        case 'd': {
                            n6 = 5;
                            break;
                        }
                        case 'H': {
                            n6 = 10;
                            break;
                        }
                        case 'M': {
                            n6 = 12;
                            break;
                        }
                        case 'S': {
                            n6 = 13;
                            break;
                        }
                        default: {
                            throw iOException;
                        }
                    }
                    ((Calendar)gregorianCalendar).add(n6, n5 * n3);
                    n2 = n4 + 1;
                }
            } else {
                String string2 = null;
                String string3 = null;
                if (n == 19) {
                    string2 = string.substring(0, 10);
                    string3 = string.substring(11);
                    if (string.charAt(10) != ' ') {
                        throw iOException;
                    }
                } else if (n == 10) {
                    string2 = string;
                } else if (n == 8) {
                    string3 = string;
                } else {
                    throw iOException;
                }
                if (string2 != null) {
                    if (string2.matches("\\d\\d\\d\\d\\/\\d\\d\\/\\d\\d")) {
                        gregorianCalendar.set(Integer.valueOf(string2.substring(0, 4)), Integer.valueOf(string2.substring(5, 7)) - 1, Integer.valueOf(string2.substring(8, 10)));
                    } else {
                        throw iOException;
                    }
                }
                if (string3 != null) {
                    if (string3.matches("\\d\\d:\\d\\d:\\d\\d")) {
                        gregorianCalendar.set(11, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(12, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(13, Integer.valueOf(string3.substring(0, 2)));
                        gregorianCalendar.set(14, 0);
                    } else {
                        throw iOException;
                    }
                }
            }
        }
        return gregorianCalendar.getTime();
    }

    private static int oneOf(String string, String ... stringArray) throws Exception {
        int n;
        Object[] objectArray;
        Object object;
        int[] nArray = new int[stringArray.length];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            if (((String)object).toLowerCase().startsWith(string.toLowerCase())) {
                nArray[n2++] = i;
                continue;
            }
            objectArray = new StringBuffer();
            n = 1;
            for (char c : ((String)object).toCharArray()) {
                if (n != 0) {
                    objectArray.append(c);
                    n = 0;
                    continue;
                }
                if (Character.isLowerCase(c)) continue;
                objectArray.append(c);
            }
            if (!objectArray.toString().equalsIgnoreCase(string)) continue;
            nArray[n2++] = i;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return nArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer();
        object = new MessageFormat(rb.getString("command {0} is ambiguous:"));
        objectArray = new Object[]{string};
        stringBuffer.append(((Format)object).format(objectArray) + "\n    ");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append(" " + stringArray[nArray[n]]);
        }
        throw new Exception(stringBuffer.toString());
    }

    private GeneralName createGeneralName(String string, String string2) throws Exception {
        GeneralNameInterface generalNameInterface;
        int n = KeyTool.oneOf(string, "EMAIL", "URI", "DNS", "IP", "OID");
        if (n < 0) {
            throw new Exception(rb.getString("Unrecognized GeneralName type: ") + string);
        }
        switch (n) {
            case 0: {
                generalNameInterface = new RFC822Name(string2);
                break;
            }
            case 1: {
                generalNameInterface = new URIName(string2);
                break;
            }
            case 2: {
                generalNameInterface = new DNSName(string2);
                break;
            }
            case 3: {
                generalNameInterface = new IPAddressName(string2);
                break;
            }
            default: {
                generalNameInterface = new OIDName(string2);
            }
        }
        return new GeneralName(generalNameInterface);
    }

    private ObjectIdentifier findOidForExtName(String string) throws Exception {
        switch (KeyTool.oneOf(string, extSupported)) {
            case 0: {
                return PKIXExtensions.BasicConstraints_Id;
            }
            case 1: {
                return PKIXExtensions.KeyUsage_Id;
            }
            case 2: {
                return PKIXExtensions.ExtendedKeyUsage_Id;
            }
            case 3: {
                return PKIXExtensions.SubjectAlternativeName_Id;
            }
            case 4: {
                return PKIXExtensions.IssuerAlternativeName_Id;
            }
            case 5: {
                return PKIXExtensions.SubjectInfoAccess_Id;
            }
            case 6: {
                return PKIXExtensions.AuthInfoAccess_Id;
            }
        }
        return new ObjectIdentifier(string);
    }

    private CertificateExtensions createV3Extensions(CertificateExtensions certificateExtensions, CertificateExtensions certificateExtensions2, List<String> list, PublicKey publicKey, PublicKey publicKey2) throws Exception {
        if (certificateExtensions2 != null && certificateExtensions != null) {
            throw new Exception("One of request and original should be null.");
        }
        if (certificateExtensions2 == null) {
            certificateExtensions2 = new CertificateExtensions();
        }
        try {
            int n;
            int n2;
            List<String> list2;
            if (certificateExtensions != null) {
                for (String string : list) {
                    if (!string.toLowerCase().startsWith("honored=")) continue;
                    list2 = Arrays.asList(string.toLowerCase().substring(8).split(","));
                    if (list2.contains("all")) {
                        certificateExtensions2 = certificateExtensions;
                    }
                    for (String string2 : list2) {
                        if (string2.equals("all")) continue;
                        n2 = 1;
                        n = -1;
                        String string3 = null;
                        if (string2.startsWith("-")) {
                            n2 = 0;
                            string3 = string2.substring(1);
                        } else {
                            int n3 = string2.indexOf(58);
                            if (n3 >= 0) {
                                string3 = string2.substring(0, n3);
                                n = KeyTool.oneOf(string2.substring(n3 + 1), "critical", "non-critical");
                                if (n == -1) {
                                    throw new Exception(rb.getString("Illegal value: ") + string2);
                                }
                            }
                        }
                        String string4 = certificateExtensions.getNameByOid(this.findOidForExtName(string3));
                        if (n2 != 0) {
                            Extension extension = (Extension)certificateExtensions.get(string4);
                            if ((extension.isCritical() || n != 0) && (!extension.isCritical() || n != 1)) continue;
                            extension = Extension.newExtension(extension.getExtensionId(), !extension.isCritical(), extension.getExtensionValue());
                            certificateExtensions2.set(string4, extension);
                            continue;
                        }
                        certificateExtensions2.delete(string4);
                    }
                }
            }
            for (String string : list) {
                Object object;
                boolean bl = false;
                n2 = string.indexOf(61);
                if (n2 >= 0) {
                    list2 = string.substring(0, n2);
                    object = string.substring(n2 + 1);
                } else {
                    list2 = string;
                    object = null;
                }
                n = ((String)((Object)list2)).indexOf(58);
                if (n >= 0) {
                    if (KeyTool.oneOf(((String)((Object)list2)).substring(n + 1), "critical") == 0) {
                        bl = true;
                    }
                    list2 = ((String)((Object)list2)).substring(0, n);
                }
                if (((String)((Object)list2)).equalsIgnoreCase("honored")) continue;
                int n4 = KeyTool.oneOf((String)((Object)list2), extSupported);
                switch (n4) {
                    case 0: {
                        int n5 = -1;
                        boolean bl2 = false;
                        if (object == null) {
                            bl2 = true;
                        } else {
                            try {
                                n5 = Integer.parseInt((String)object);
                                bl2 = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                for (String string5 : ((String)object).split(",")) {
                                    String[] stringArray = string5.split(":");
                                    if (stringArray.length != 2) {
                                        throw new Exception(rb.getString("Illegal value: ") + string);
                                    }
                                    if (stringArray[0].equalsIgnoreCase("ca")) {
                                        bl2 = Boolean.parseBoolean(stringArray[1]);
                                        continue;
                                    }
                                    if (stringArray[0].equalsIgnoreCase("pathlen")) {
                                        n5 = Integer.parseInt(stringArray[1]);
                                        continue;
                                    }
                                    throw new Exception(rb.getString("Illegal value: ") + string);
                                }
                            }
                        }
                        certificateExtensions2.set("BasicConstraints", new BasicConstraintsExtension(bl, bl2, n5));
                        break;
                    }
                    case 1: {
                        Object object2;
                        Object object3;
                        if (object != null) {
                            object3 = new boolean[9];
                            for (String string6 : ((String)object).split(",")) {
                                int n6 = KeyTool.oneOf(string6, "digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly", "contentCommitment");
                                if (n6 < 0) {
                                    throw new Exception(rb.getString("Unknown keyUsage type: ") + string6);
                                }
                                if (n6 == 9) {
                                    n6 = 1;
                                }
                                object3[n6] = true;
                            }
                            object2 = new KeyUsageExtension((boolean[])object3);
                            certificateExtensions2.set("KeyUsage", Extension.newExtension(((Extension)object2).getExtensionId(), bl, ((Extension)object2).getExtensionValue()));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal value: ") + string);
                    }
                    case 2: {
                        Object object3;
                        if (object != null) {
                            object3 = new Vector();
                            for (String string7 : ((String)object).split(",")) {
                                int n7 = KeyTool.oneOf(string7, "anyExtendedKeyUsage", "serverAuth", "clientAuth", "codeSigning", "emailProtection", "", "", "", "timeStamping", "OCSPSigning");
                                if (n7 < 0) {
                                    try {
                                        ((Vector)object3).add(new ObjectIdentifier(string7));
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        throw new Exception(rb.getString("Unknown extendedkeyUsage type: ") + string7);
                                    }
                                }
                                if (n7 == 0) {
                                    ((Vector)object3).add(new ObjectIdentifier("2.5.29.37.0"));
                                    continue;
                                }
                                ((Vector)object3).add(new ObjectIdentifier("1.3.6.1.5.5.7.3." + n7));
                            }
                            certificateExtensions2.set("ExtendedKeyUsage", new ExtendedKeyUsageExtension((Boolean)bl, (Vector<ObjectIdentifier>)object3));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal value: ") + string);
                    }
                    case 3: 
                    case 4: {
                        String string8;
                        int n8;
                        Object object2;
                        Object object3;
                        if (object != null) {
                            object3 = ((String)object).split(",");
                            object2 = new GeneralNames();
                            Object object4 = object3;
                            int n9 = ((boolean[])object4).length;
                            for (n8 = 0; n8 < n9; ++n8) {
                                Object object5 = object4[n8];
                                n = ((String)object5).indexOf(58);
                                if (n < 0) {
                                    throw new Exception("Illegal item " + (String)object5 + " in " + string);
                                }
                                String string9 = ((String)object5).substring(0, n);
                                string8 = ((String)object5).substring(n + 1);
                                ((GeneralNames)object2).add(this.createGeneralName(string9, string8));
                            }
                            if (n4 == 3) {
                                certificateExtensions2.set("SubjectAlternativeName", new SubjectAlternativeNameExtension((Boolean)bl, (GeneralNames)object2));
                                break;
                            }
                            certificateExtensions2.set("IssuerAlternativeName", new IssuerAlternativeNameExtension((Boolean)bl, (GeneralNames)object2));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal value: ") + string);
                    }
                    case 5: 
                    case 6: {
                        String string8;
                        int n8;
                        Object object2;
                        Object object3;
                        if (bl) {
                            throw new Exception(rb.getString("This extension cannot be marked as critical. ") + string);
                        }
                        if (object != null) {
                            object3 = new ArrayList();
                            object2 = ((String)object).split(",");
                            Object object6 = object2;
                            int n10 = ((String[])object6).length;
                            for (n8 = 0; n8 < n10; ++n8) {
                                ObjectIdentifier objectIdentifier;
                                String string10 = object6[n8];
                                n = string10.indexOf(58);
                                int n11 = string10.indexOf(58, n + 1);
                                if (n < 0 || n11 < 0) {
                                    throw new Exception(rb.getString("Illegal value: ") + string);
                                }
                                string8 = string10.substring(0, n);
                                String string11 = string10.substring(n + 1, n11);
                                String string12 = string10.substring(n11 + 1);
                                int n12 = KeyTool.oneOf(string8, "", "ocsp", "caIssuers", "timeStamping", "", "caRepository");
                                if (n12 < 0) {
                                    try {
                                        objectIdentifier = new ObjectIdentifier(string8);
                                    }
                                    catch (Exception exception) {
                                        throw new Exception(rb.getString("Unknown AccessDescription type: ") + string8);
                                    }
                                } else {
                                    objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48." + n12);
                                }
                                object3.add(new AccessDescription(objectIdentifier, this.createGeneralName(string11, string12)));
                            }
                            if (n4 == 5) {
                                certificateExtensions2.set("SubjectInfoAccess", new SubjectInfoAccessExtension((List<AccessDescription>)object3));
                                break;
                            }
                            certificateExtensions2.set("AuthorityInfoAccess", new AuthorityInfoAccessExtension((List<AccessDescription>)object3));
                            break;
                        }
                        throw new Exception(rb.getString("Illegal value: ") + string);
                    }
                    case -1: {
                        int n8;
                        Object object3 = new ObjectIdentifier((String)((Object)list2));
                        Object object2 = null;
                        if (object != null) {
                            object2 = new byte[((String)object).length() / 2 + 1];
                            int n13 = 0;
                            char[] cArray = ((String)object).toCharArray();
                            n8 = cArray.length;
                            for (int i = 0; i < n8; ++i) {
                                int n14;
                                char c = cArray[i];
                                if (c >= '0' && c <= '9') {
                                    n14 = c - 48;
                                } else if (c >= 'A' && c <= 'F') {
                                    n14 = c - 65 + 10;
                                } else {
                                    if (c < 'a' || c > 'f') continue;
                                    n14 = c - 97 + 10;
                                }
                                if (n13 % 2 == 0) {
                                    object2[n13 / 2] = (byte)(n14 << 4);
                                } else {
                                    Object object7 = object2;
                                    int n15 = n13 / 2;
                                    object7[n15] = (byte)(object7[n15] + n14);
                                }
                                ++n13;
                            }
                            if (n13 % 2 != 0) {
                                throw new Exception(rb.getString("Odd number of hex digits found: ") + string);
                            }
                            object2 = Arrays.copyOf((byte[])object2, n13 / 2);
                        } else {
                            object2 = new byte[0];
                        }
                        certificateExtensions2.set(((ObjectIdentifier)object3).toString(), new Extension((ObjectIdentifier)object3, bl, new DerValue(4, (byte[])object2).toByteArray()));
                    }
                }
            }
            certificateExtensions2.set("SubjectKeyIdentifier", new SubjectKeyIdentifierExtension(new KeyIdentifier(publicKey).getIdentifier()));
            if (publicKey2 != null && !publicKey.equals(publicKey2)) {
                certificateExtensions2.set("AuthorityKeyIdentifier", new AuthorityKeyIdentifierExtension(new KeyIdentifier(publicKey2), null, null));
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return certificateExtensions2;
    }

    private void usage() {
        System.err.println(rb.getString("keytool usage:\n"));
        System.err.println(rb.getString("-certreq     [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-dname <dname>]"));
        System.err.println(rb.getString("\t     [-file <csr_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-changealias [-v] [-protected] -alias <alias> -destalias <destalias>"));
        System.err.println(rb.getString("\t     [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-delete      [-v] [-protected] -alias <alias>"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-exportcert  [-v] [-rfc] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-file <cert_file>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-genkeypair  [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-sigalg <sigalg>] [-dname <dname>]"));
        System.err.println(rb.getString("\t     [-startdate <startdate>]"));
        System.err.println(rb.getString("\t     [-ext <key>[:critical][=<value>]]..."));
        System.err.println(rb.getString("\t     [-validity <valDays>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-gencert     [-v] [-rfc] [-protected]"));
        System.err.println(rb.getString("\t     [-infile <infile>] [-outfile <outfile>]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-dname <dname>]"));
        System.err.println(rb.getString("\t     [-sigalg <sigalg>]"));
        System.err.println(rb.getString("\t     [-startdate <startdate>]"));
        System.err.println(rb.getString("\t     [-ext <key>[:critical][=<value>]]..."));
        System.err.println(rb.getString("\t     [-validity <valDays>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-genseckey   [-v] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keyalg <keyalg>] [-keysize <keysize>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-help"));
        System.err.println();
        System.err.println(rb.getString("-importcert  [-v] [-noprompt] [-trustcacerts] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-file <cert_file>] [-keypass <keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-importkeystore [-v] "));
        System.err.println(rb.getString("\t     [-srckeystore <srckeystore>] [-destkeystore <destkeystore>]"));
        System.err.println(rb.getString("\t     [-srcstoretype <srcstoretype>] [-deststoretype <deststoretype>]"));
        System.err.println(rb.getString("\t     [-srcstorepass <srcstorepass>] [-deststorepass <deststorepass>]"));
        System.err.println(rb.getString("\t     [-srcprotected] [-destprotected]"));
        System.err.println(rb.getString("\t     [-srcprovidername <srcprovidername>]\n\t     [-destprovidername <destprovidername>]"));
        System.err.println(rb.getString("\t     [-srcalias <srcalias> [-destalias <destalias>]"));
        System.err.println(rb.getString("\t       [-srckeypass <srckeypass>] [-destkeypass <destkeypass>]]"));
        System.err.println(rb.getString("\t     [-noprompt]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-keypasswd   [-v] [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keypass <old_keypass>] [-new <new_keypass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-list        [-v | -rfc] [-protected]"));
        System.err.println(rb.getString("\t     [-alias <alias>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
        System.err.println();
        System.err.println(rb.getString("-printcert   [-v] [-rfc] [-file <cert_file> | -sslserver <host[:port]>]"));
        System.err.println();
        System.err.println(rb.getString("-printcertreq   [-v] [-file <cert_file>]"));
        System.err.println();
        System.err.println(rb.getString("-storepasswd [-v] [-new <new_storepass>]"));
        System.err.println(rb.getString("\t     [-keystore <keystore>] [-storepass <storepass>]"));
        System.err.println(rb.getString("\t     [-storetype <storetype>] [-providername <name>]"));
        System.err.println(rb.getString("\t     [-providerclass <provider_class_name> [-providerarg <arg>]] ..."));
        System.err.println(rb.getString("\t     [-providerpath <pathlist>]"));
    }

    private void tinyHelp() {
        System.err.println(rb.getString("Try keytool -help"));
        if (this.debug) {
            throw new RuntimeException("NO BIG ERROR, SORRY");
        }
        System.exit(1);
    }

    private void errorNeedArgument(String string) {
        Object[] objectArray = new Object[]{string};
        System.err.println(new MessageFormat(rb.getString("Command option <flag> needs an argument.")).format(objectArray));
        this.tinyHelp();
    }

    static {
        collator.setStrength(0);
        extSupported = new String[]{"BasicConstraints", "KeyUsage", "ExtendedKeyUsage", "SubjectAlternativeName", "IssuerAlternativeName", "SubjectInfoAccess", "AuthorityInfoAccess"};
    }
}

