/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;
import sun.security.jgss.GSSHeader;
import sun.security.jgss.krb5.CipherHelper;
import sun.security.jgss.krb5.Krb5Context;
import sun.security.jgss.krb5.MessageToken;
import sun.security.krb5.Confounder;

class WrapToken
extends MessageToken {
    static final int CONFOUNDER_SIZE = 8;
    static final byte[][] pads = new byte[][]{null, {1}, {2, 2}, {3, 3, 3}, {4, 4, 4, 4}, {5, 5, 5, 5, 5}, {6, 6, 6, 6, 6, 6}, {7, 7, 7, 7, 7, 7, 7}, {8, 8, 8, 8, 8, 8, 8, 8}};
    private boolean readTokenFromInputStream = true;
    private InputStream is = null;
    private byte[] tokenBytes = null;
    private int tokenOffset = 0;
    private int tokenLen = 0;
    private byte[] dataBytes = null;
    private int dataOffset = 0;
    private int dataLen = 0;
    private int dataSize = 0;
    byte[] confounder = null;
    byte[] padding = null;
    private boolean privacy = false;

    public WrapToken(Krb5Context krb5Context, byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        super(513, krb5Context, byArray, n, n2, messageProp);
        this.readTokenFromInputStream = false;
        this.tokenBytes = byArray;
        this.tokenOffset = n;
        this.tokenLen = n2;
        this.privacy = messageProp.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - this.getKrb5TokenSize();
    }

    public WrapToken(Krb5Context krb5Context, InputStream inputStream, MessageProp messageProp) throws GSSException {
        super(513, krb5Context, inputStream, messageProp);
        this.is = inputStream;
        this.privacy = messageProp.getPrivacy();
        this.dataSize = this.getGSSHeader().getMechTokenLength() - this.getTokenSize();
    }

    public byte[] getData() throws GSSException {
        byte[] byArray = new byte[this.dataSize];
        this.getData(byArray, 0);
        byte[] byArray2 = new byte[this.dataSize - this.confounder.length - this.padding.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public int getData(byte[] byArray, int n) throws GSSException {
        if (this.readTokenFromInputStream) {
            this.getDataFromStream(byArray, n);
        } else {
            this.getDataFromBuffer(byArray, n);
        }
        return this.dataSize - this.confounder.length - this.padding.length;
    }

    private void getDataFromBuffer(byte[] byArray, int n) throws GSSException {
        GSSHeader gSSHeader = this.getGSSHeader();
        int n2 = this.tokenOffset + gSSHeader.getLength() + this.getTokenSize();
        if (n2 + this.dataSize > this.tokenOffset + this.tokenLen) {
            throw new GSSException(10, -1, "Insufficient data in " + WrapToken.getTokenName(this.getTokenId()));
        }
        this.confounder = new byte[8];
        if (this.privacy) {
            this.cipherHelper.decryptData(this, this.tokenBytes, n2, this.dataSize, byArray, n);
        } else {
            System.arraycopy(this.tokenBytes, n2, this.confounder, 0, 8);
            int n3 = this.tokenBytes[n2 + this.dataSize - 1];
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > 8) {
                n3 %= 8;
            }
            this.padding = pads[n3];
            System.arraycopy(this.tokenBytes, n2 + 8, byArray, n, this.dataSize - 8 - n3);
        }
        if (!this.verifySignAndSeqNumber(this.confounder, byArray, n, this.dataSize - 8 - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private void getDataFromStream(byte[] byArray, int n) throws GSSException {
        GSSHeader gSSHeader = this.getGSSHeader();
        this.confounder = new byte[8];
        try {
            if (this.privacy) {
                this.cipherHelper.decryptData(this, this.is, this.dataSize, byArray, n);
            } else {
                WrapToken.readFully(this.is, this.confounder);
                int n2 = (this.dataSize - 8) / 8 - 1;
                int n3 = n;
                for (int i = 0; i < n2; ++i) {
                    WrapToken.readFully(this.is, byArray, n3, 8);
                    n3 += 8;
                }
                byte[] byArray2 = new byte[8];
                WrapToken.readFully(this.is, byArray2);
                byte by = byArray2[7];
                this.padding = pads[by];
                System.arraycopy(byArray2, 0, byArray, n3, byArray2.length - by);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(10, -1, WrapToken.getTokenName(this.getTokenId()) + ": " + iOException.getMessage());
        }
        if (!this.verifySignAndSeqNumber(this.confounder, byArray, n, this.dataSize - 8 - this.padding.length, this.padding)) {
            throw new GSSException(6, -1, "Corrupt checksum or sequence number in Wrap token");
        }
    }

    private byte[] getPadding(int n) {
        int n2 = 0;
        if (this.cipherHelper.isArcFour()) {
            n2 = 1;
        } else {
            n2 = n % 8;
            n2 = 8 - n2;
        }
        return pads[n2];
    }

    public WrapToken(Krb5Context krb5Context, MessageProp messageProp, byte[] byArray, int n, int n2) throws GSSException {
        super(513, krb5Context);
        this.confounder = Confounder.bytes(8);
        this.padding = this.getPadding(n2);
        this.dataSize = this.confounder.length + n2 + this.padding.length;
        this.dataBytes = byArray;
        this.dataOffset = n;
        this.dataLen = n2;
        this.genSignAndSeqNumber(messageProp, this.confounder, byArray, n, n2, this.padding);
        if (!krb5Context.getConfState()) {
            messageProp.setPrivacy(false);
        }
        this.privacy = messageProp.getPrivacy();
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException, GSSException {
        super.encode(outputStream);
        if (!this.privacy) {
            outputStream.write(this.confounder);
            outputStream.write(this.dataBytes, this.dataOffset, this.dataLen);
            outputStream.write(this.padding);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.dataBytes, this.dataOffset, this.dataLen, this.padding, outputStream);
        }
    }

    public byte[] encode() throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.dataSize + 50);
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public int encode(byte[] byArray, int n) throws IOException, GSSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        super.encode(byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        n += byArray2.length;
        if (!this.privacy) {
            System.arraycopy(this.confounder, 0, byArray, n, this.confounder.length);
            System.arraycopy(this.dataBytes, this.dataOffset, byArray, n += this.confounder.length, this.dataLen);
            System.arraycopy(this.padding, 0, byArray, n += this.dataLen, this.padding.length);
        } else {
            this.cipherHelper.encryptData(this, this.confounder, this.dataBytes, this.dataOffset, this.dataLen, this.padding, byArray, n);
        }
        return byArray2.length + this.confounder.length + this.dataLen + this.padding.length;
    }

    @Override
    protected int getKrb5TokenSize() throws GSSException {
        return this.getTokenSize() + this.dataSize;
    }

    @Override
    protected int getSealAlg(boolean bl, int n) throws GSSException {
        if (!bl) {
            return 65535;
        }
        return this.cipherHelper.getSealAlg();
    }

    static int getSizeLimit(int n, boolean bl, int n2, CipherHelper cipherHelper) throws GSSException {
        return GSSHeader.getMaxMechTokenSize(OID, n2) - (WrapToken.getTokenSize(cipherHelper) + 8) - 8;
    }
}

