/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import java.lang.management.CompilationMXBean;
import javax.management.ObjectName;
import sun.management.VMManagement;

class CompilationImpl
implements CompilationMXBean {
    private final VMManagement jvm;
    private final String name;

    CompilationImpl(VMManagement vMManagement) {
        this.jvm = vMManagement;
        this.name = this.jvm.getCompilerName();
        if (this.name == null) {
            throw new AssertionError((Object)"Null compiler name");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCompilationTimeMonitoringSupported() {
        return this.jvm.isCompilationTimeMonitoringSupported();
    }

    @Override
    public long getTotalCompilationTime() {
        if (!this.isCompilationTimeMonitoringSupported()) {
            throw new UnsupportedOperationException("Compilation time monitoring is not supported.");
        }
        return this.jvm.getTotalCompileTime();
    }

    @Override
    public ObjectName getObjectName() {
        return ObjectName.valueOf("java.lang:type=Compilation");
    }
}

